/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.utils;

import com.persagy.core.utils.CommonUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static final CloseableHttpClient httpClient;
    private static final String CHARSET = "UTF-8";

    static {
        InputStream inputStream = CommonUtils.class.getResourceAsStream("/config/system.properties");
        Properties properties = new Properties();
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String connectTimeout = properties.getProperty("httpclient.connect.timeout", "1000");
        String connectionRequestTimeout = properties.getProperty("httpclient.request.timeout", "1000");
        String socketTimeout = properties.getProperty("httpclient.socket.timeout", "3600000");
        String maxTotal = properties.getProperty("httpclient.pool.total", "1200");
        String defaultMaxPerRoute = properties.getProperty("httpclient.pool.per.route", "200");
        System.out.println("httpclient.connect.timeout\uff1a" + connectTimeout);
        System.out.println("httpclient.request.timeout\uff1a" + connectionRequestTimeout);
        System.out.println("httpclient.socket.timeout\uff1a" + socketTimeout);
        System.out.println("httpclient.pool.total\uff1a" + maxTotal);
        System.out.println("httpclient.pool.per.route\uff1a" + defaultMaxPerRoute);
        final String idleConnectionTimeout = properties.getProperty("httpclient.idle.timeout", "20000");
        System.out.println("httpclient.idle.timeout\uff1a" + idleConnectionTimeout);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(new Integer(connectTimeout).intValue()).setConnectionRequestTimeout(new Integer(connectionRequestTimeout).intValue()).setSocketTimeout(new Integer(socketTimeout).intValue()).build();
        final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(new Integer(maxTotal).intValue());
        connectionManager.setDefaultMaxPerRoute(new Integer(defaultMaxPerRoute).intValue());
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        ExecutorService es = Executors.newSingleThreadExecutor();
        es.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    CommonUtils.sleep(60000L);
                    System.out.println("\u5173\u95ed\u95f2\u7f6e" + idleConnectionTimeout + "\u6beb\u79d2\u53ca\u8fc7\u671f\u7684Http\u8fde\u63a5\u6c60\u94fe\u63a5\uff01");
                    connectionManager.closeExpiredConnections();
                    connectionManager.closeIdleConnections((long)new Integer(idleConnectionTimeout).intValue(), TimeUnit.MILLISECONDS);
                }
            }
        });
    }

    public static String post(String url, Map<String, Object> params, Boolean isMultipart) throws Exception {
        CloseableHttpResponse response;
        int statusCode;
        HttpEntity reqEntity = null;
        if (params != null && params.size() > 0) {
            Object obj;
            if (isMultipart != null && isMultipart.booleanValue()) {
                MultipartEntityBuilder meb = MultipartEntityBuilder.create();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    obj = entry.getValue();
                    FileBody contentBody = null;
                    if (obj instanceof File) {
                        contentBody = new FileBody((File)obj);
                        meb.addPart(entry.getKey(), (ContentBody)contentBody);
                        continue;
                    }
                    if (obj instanceof File[]) {
                        File[] fileArray = (File[])obj;
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            contentBody = new FileBody(file);
                            meb.addPart(entry.getKey(), (ContentBody)contentBody);
                            ++n2;
                        }
                        continue;
                    }
                    if (obj instanceof Date) {
                        obj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)obj);
                    }
                    contentBody = new StringBody(obj.toString(), ContentType.create((String)"text/plain", (Charset)Charset.forName(CHARSET)));
                    meb.addPart(entry.getKey(), (ContentBody)contentBody);
                }
                reqEntity = meb.build();
            } else {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    obj = entry.getValue();
                    if (obj instanceof Date) {
                        obj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)obj);
                    } else if (obj instanceof File) {
                        throw new Exception("please set isMultipart true");
                    }
                    pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
                }
                reqEntity = new UrlEncodedFormEntity(pairs, CHARSET);
            }
        }
        HttpPost httpPost = new HttpPost(url);
        if (reqEntity != null) {
            httpPost.setEntity(reqEntity);
        }
        if ((statusCode = (response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
            httpPost.abort();
            throw new RuntimeException("HttpClient,error status code :" + statusCode);
        }
        HttpEntity entity = response.getEntity();
        String result = null;
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return result;
    }

    public static void postFile(String url, Map<String, Object> params, String filePath) throws Exception {
        CloseableHttpResponse response;
        int statusCode;
        UrlEncodedFormEntity reqEntity = null;
        if (params != null && params.size() > 0) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Object obj = entry.getValue();
                if (obj instanceof Date) {
                    obj = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)obj);
                } else if (obj instanceof File) {
                    throw new Exception("please set isMultipart true");
                }
                pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
            }
            reqEntity = new UrlEncodedFormEntity(pairs, CHARSET);
        }
        HttpPost httpPost = new HttpPost(url);
        if (reqEntity != null) {
            httpPost.setEntity(reqEntity);
        }
        if ((statusCode = (response = httpClient.execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
            httpPost.abort();
            throw new RuntimeException("HttpClient,error status code :" + statusCode);
        }
        HttpEntity entity = response.getEntity();
        InputStream in = entity.getContent();
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[4096];
        int readLength = 0;
        while ((readLength = in.read(buffer)) > 0) {
            byte[] bytes = new byte[readLength];
            System.arraycopy(buffer, 0, bytes, 0, readLength);
            ((OutputStream)out).write(bytes);
        }
        out.flush();
        ((OutputStream)out).close();
        EntityUtils.consume((HttpEntity)entity);
        response.close();
    }

    public static String get(String url, Map<String, String> params) throws Exception {
        HttpGet httpGet;
        CloseableHttpResponse response;
        int statusCode;
        if (params != null && !params.isEmpty()) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                pairs.add(new BasicNameValuePair(entry.getKey(), value));
            }
            url = String.valueOf(url) + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, CHARSET));
        }
        if ((statusCode = (response = httpClient.execute((HttpUriRequest)(httpGet = new HttpGet(url)))).getStatusLine().getStatusCode()) != 200 && statusCode != 201) {
            httpGet.abort();
            throw new RuntimeException("HttpClient,error status code :" + statusCode);
        }
        HttpEntity entity = response.getEntity();
        String result = null;
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return result;
    }

    public static String postJson(String url, String json) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-type", "application/json; charset=utf-8");
        httpPost.setHeader("Accept", "application/json");
        httpPost.setEntity((HttpEntity)new StringEntity(json, Charset.forName(CHARSET)));
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200 && statusCode != 201) {
            httpPost.abort();
            throw new RuntimeException("HttpClient,error status code :" + statusCode);
        }
        HttpEntity entity = response.getEntity();
        String result = null;
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return result;
    }

    public static void main(String[] args) {
    }
}

