/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.thread;

import com.persagy.core.annotation.Month;
import com.persagy.core.annotation.Table;
import com.persagy.core.constant.SchemaConstant;
import com.persagy.core.constant.SystemSetting;
import com.persagy.core.dto.analysis.EMSAnalysis;
import com.persagy.core.enumeration.Schema;
import com.persagy.core.mvc.service.CoreService;
import com.persagy.core.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component(value="emsMonthThread")
public class EmsMonthThread
implements Runnable {
    private static Logger log = Logger.getLogger(EmsMonthThread.class);
    private static final Map<String, List<String>> tableMap = new ConcurrentHashMap<String, List<String>>();
    @Resource
    private SystemSetting systemSetting;
    @Resource(name="coreService")
    private CoreService coreService;
    private Boolean isRepairFinished;
    private Boolean isRefresh;

    @Override
    public void run() {
        if (this.systemSetting.getJdbcDriverClass().equals("com.mysql.jdbc.Driver")) {
            this.isRefresh = false;
            if (this.systemSetting.getSystemRepairTable().booleanValue()) {
                this.isRepairFinished = false;
                try {
                    this.repairTable();
                }
                catch (Exception e) {
                    log.info((Object)"MySql \u68c0\u67e5\u8868\u5931\u8d25 ......");
                    e.printStackTrace();
                }
            }
            this.isRepairFinished = true;
            while (true) {
                try {
                    while (true) {
                        log.info((Object)" ******* reset master \u5f00\u59cb ****** ");
                        this.resetMaster();
                        log.info((Object)" ******* reset master \u7ed3\u675f ****** ");
                        log.info((Object)" ******* \u5206\u8868\u5237\u65b0 \u5f00\u59cb ****** ");
                        this.refresh();
                        log.info((Object)" ******* \u5206\u8868\u5237\u65b0 \u6210\u529f\uff0c10\u5206\u949f\u540e\u7ee7\u7eed ****** ");
                        CommonUtils.sleep(600000L);
                    }
                }
                catch (Exception e) {
                    log.info((Object)" ******* \u5206\u8868\u5237\u65b0 \u5931\u8d25\uff0c1\u5206\u949f\u540e\u7ee7\u7eed ****** ");
                    e.printStackTrace();
                    CommonUtils.sleep(60000L);
                    continue;
                }
                break;
            }
        }
        this.isRepairFinished = true;
        this.isRefresh = true;
    }

    public static synchronized List<String> getTableList(String tableNameKey) {
        ArrayList<String> temp = new ArrayList<String>();
        if (tableMap.get(tableNameKey) != null) {
            temp.addAll((Collection<String>)tableMap.get(tableNameKey));
            Collections.sort(temp);
        }
        return temp;
    }

    public static synchronized void setTableList(String tableNameKey, String tableName) {
        List<String> tableList = tableMap.get(tableNameKey);
        if (tableList == null) {
            tableList = new CopyOnWriteArrayList<String>();
            tableMap.put(tableNameKey, tableList);
        }
        if (!tableList.contains(tableName)) {
            tableList.add(tableName);
        }
    }

    public void refresh() throws Exception {
        for (Class<?> cls : EMSAnalysis.getClassSet()) {
            if (!cls.isAnnotationPresent(Month.class)) continue;
            Table table = cls.getAnnotation(Table.class);
            String tableName = table.name();
            String schemaKey = table.schema().getValue();
            String schema = SchemaConstant.getSchema(schemaKey);
            StringBuffer sql = new StringBuffer(" select table_name from information_schema.tables ");
            sql.append(" where table_schema = '" + schema + "' and table_name like '______\\_" + tableName + "%' ");
            sql.append(" order by table_name ");
            List<Map<String, Object>> result = this.coreService.queryBySql(sql.toString(), null);
            for (Map<String, Object> map : result) {
                String splitTableName = (String)map.get("table_name");
                String tableKey = splitTableName.substring(7);
                EmsMonthThread.setTableList(tableKey, splitTableName);
            }
        }
        this.isRefresh = true;
    }

    public void resetMaster() {
        try {
            this.coreService.executeUpdate("reset master", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Boolean getIsRepairFinished() {
        return new Boolean(this.isRepairFinished);
    }

    private void repairTable() throws Exception {
        log.info((Object)"MySql \u68c0\u67e5\u8868\u5f00\u59cb ......");
        ArrayList<String> schemaList = new ArrayList<String>();
        schemaList.add(SchemaConstant.getSchema(Schema.WORKFLOW.getValue()));
        schemaList.add(SchemaConstant.getSchema(Schema.ORIGINALDATA.getValue()));
        schemaList.add(SchemaConstant.getSchema(Schema.METERDATA.getValue()));
        schemaList.add(SchemaConstant.getSchema(Schema.SERVICEDATA.getValue()));
        schemaList.add(SchemaConstant.getSchema(Schema.OBJECTDATA.getValue()));
        schemaList.add(SchemaConstant.getSchema(Schema.ENERGYDATA.getValue()));
        schemaList.add(SchemaConstant.getSchema(Schema.TENEMENTDATA.getValue()));
        schemaList.add(SchemaConstant.getSchema(Schema.EMSVDATA.getValue()));
        String sql = " select table_name from information_schema.tables where table_schema = ? ";
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (String schema : schemaList) {
            paramList.clear();
            paramList.add(schema);
            List<Map<String, Object>> result = this.coreService.queryBySql(sql, paramList);
            for (Map<String, Object> map : result) {
                String tableName = String.valueOf(schema) + "." + (String)map.get("table_name");
                String repairSql = "REPAIR TABLE " + tableName;
                log.info((Object)(" Repair " + tableName + " ... "));
                this.coreService.executeUpdate(repairSql, null);
            }
        }
        log.info((Object)"MySql \u68c0\u67e5\u8868\u7ed3\u675f ......");
    }

    public Boolean getIsRefresh() {
        if (this.isRefresh == null) {
            this.isRefresh = false;
        }
        return this.isRefresh;
    }
}

