/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.service;

import com.persagy.core.component.JsonObjectMapper;
import com.persagy.core.mvc.service.CoreService;
import com.persagy.core.service.BusinessService;
import java.lang.reflect.ParameterizedType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;

public abstract class BaseBusinessService<DTO>
implements BusinessService {
    private static final Logger log = Logger.getLogger(BaseBusinessService.class);
    @Resource(name="objectMapper")
    protected JsonObjectMapper objectMapper;
    @Resource(name="coreService")
    protected CoreService coreService;
    protected final SimpleDateFormat standard = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected final Date currentTime = new Date();

    @Override
    public void handle(String jsonString, List content) throws Exception {
        ParameterizedType type = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class cls = (Class)type.getActualTypeArguments()[0];
        Object dto = this.objectMapper.readValue(jsonString, cls);
        log.debug((Object)("\u53c2\u6570\u8f6c\u5316\u5bf9\u8c61\uff1a" + dto));
        this.handle(dto, content);
    }

    public abstract void handle(DTO var1, List var2) throws Exception;
}

