/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.mvc.service;

import com.persagy.core.enumeration.EMSOrder;
import com.persagy.core.mvc.dao.CoreDao;
import com.persagy.core.mvc.pojo.BusinessObject;
import com.persagy.core.mvc.service.CoreService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="coreService")
@Scope(value="prototype")
@Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
public class CoreServiceImpl
implements CoreService {
    @Resource(name="jdbcTemplateCoreDao")
    protected CoreDao coreDao;

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public int executeUpdate(String sql, List<Object> paramList) throws Exception {
        return this.coreDao.executeUpdate(sql, paramList);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
    public <T extends BusinessObject> List<T> query(String sql, List<Object> args, Class<T> cls) throws Exception {
        return this.coreDao.query(sql, args, cls);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
    public <T extends BusinessObject> List<T> query(T object) throws Exception {
        return this.coreDao.query(object);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
    public List<Map<String, Object>> queryBySql(String sql, List<Object> args) throws Exception {
        return this.coreDao.queryBySql(sql, args);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public <T extends BusinessObject> int remove(T object) throws Exception {
        return this.coreDao.remove(object);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public <T extends BusinessObject> int save(T object) throws Exception {
        return this.coreDao.save(object);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public <T extends BusinessObject> int update(T objectCriteria, T objectUpdate) throws Exception {
        return this.coreDao.update(objectCriteria, objectUpdate);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
    public int count(String sql, List<Object> args) throws Exception {
        return this.coreDao.count(sql, args);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
    public <T extends BusinessObject> int count(T object) throws Exception {
        return this.coreDao.count(object);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public <T extends BusinessObject> int save(List<T> list) throws Exception {
        int count = 0;
        if (list != null) {
            for (BusinessObject object : list) {
                count += this.save(object);
            }
        }
        return count;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public <T extends BusinessObject> int remove(List<T> list) throws Exception {
        int count = 0;
        if (list != null) {
            for (BusinessObject object : list) {
                count += this.remove(object);
            }
        }
        return count;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public <T extends BusinessObject> List<T> query(T object, Boolean isCascade) throws Exception {
        return this.coreDao.query(object, isCascade);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public <T extends BusinessObject> int remove(T object, Boolean isCascade) throws Exception {
        return this.coreDao.remove(object, isCascade);
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batchArgs) throws Exception {
        return this.coreDao.batchUpdate(sql, batchArgs);
    }

    @Override
    public <T extends BusinessObject> List<T> batchQuery(List<T> objectList, LinkedHashMap<String, EMSOrder> sortMap, Long skip, Long limit) throws Exception {
        return this.coreDao.batchQuery(objectList, sortMap, skip, limit);
    }
}

