/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.mvc.dialect.impl.oracle;

import com.persagy.core.dto.analysis.EMSColumnAnalysis;
import com.persagy.core.dto.analysis.EMSEntityAnalysis;
import com.persagy.core.dto.analysis.EMSIndexAnalysis;
import com.persagy.core.dto.analysis.EMSTableAnalysis;
import com.persagy.core.mvc.dialect.BaseDatabaseDialect;
import com.persagy.core.mvc.dialect.DatabaseDialect;
import com.persagy.core.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component(value="oracle.jdbc.driver.OracleDriver")
public class OracleDialect
extends BaseDatabaseDialect
implements DatabaseDialect {
    private static Logger log = Logger.getLogger(OracleDialect.class);

    @Override
    public String getPagingSql(String noPagingSql, Long skip, Long limit) {
        if (skip == null || skip < 0L) {
            skip = 0L;
        }
        if (limit == null || limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select * from (");
        sql.append("select tp.*,rownum rn from (" + noPagingSql + ") tp where rownum > " + skip);
        sql.append(") where rn <= " + (skip + limit));
        return sql.toString();
    }

    @Override
    public List<String> getCreateSchemaSql(String schemaName) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("CREATE USER " + schemaName + " IDENTIFIED BY 123456 ACCOUNT UNLOCK");
        list.add("GRANT CONNECT,RESOURCE,DBA TO " + schemaName);
        return list;
    }

    @Override
    public String getTableInfoSql() {
        return "SELECT lower(owner) table_schema, lower(table_name) table_name FROM DBA_TABLES";
    }

    @Override
    public String getTableNotExistCode() {
        return "942";
    }

    @Override
    public String getSchemaExistSql(String schemaName) {
        return "select * from all_users where username = upper('" + schemaName + "')";
    }

    @Override
    public String getDatabaseColumnType(Class<?> cls, Integer length, Integer scale) {
        String columnType = null;
        if (cls == String.class) {
            columnType = "varchar2";
        } else if (cls == Long.class || cls == Integer.class || cls == Boolean.class || cls == Double.class) {
            columnType = "number";
        } else if (cls == Date.class) {
            columnType = "date";
        } else {
            throw new RuntimeException("\u5bf9\u8c61\u5b57\u6bb5\u7c7b\u578b\u4e0d\u652f\u6301" + cls);
        }
        return columnType;
    }

    @Override
    public void init() throws Exception {
        log.info((Object)"******** Oracle\u914d\u7f6e\u521d\u59cb\u5316\u5f00\u59cb ********");
        HashMap<String, Object> root = new HashMap<String, Object>();
        for (Map.Entry<String, EMSEntityAnalysis> entityEntry : this.analysis.getEntityMap().entrySet()) {
            String entityKey = entityEntry.getKey();
            EMSEntityAnalysis entity = entityEntry.getValue();
            EMSTableAnalysis table = entity.getTable();
            ArrayList<EMSColumnAnalysis> columnList = new ArrayList<EMSColumnAnalysis>();
            for (Map.Entry<String, EMSColumnAnalysis> columnEntry : table.getColumnMap().entrySet()) {
                EMSColumnAnalysis column = new EMSColumnAnalysis();
                BeanUtils.copyProperties((Object)columnEntry.getValue(), (Object)column);
                if (column.getType().equals("date")) {
                    column.setLength(0);
                }
                if (column.getType().equals("varchar2") && column.getLength() > 4000) {
                    column.setLength(4000);
                }
                columnList.add(column);
            }
            Collections.sort(columnList);
            root.put("columnList", columnList);
            root.put("primaryKey", table.getPrimaryKey());
            ArrayList<String> ddlList = (ArrayList<String>)this.tableMap.get(entityKey);
            if (ddlList == null) {
                ddlList = new ArrayList<String>();
                this.tableMap.put(entityKey, ddlList);
            }
            String tableCreateSql = CommonUtils.getSqlByTemplate(root, "TableCreate.ftl");
            ddlList.add(tableCreateSql);
            root.clear();
            for (EMSIndexAnalysis index : table.getIndexList()) {
                root.put("index", index);
                ddlList.add(CommonUtils.getSqlByTemplate(root, "IndexCreate.ftl"));
            }
        }
        log.info((Object)"******** Oracle\u914d\u7f6e\u521d\u59cb\u5316\u7ed3\u675f ********");
    }
}

