/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.mvc.dialect.impl.mysql;

import com.persagy.core.dto.analysis.EMSColumnAnalysis;
import com.persagy.core.dto.analysis.EMSEntityAnalysis;
import com.persagy.core.dto.analysis.EMSIndexAnalysis;
import com.persagy.core.dto.analysis.EMSTableAnalysis;
import com.persagy.core.mvc.dialect.BaseDatabaseDialect;
import com.persagy.core.mvc.dialect.DatabaseDialect;
import com.persagy.core.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component(value="com.mysql.jdbc.Driver")
public class MySqlDialect
extends BaseDatabaseDialect
implements DatabaseDialect {
    private static Logger log = Logger.getLogger(MySqlDialect.class);

    @Override
    public String getPagingSql(String noPagingSql, Long skip, Long limit) {
        StringBuffer sql = new StringBuffer();
        sql.append(noPagingSql);
        if (skip == null || skip < 0L) {
            skip = 0L;
        }
        if (limit == null || limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        sql.append(" limit " + skip + "," + limit);
        return sql.toString();
    }

    @Override
    public List<String> getCreateSchemaSql(String schemaName) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("CREATE DATABASE " + schemaName + " DEFAULT CHARSET utf8 COLLATE utf8_general_ci");
        return list;
    }

    @Override
    public String getTableInfoSql() {
        return "select table_schema,table_name from information_schema.tables";
    }

    @Override
    public String getTableNotExistCode() {
        return "1146";
    }

    @Override
    public String getSchemaExistSql(String schemaName) {
        return "select * from information_schema.SCHEMATA where SCHEMA_NAME = '" + schemaName + "'";
    }

    @Override
    public String getDatabaseColumnType(Class<?> cls, Integer length, Integer scale) {
        String columnType = null;
        if (cls == String.class) {
            columnType = length > 4000 ? "mediumtext" : "varchar";
        } else if (cls == Long.class || cls == Integer.class || cls == Boolean.class) {
            columnType = "int";
        } else if (cls == Double.class) {
            columnType = "decimal";
        } else if (cls == Date.class) {
            columnType = "datetime";
        } else {
            throw new RuntimeException("\u5bf9\u8c61\u5b57\u6bb5\u7c7b\u578b\u4e0d\u652f\u6301" + cls);
        }
        return columnType;
    }

    @Override
    public void init() throws Exception {
        log.info((Object)"******** MySql\u914d\u7f6e\u521d\u59cb\u5316\u5f00\u59cb ********");
        HashMap<String, Object> root = new HashMap<String, Object>();
        for (Map.Entry<String, EMSEntityAnalysis> entityEntry : this.analysis.getEntityMap().entrySet()) {
            String entityKey = entityEntry.getKey();
            EMSEntityAnalysis entity = entityEntry.getValue();
            EMSTableAnalysis table = entity.getTable();
            ArrayList<EMSColumnAnalysis> columnList = new ArrayList<EMSColumnAnalysis>();
            for (Map.Entry<String, EMSColumnAnalysis> columnEntry : table.getColumnMap().entrySet()) {
                EMSColumnAnalysis column = new EMSColumnAnalysis();
                BeanUtils.copyProperties((Object)columnEntry.getValue(), (Object)column);
                if (column.getType().equals("mediumtext") || column.getType().equals("datetime")) {
                    column.setLength(0);
                }
                columnList.add(column);
            }
            Collections.sort(columnList);
            root.put("columnList", columnList);
            root.put("primaryKey", table.getPrimaryKey());
            root.put("database", "mysql");
            ArrayList<String> ddlList = (ArrayList<String>)this.tableMap.get(entityKey);
            if (ddlList == null) {
                ddlList = new ArrayList<String>();
                this.tableMap.put(entityKey, ddlList);
            }
            String tableCreateSql = CommonUtils.getSqlByTemplate(root, "TableCreate.ftl");
            String engine = null;
            engine = table.getTransaction() != false ? "InnoDB" : "MyISAM";
            tableCreateSql = String.valueOf(tableCreateSql) + " ENGINE=" + engine + " DEFAULT CHARSET=utf8";
            ddlList.add(tableCreateSql);
            root.clear();
            for (EMSIndexAnalysis index : table.getIndexList()) {
                root.put("index", index);
                ddlList.add(CommonUtils.getSqlByTemplate(root, "IndexCreate.ftl"));
            }
        }
        log.info((Object)"******** MySql\u914d\u7f6e\u521d\u59cb\u5316\u7ed3\u675f ********");
    }
}

