/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.mvc.dialect.impl.esgyn;

import com.persagy.core.constant.SystemConstant;
import com.persagy.core.dto.analysis.EMSColumnAnalysis;
import com.persagy.core.dto.analysis.EMSEntityAnalysis;
import com.persagy.core.dto.analysis.EMSIndexAnalysis;
import com.persagy.core.dto.analysis.EMSTableAnalysis;
import com.persagy.core.mvc.dialect.BaseDatabaseDialect;
import com.persagy.core.mvc.dialect.DatabaseDialect;
import com.persagy.core.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component(value="org.trafodion.jdbc.t4.T4Driver")
public class EsgynDialect
extends BaseDatabaseDialect
implements DatabaseDialect {
    private static Logger log = Logger.getLogger(EsgynDialect.class);

    @Override
    public String getPagingSql(String noPagingSql, Long skip, Long limit) {
        if ((skip == null || skip <= 0L) && limit == Long.MAX_VALUE) {
            return noPagingSql;
        }
        if (skip == null || skip < 0L) {
            skip = 0L;
        }
        StringBuffer sql = new StringBuffer();
        int selectIdx = noPagingSql.indexOf("select");
        String selectStr = noPagingSql.substring(0, selectIdx + 6);
        String otherStr = noPagingSql.substring(selectIdx + 6);
        int orderByIdx = otherStr.indexOf("order by");
        if (orderByIdx == -1) {
            throw new RuntimeException(" The sql is marked paging, so it must have order by clause. ");
        }
        String middleStr = otherStr.substring(0, orderByIdx);
        String orderByStr = otherStr.substring(orderByIdx);
        sql.append(" select * from (");
        sql.append(selectStr);
        sql.append(" ROW_NUMBER() OVER (" + orderByStr + ") as ems_rownum , ");
        sql.append(middleStr);
        sql.append(") ems where ems.ems_rownum between " + (skip + 1L) + " and " + (skip + limit));
        return sql.toString();
    }

    @Override
    public List<String> getCreateSchemaSql(String schemaName) {
        throw new RuntimeException("\u4e0d\u652f\u6301\u521b\u5efaSchema\uff01");
    }

    @Override
    public String getSchemaExistSql(String schemaName) {
        throw new RuntimeException("\u4e0d\u652f\u6301\u67e5\u8be2Schema\uff01");
    }

    @Override
    public String getTableInfoSql() {
        throw new RuntimeException("\u4e0d\u652f\u6301\u521b\u5efa\u8868\u4fe1\u606f\uff01");
    }

    @Override
    public String getTableNotExistCode() {
        return "-4082";
    }

    @Override
    public String getDatabaseColumnType(Class<?> cls, Integer length, Integer scale) {
        String columnType = null;
        if (cls == String.class) {
            columnType = "varchar";
        } else if (cls == Long.class || cls == Integer.class || cls == Boolean.class) {
            columnType = "int";
        } else if (cls == Double.class) {
            columnType = "numeric";
        } else if (cls == Date.class) {
            columnType = "timestamp";
        } else {
            throw new RuntimeException("\u5bf9\u8c61\u5b57\u6bb5\u7c7b\u578b\u4e0d\u652f\u6301" + cls);
        }
        return columnType;
    }

    @Override
    public void init() throws Exception {
        log.info((Object)"******** Esgyn\u914d\u7f6e\u521d\u59cb\u5316\u5f00\u59cb ********");
        HashMap<String, Object> root = new HashMap<String, Object>();
        for (Map.Entry<String, EMSEntityAnalysis> entityEntry : this.analysis.getEntityMap().entrySet()) {
            String entityKey = entityEntry.getKey();
            EMSEntityAnalysis entity = entityEntry.getValue();
            EMSTableAnalysis table = entity.getTable();
            ArrayList<EMSColumnAnalysis> columnList = new ArrayList<EMSColumnAnalysis>();
            for (Map.Entry<String, EMSColumnAnalysis> columnEntry : table.getColumnMap().entrySet()) {
                EMSColumnAnalysis column = new EMSColumnAnalysis();
                BeanUtils.copyProperties((Object)columnEntry.getValue(), (Object)column);
                if (column.getType().equals("timestamp")) {
                    column.setLength(0);
                }
                if (column.getType().equals("int")) {
                    column.setLength(0);
                }
                if (column.getType().equals("varchar") && column.getLength() > 16000) {
                    column.setLength(16000);
                }
                columnList.add(column);
            }
            Collections.sort(columnList);
            root.put("columnList", columnList);
            root.put("primaryKey", table.getPrimaryKey());
            root.put("database", "esgyn");
            ArrayList<String> ddlList = (ArrayList<String>)this.tableMap.get(entityKey);
            if (ddlList == null) {
                ddlList = new ArrayList<String>();
                this.tableMap.put(entityKey, ddlList);
            }
            String tableCreateSql = CommonUtils.getSqlByTemplate(root, "TableCreate.ftl");
            ddlList.add(tableCreateSql);
            root.clear();
            for (EMSIndexAnalysis index : table.getIndexList()) {
                root.put("index", index);
                ddlList.add(CommonUtils.getSqlByTemplate(root, "IndexCreate.ftl"));
            }
        }
        log.info((Object)"******** Esgyn\u914d\u7f6e\u521d\u59cb\u5316\u7ed3\u675f ********");
        System.out.println(SystemConstant.jsonMapper.writeValueAsString((Object)this.tableMap));
    }
}

