/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.mvc.dao.impl;

import com.persagy.core.annotation.Dimension;
import com.persagy.core.annotation.Entity;
import com.persagy.core.annotation.TimePatition;
import com.persagy.core.constant.SchemaConstant;
import com.persagy.core.constant.SystemConstant;
import com.persagy.core.constant.SystemSetting;
import com.persagy.core.dto.analysis.EMSAnalysis;
import com.persagy.core.dto.analysis.EMSColumnAnalysis;
import com.persagy.core.dto.analysis.EMSEntityAnalysis;
import com.persagy.core.dto.analysis.EMSIndexAnalysis;
import com.persagy.core.dto.analysis.EMSTableAnalysis;
import com.persagy.core.enumeration.EMSDimension;
import com.persagy.core.enumeration.EMSOrder;
import com.persagy.core.enumeration.SpecialOperator;
import com.persagy.core.enumeration.TimePatitionType;
import com.persagy.core.mvc.dao.CoreDao;
import com.persagy.core.mvc.pojo.BusinessObject;
import com.persagy.core.mvc.pojo.SpecialOperation;
import com.persagy.core.utils.CommonUtils;
import com.sagacloud.json.JSONArray;
import com.sagacloud.json.JSONObject;
import com.sagacloud.json.JSONValue;
import com.zillion.database.agent.ZillionAgent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;

@Repository(value="zillionDao")
public class ZillionDaoImpl
implements CoreDao {
    private static Logger log = Logger.getLogger(ZillionDaoImpl.class);
    protected Boolean isConnect = false;
    protected static Map<String, Set<String>> tableMap = new ConcurrentHashMap<String, Set<String>>();
    private static Map<Class, String> typeMap = new HashMap<Class, String>();
    private ZillionAgent agent;
    @Resource
    protected EMSAnalysis analysis;
    @Resource
    protected SystemSetting systemSetting;

    static {
        typeMap.put(Long.class, "Long");
        typeMap.put(Integer.class, "Long");
        typeMap.put(String.class, "String");
        typeMap.put(Boolean.class, "Boolean");
        typeMap.put(Double.class, "Double");
        typeMap.put(Date.class, "String");
    }

    @PostConstruct
    private void init() throws Exception {
        if (this.getClass() != ZillionDaoImpl.class) {
            return;
        }
        log.info((Object)"Zillion\u521d\u59cb\u5316\u5f00\u59cb......");
        System.out.println(this.getClass().getName());
        Properties properties = CommonUtils.loadProperties("/config/system.properties");
        String zillionAccess = properties.getProperty("zillion.access", "false");
        if (new Boolean(zillionAccess).booleanValue()) {
            HashSet<String> databaseSet = new HashSet<String>();
            for (Map.Entry<String, String> entry : SchemaConstant.getSchemaMap().entrySet()) {
                databaseSet.add(entry.getValue());
            }
            Configuration configuration = HBaseConfiguration.create();
            ZillionAgent agent = new ZillionAgent(configuration);
            agent.Start();
            this.isConnect = true;
            this.agent = agent;
            CommonUtils.sleep(1000L);
            LinkedHashMap<String, String> zillionMap = new LinkedHashMap<String, String>();
            zillionMap.put("QueryType", "database_list");
            String zillionSql = SystemConstant.jsonMapper.writeValueAsString(zillionMap);
            List<Map<String, Object>> list = this.queryBySql(zillionSql, null);
            zillionMap.put("QueryType", "table_list_strict");
            for (Map<String, Object> database : list) {
                String databaseName = (String)database.get("key");
                if (!databaseSet.contains(databaseName)) continue;
                log.info((Object)("\u521d\u59cb\u5316Hbase\uff1a" + databaseName));
                Set<String> set = tableMap.get(databaseName);
                if (set == null) {
                    set = Collections.synchronizedSet(new HashSet());
                    tableMap.put(databaseName, set);
                }
                zillionMap.put("Database", databaseName);
                zillionSql = SystemConstant.jsonMapper.writeValueAsString(zillionMap);
                List<Map<String, Object>> tableList = this.queryBySql(zillionSql, null);
                for (Map<String, Object> table : tableList) {
                    String tableName = (String)table.get("key");
                    set.add(tableName);
                }
            }
            log.info((Object)"Zillion\u5df2\u8fde\u63a5......");
        } else {
            log.info((Object)"Zillion\u672a\u8fde\u63a5......");
        }
        log.info((Object)"Zillion\u521d\u59cb\u5316\u7ed3\u675f......");
    }

    @PreDestroy
    private void destory() {
        if (this.isConnect.booleanValue()) {
            this.agent.Stop();
        }
    }

    protected void check() throws Exception {
        if (!this.isConnect.booleanValue()) {
            throw new Exception("zillion\u5ba2\u6237\u7aef\u672a\u8fde\u63a5\uff01");
        }
    }

    @Override
    public int executeUpdate(String sql, List<Object> args) throws Exception {
        JSONObject json;
        JSONObject result;
        this.check();
        if (this.systemSetting.getSystemPrintSql().booleanValue()) {
            log.info((Object)sql);
        }
        if (!"success".equals((String)(result = this.agent.Query(json = (JSONObject)JSONValue.parse((String)sql))).get((Object)"Result"))) {
            throw new Exception("\u64cd\u4f5c\u5931\u8d25\uff1a" + result.toJSONString());
        }
        Long count = 0L;
        JSONArray content = (JSONArray)result.get((Object)"Content");
        if (content != null && content.size() > 0) {
            if (content != null) {
                int i = 0;
                while (i < content.size()) {
                    JSONObject sub = (JSONObject)content.get(i);
                    Object o = sub.get((Object)"Count");
                    if (o == null) {
                        count = (Long)result.get((Object)"Count");
                        break;
                    }
                    count = count + (Long)sub.get((Object)"Count");
                    ++i;
                }
            }
        } else {
            count = (Long)result.get((Object)"Count");
        }
        return count.intValue();
    }

    @Override
    public List<Map<String, Object>> queryBySql(String sql, List<Object> args) throws Exception {
        JSONObject json;
        JSONObject result;
        this.check();
        if (this.systemSetting.getSystemPrintSql().booleanValue()) {
            log.info((Object)sql);
        }
        if (!"success".equals((String)(result = this.agent.Query(json = (JSONObject)JSONValue.parse((String)sql))).get((Object)"Result"))) {
            throw new Exception("\u64cd\u4f5c\u5931\u8d25\uff1a" + result);
        }
        Object content = result.get((Object)"Content");
        JSONArray jsonArray = null;
        if (content != null) {
            if (content instanceof JSONObject) {
                jsonArray = new JSONArray();
                jsonArray.add(content);
            } else if (content instanceof JSONArray) {
                jsonArray = (JSONArray)content;
            } else {
                throw new Exception("Content\u4e0d\u80fd\u8fa8\u6790\uff01");
            }
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (jsonArray != null) {
            List keyList = null;
            int i = 0;
            while (i < jsonArray.size()) {
                Object obj = jsonArray.get(i);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                if (obj instanceof JSONObject) {
                    JSONObject value = (JSONObject)obj;
                    if (keyList == null) {
                        keyList = value.keySet();
                    }
                    for (String key : keyList) {
                        map.put(key, value.get((Object)key));
                    }
                } else {
                    map.put("key", obj);
                }
                list.add(map);
                ++i;
            }
        }
        return list;
    }

    @Override
    public <T extends BusinessObject> List<T> query(String sql, List<Object> args, Class<T> cls) throws Exception {
        JSONObject json;
        JSONObject result;
        this.check();
        if (this.systemSetting.getSystemPrintSql().booleanValue()) {
            log.info((Object)sql);
        }
        if (!"success".equals((String)(result = this.agent.Query(json = (JSONObject)JSONValue.parse((String)sql))).get((Object)"Result"))) {
            throw new Exception("\u64cd\u4f5c\u5931\u8d25\uff1a" + result);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Entity entity = cls.getAnnotation(Entity.class);
        EMSEntityAnalysis entityAnalysis = this.analysis.getEntityMap().get(entity.name());
        EMSTableAnalysis tableAnalysis = entityAnalysis.getTable();
        Map<String, EMSColumnAnalysis> columnMap = tableAnalysis.getColumnMap();
        Set<Map.Entry<String, EMSColumnAnalysis>> set = columnMap.entrySet();
        ArrayList<BusinessObject> list = new ArrayList<BusinessObject>();
        JSONArray jsonArray = (JSONArray)result.get((Object)"Content");
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject map = (JSONObject)jsonArray.get(i);
            BusinessObject object = (BusinessObject)cls.newInstance();
            for (Map.Entry<String, EMSColumnAnalysis> entry : set) {
                EMSColumnAnalysis column = entry.getValue();
                PropertyDescriptor property = column.getPropertyDescriptor();
                Class<?> type = property.getPropertyType();
                Object columnValue = null;
                Object value = map.get((Object)column.getName());
                if (value == null) continue;
                if (type.equals(Integer.class)) {
                    columnValue = ((Number)value).intValue();
                } else if (type.equals(Long.class)) {
                    columnValue = ((Number)value).longValue();
                } else if (type.equals(Double.class)) {
                    columnValue = ((Number)value).doubleValue();
                } else if (type.equals(Date.class)) {
                    columnValue = sdf.parse((String)value);
                } else if (type.equals(Boolean.class)) {
                    columnValue = value;
                } else if (type.equals(String.class)) {
                    columnValue = value;
                }
                property.getWriteMethod().invoke((Object)object, columnValue);
            }
            list.add(object);
            ++i;
        }
        return list;
    }

    @Override
    public <T extends BusinessObject> List<T> query(T object) throws Exception {
        this.check();
        return this.query(object, false);
    }

    @Override
    public <T extends BusinessObject> List<T> query(T object, Boolean isCascade) throws Exception {
        this.check();
        if (object == null) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map<String, Object> zillionMap = this.createZillionMap(object);
        List<Map<String, Object>> criteriaList = this.buildCriteria(object);
        this.matchIndex(criteriaList, object.getClass());
        zillionMap.put("QueryType", "combine_select");
        zillionMap.put("Criterias", criteriaList);
        String zillionSql = SystemConstant.jsonMapper.writeValueAsString(zillionMap);
        List<?> list = this.query(zillionSql, null, object.getClass());
        return list;
    }

    @Override
    public <T extends BusinessObject> int save(T object) throws Exception {
        this.check();
        if (object == null) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, List<SpecialOperation>> specialOperateMap = new HashMap<String, List<SpecialOperation>>();
        object.setSpecialOperateMap(specialOperateMap);
        object.setSkip(null);
        object.setLimit(null);
        Map<String, Object> zillionMap = this.createZillionMap(object);
        zillionMap.put("QueryType", "insert");
        zillionMap.put("InsertObject", this.buildCriteria(object).get(0));
        String zillionSql = SystemConstant.jsonMapper.writeValueAsString(zillionMap);
        return this.executeUpdate(zillionSql, null);
    }

    @Override
    public <T extends BusinessObject> int remove(T object) throws Exception {
        this.check();
        return this.remove(object, false);
    }

    @Override
    public <T extends BusinessObject> int remove(T object, Boolean isCascade) throws Exception {
        this.check();
        object.setSkip(null);
        object.setLimit(null);
        Map<String, Object> zillionMap = this.createZillionMap(object);
        List<Map<String, Object>> criteriaList = this.buildCriteria(object);
        this.matchIndex(criteriaList, object.getClass());
        zillionMap.put("QueryType", "combine_delete");
        zillionMap.put("Criterias", criteriaList);
        String zillionSql = SystemConstant.jsonMapper.writeValueAsString(zillionMap);
        return this.executeUpdate(zillionSql, null);
    }

    @Override
    public <T extends BusinessObject> int update(T objectCriteria, T objectUpdate) throws Exception {
        this.check();
        if (objectCriteria == null) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (objectUpdate == null) {
            throw new Exception("\u66f4\u65b0\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        objectCriteria.setSkip(null);
        objectCriteria.setLimit(null);
        objectUpdate.setSkip(null);
        objectUpdate.setLimit(null);
        Map<String, Object> zillionMap = this.createZillionMap(objectCriteria);
        List<Map<String, Object>> criteriaList = this.buildCriteria(objectCriteria);
        Map<String, Object> zillionSetMap = this.buildCriteria(objectUpdate).get(0);
        this.matchIndex(criteriaList, objectCriteria.getClass());
        zillionMap.put("QueryType", "combine_update");
        zillionMap.put("Criterias", criteriaList);
        zillionMap.put("Set", zillionSetMap);
        String zillionSql = SystemConstant.jsonMapper.writeValueAsString(zillionMap);
        return this.executeUpdate(zillionSql, null);
    }

    @Override
    public <T extends BusinessObject> int batchUpdate(List<T> criteriaList, List<T> updateList) throws Exception {
        this.check();
        throw new Exception("\u6682\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\uff01");
    }

    @Override
    public int count(String sql, List<Object> args) throws Exception {
        JSONObject json;
        JSONObject result;
        if (this.systemSetting.getSystemPrintSql().booleanValue()) {
            log.info((Object)sql);
        }
        if (!"success".equals((String)(result = this.agent.Query(json = (JSONObject)JSONValue.parse((String)sql))).get((Object)"Result"))) {
            throw new Exception("\u64cd\u4f5c\u5931\u8d25\uff1a" + result);
        }
        Number count = (Number)result.get((Object)"Count");
        if (count == null) {
            return 0;
        }
        return count.intValue();
    }

    @Override
    public <T extends BusinessObject> int count(T object) throws Exception {
        this.check();
        if (object == null) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map<String, Object> zillionMap = this.createZillionMap(object);
        List<Map<String, Object>> criteriaList = this.buildCriteria(object);
        this.matchIndex(criteriaList, object.getClass());
        zillionMap.put("QueryType", "combine_select_count");
        zillionMap.put("Criterias", criteriaList);
        String zillionSql = SystemConstant.jsonMapper.writeValueAsString(zillionMap);
        return this.count(zillionSql, null);
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batchArgs) throws Exception {
        this.check();
        throw new Exception("\u6682\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\uff01");
    }

    @Override
    public <T extends BusinessObject> List<T> batchQuery(List<T> objectList, LinkedHashMap<String, EMSOrder> sortMap, Long skip, Long limit) throws Exception {
        this.check();
        if (objectList == null || objectList.size() == 0) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        throw new Exception("\u6682\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\uff01");
    }

    @Override
    public <T extends BusinessObject> int save(List<T> objectList) throws Exception {
        this.check();
        if (objectList == null || objectList.size() == 0) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (objectList.size() == 1) {
            return this.save((BusinessObject)objectList.get(0));
        }
        BusinessObject object = (BusinessObject)objectList.get(0);
        HashMap<String, List<SpecialOperation>> specialOperateMap = new HashMap<String, List<SpecialOperation>>();
        object.setSpecialOperateMap(specialOperateMap);
        object.setSkip(null);
        object.setLimit(null);
        ArrayList<Map<String, Object>> criteriaList = new ArrayList<Map<String, Object>>();
        for (BusinessObject temp : objectList) {
            criteriaList.addAll(this.buildCriteria(temp));
        }
        Map<String, Object> zillionMap = this.createZillionMap(object);
        zillionMap.put("QueryType", "batch_insert");
        zillionMap.put("InsertObjects", criteriaList);
        String zillionSql = SystemConstant.jsonMapper.writeValueAsString(zillionMap);
        return this.executeUpdate(zillionSql, null);
    }

    @Override
    public <T extends BusinessObject> int remove(List<T> objectList) throws Exception {
        this.check();
        if (objectList == null || objectList.size() == 0) {
            throw new Exception("\u67e5\u8be2\u5bf9\u8c61\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        throw new Exception("\u6682\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\uff01");
    }

    private <T extends BusinessObject> List<Map<String, Object>> buildCriteria(T object) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Class<?> cls = object.getClass();
        Entity entity = cls.getAnnotation(Entity.class);
        EMSEntityAnalysis entityAnalysis = this.analysis.getEntityMap().get(entity.name());
        EMSTableAnalysis tableAnalysis = entityAnalysis.getTable();
        Map<String, EMSColumnAnalysis> columnMap = tableAnalysis.getColumnMap();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> rangeCriteria = new HashMap<String, Map<String, Object>>();
        Integer index = 0;
        ArrayList<List> listCriteria = new ArrayList<List>();
        LinkedHashMap<Integer, String> indexMap = new LinkedHashMap<Integer, String>();
        for (Map.Entry<String, EMSColumnAnalysis> columnEntry : columnMap.entrySet()) {
            String propertyName = columnEntry.getKey();
            String column = columnEntry.getValue().getName();
            PropertyDescriptor property = new PropertyDescriptor(propertyName, object.getClass());
            Method readMethod = property.getReadMethod();
            Object value = null;
            Object temp = readMethod.invoke(object, new Object[0]);
            value = temp != null && temp instanceof Date ? sdf.format(temp) : temp;
            if (value != null) {
                criteria.put(column, value);
                continue;
            }
            List<SpecialOperation> list = object.getSpecialOperateMap().get(property.getName());
            if (list == null || list.size() <= 0) continue;
            for (SpecialOperation operation : list) {
                Object obj;
                SpecialOperator specialOperator = operation.getSpecialOperator();
                if (specialOperator == SpecialOperator.$in) {
                    List ObjectValueList = (List)List.class.cast(operation.getValue());
                    ArrayList valueList = new ArrayList();
                    for (Object obj2 : ObjectValueList) {
                        Object valueTemp = obj2 != null && obj2 instanceof Date ? sdf.format(obj2) : obj2;
                        valueList.add(valueTemp);
                    }
                    indexMap.put(index, column);
                    listCriteria.add(valueList);
                    index = index + 1;
                    continue;
                }
                if (specialOperator == SpecialOperator.$gte || specialOperator == SpecialOperator.$gt || specialOperator == SpecialOperator.$lte || specialOperator == SpecialOperator.$lt) {
                    obj = operation.getValue();
                    Object valueTemp = obj != null && obj instanceof Date ? sdf.format(obj) : obj;
                    LinkedHashMap<String, Object> tempCriteria = (LinkedHashMap<String, Object>)rangeCriteria.get(column);
                    if (tempCriteria == null) {
                        tempCriteria = new LinkedHashMap<String, Object>();
                        rangeCriteria.put(column, tempCriteria);
                    }
                    tempCriteria.put(specialOperator.name(), valueTemp);
                    continue;
                }
                if (specialOperator == SpecialOperator.$null) {
                    criteria.put(column, null);
                    continue;
                }
                if (specialOperator == SpecialOperator.$exists) {
                    obj = operation.getValue();
                    if (((Boolean)obj).booleanValue()) {
                        throw new Exception("\u4e0d\u652f\u6301is not null\u67e5\u8be2\uff01");
                    }
                    criteria.put(column, null);
                    continue;
                }
                throw new Exception("\u76ee\u524d\u53ea\u652f\u6301$in\u3001$gte\u3001$gt\u3001$lte\u3001$lt\u3001$exists=false\u64cd\u4f5c\uff01");
            }
        }
        ArrayList<Map<String, Object>> criteriaList = new ArrayList<Map<String, Object>>();
        this.buildFinalCriteriaList(criteria, rangeCriteria, listCriteria, indexMap, criteriaList);
        return criteriaList;
    }

    private void buildFinalCriteriaList(Map<String, Object> criteria, Map<String, Map<String, Object>> rangeCriteria, List<List> listCriteria, Map<Integer, String> indexMap, List<Map<String, Object>> criteriaList) {
        if (listCriteria.size() > 0) {
            ArrayList<Map<String, Object>> descartes = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            this.listRecursive(0, tempMap, indexMap, listCriteria, descartes);
            for (Map map : descartes) {
                LinkedHashMap<String, Object> criteriaFinal = new LinkedHashMap<String, Object>();
                criteriaFinal.putAll(criteria);
                criteriaFinal.putAll(map);
                criteriaFinal.putAll(rangeCriteria);
                criteriaList.add(criteriaFinal);
            }
        } else {
            LinkedHashMap<String, Object> criteriaFinal = new LinkedHashMap<String, Object>();
            criteriaFinal.putAll(criteria);
            criteriaFinal.putAll(rangeCriteria);
            criteriaList.add(criteriaFinal);
        }
    }

    private void listRecursive(Integer level, Map<String, Object> map, Map<Integer, String> indexMap, List<List> list, List<Map<String, Object>> descartes) {
        List valueList = list.get(level);
        String column = indexMap.get(level);
        for (Object value : valueList) {
            LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
            valueMap.putAll(map);
            valueMap.put(column, value);
            if (level == list.size() - 1) {
                descartes.add(valueMap);
                continue;
            }
            this.listRecursive(level + 1, valueMap, indexMap, list, descartes);
        }
    }

    private void matchIndex(List<Map<String, Object>> criteriaList, Class cls) throws Exception {
        Map<String, Object> criteria = criteriaList.get(0);
        if (criteria.size() == 0) {
            return;
        }
        Set<Map.Entry<String, Object>> entrySet = criteria.entrySet();
        Entity entity = cls.getAnnotation(Entity.class);
        EMSEntityAnalysis entityAnalysis = this.analysis.getEntityMap().get(entity.name());
        EMSTableAnalysis tableAnalysis = entityAnalysis.getTable();
        String primaryKey = tableAnalysis.getPrimaryKey();
        if (primaryKey != null && !"".equals(primaryKey) && criteria.get(primaryKey) != null && criteria.size() == 1) {
            return;
        }
        Exception e = null;
        for (EMSIndexAnalysis index : tableAnalysis.getIndexList()) {
            LinkedHashMap criteriaTemp = new LinkedHashMap();
            List<String> columnList = index.getColumnList();
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            int i = 0;
            while (i < columnList.size()) {
                indexMap.put(columnList.get(i), i);
                ++i;
            }
            if (criteria.size() > columnList.size()) {
                e = new Exception("\u67e5\u8be2\u6761\u4ef6\u4e2a\u6570\u5927\u4e8e\u7d22\u5f15\u5b57\u6bb5\u4e2a\u6570\u5224\u5b9a\u4e3a\u4e0d\u5339\u914d\u7d22\u5f15\uff01\n" + criteria);
                continue;
            }
            Boolean error1 = false;
            TreeMap<Integer, Map.Entry<String, Object>> criteriaSorted = new TreeMap<Integer, Map.Entry<String, Object>>();
            for (Map.Entry<String, Object> entry : entrySet) {
                Integer idx = (Integer)indexMap.get(entry.getKey());
                if (idx == null) {
                    error1 = true;
                    e = new Exception("\u67e5\u8be2\u6761\u4ef6\u4e0d\u5728\u7d22\u5f15\u5b57\u6bb5\u5185\u5224\u5b9a\u4e3a\u4e0d\u5339\u914d\u7d22\u5f15\uff01\n" + criteria);
                    break;
                }
                criteriaSorted.put(idx, entry);
            }
            if (error1.booleanValue()) continue;
            Boolean error2 = false;
            int sorted = 0;
            int rang = -1;
            for (Map.Entry entry : criteriaSorted.entrySet()) {
                if ((Integer)entry.getKey() != sorted) {
                    error2 = true;
                    e = new Exception("\u67e5\u8be2\u6761\u4ef6\u4e0d\u7b26\u5408\u7d22\u5f15\u5b57\u6bb5\u6392\u5e8f\u6392\u5b9a\u4e0d\u5339\u914d\u7d22\u5f15\uff01\n" + criteria);
                    break;
                }
                String key = (String)((Map.Entry)entry.getValue()).getKey();
                Object value = ((Map.Entry)entry.getValue()).getValue();
                if (rang == -1 && value instanceof Map) {
                    rang = (Integer)entry.getKey();
                }
                criteriaTemp.put(key, value);
                ++sorted;
            }
            if (error2.booleanValue()) continue;
            if (rang != -1 && rang != sorted - 1) {
                e = new Exception("\u53ea\u6709\u6700\u540e\u4e00\u4e2a\u67e5\u8be2\u6761\u4ef6\u53ef\u4ee5\u505a\u8303\u56f4\u67e5\u8be2\uff01\n" + criteria);
                continue;
            }
            e = null;
            criteria.clear();
            criteria.putAll(criteriaTemp);
            break;
        }
        if (e != null) {
            throw e;
        }
        entrySet = criteria.entrySet();
        int i = 1;
        while (i < criteriaList.size()) {
            Map<String, Object> criteriaOld = criteriaList.get(i);
            LinkedHashMap<String, Object> criteriaNew = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : entrySet) {
                criteriaNew.put(entry.getKey(), criteriaOld.get(entry.getKey()));
            }
            criteriaOld.clear();
            criteriaOld.putAll(criteriaNew);
            ++i;
        }
    }

    private <T extends BusinessObject> Map<String, Object> createZillionMap(T object) throws Exception {
        Entity entity = object.getClass().getAnnotation(Entity.class);
        EMSEntityAnalysis entityAnalysis = this.analysis.getEntityMap().get(entity.name());
        EMSTableAnalysis tableAnalysis = entityAnalysis.getTable();
        Map<String, EMSColumnAnalysis> columnMap = tableAnalysis.getColumnMap();
        String schema = tableAnalysis.getSchema().replaceAll(".dbo", "");
        String tableName = tableAnalysis.getName();
        Dimension dimension = object.getClass().getAnnotation(Dimension.class);
        TimePatition timePatition = object.getClass().getAnnotation(TimePatition.class);
        if (dimension.dimension() == EMSDimension.Time) {
            Integer splitTimeType = object.getSplitTimeType();
            if (splitTimeType == null) {
                throw new Exception("\u5206\u8868\u7c7b\u578b\u4e3aEMSDimension.Time\uff0c\u6240\u4ee5\u5bf9\u8c61\u5fc5\u987b\u660e\u786e\u6807\u8bc6splitTimeType\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (splitTimeType == 0) {
                tableName = String.valueOf(tableName) + "_15min";
            } else if (splitTimeType == 1) {
                tableName = String.valueOf(tableName) + "_1h";
            } else if (splitTimeType == 2) {
                tableName = String.valueOf(tableName) + "_1d";
            } else if (splitTimeType == 4) {
                tableName = String.valueOf(tableName) + "_1m";
            } else {
                throw new Exception("\u5206\u8868\u7c7b\u578b\u4e3aEMSDimension.Time\uff0c\u6240\u4ee5zillion\u7684splitTimeType\u5408\u6cd5\u503c\u4e3a0/1/2/4\uff01");
            }
        }
        ArrayList sortList = new ArrayList();
        for (Map.Entry<String, EMSOrder> entry : object.getSortMap().entrySet()) {
            String field = entry.getKey();
            EMSOrder order = entry.getValue();
            EMSColumnAnalysis column = columnMap.get(field);
            LinkedHashMap<String, Object> sortMap = new LinkedHashMap<String, Object>();
            sortMap.put("Column", column.getName());
            sortMap.put("Asc", order.getBooleanValue());
            sortList.add(sortMap);
        }
        LinkedHashMap<String, Long> limitMap = new LinkedHashMap<String, Long>();
        if (object.getSkip() != null) {
            limitMap.put("Skip", object.getSkip());
        }
        if (object.getLimit() != null) {
            limitMap.put("Count", object.getLimit());
        }
        LinkedHashMap<String, Object> zillionMap = new LinkedHashMap<String, Object>();
        zillionMap.put("Database", schema);
        zillionMap.put("Datatable", tableName);
        Set<String> tableSet = tableMap.get(schema);
        if (!tableSet.contains(tableName)) {
            Boolean find = false;
            LinkedHashMap<String, String> reCheckMap = new LinkedHashMap<String, String>();
            reCheckMap.put("QueryType", "table_list_strict");
            reCheckMap.put("Database", schema);
            String reCheckZillionSql = SystemConstant.jsonMapper.writeValueAsString(reCheckMap);
            List<Map<String, Object>> tableList = this.queryBySql(reCheckZillionSql, null);
            for (Map<String, Object> table : tableList) {
                String tableNameTemp = (String)table.get("key");
                if (!tableNameTemp.equals(tableName)) continue;
                find = true;
                tableSet.add(tableName);
                log.info((Object)("ZillionDao\u540c\u6b65\u8868\uff1a" + schema + "." + tableName));
                break;
            }
            if (!find.booleanValue()) {
                log.info((Object)("ZillionDao\u521b\u5efa\u8868\uff1a" + schema + "." + tableName));
                ArrayList columns = new ArrayList();
                ArrayList<String> key = new ArrayList<String>();
                ArrayList indexes = new ArrayList();
                LinkedHashMap<String, Object> definition = new LinkedHashMap<String, Object>();
                definition.put("table_type", "index_data");
                if (timePatition != null) {
                    if (timePatition.type() == TimePatitionType.month) {
                        definition.put("table_type", "split_month");
                    } else if (timePatition.type() == TimePatitionType.year) {
                        definition.put("table_type", "split_year");
                    }
                    definition.put("split_column", timePatition.column());
                }
                definition.put("Columns", columns);
                definition.put("Key", key);
                definition.put("Indexes", indexes);
                LinkedHashMap<String, Object> tableCreate = new LinkedHashMap<String, Object>();
                tableCreate.put("QueryType", "table_create");
                tableCreate.put("Database", schema);
                tableCreate.put("Datatable", tableName);
                tableCreate.put("Definition", definition);
                ArrayList<EMSColumnAnalysis> columnList = new ArrayList<EMSColumnAnalysis>();
                for (Map.Entry<String, EMSColumnAnalysis> columnEntry : tableAnalysis.getColumnMap().entrySet()) {
                    columnList.add(columnEntry.getValue());
                }
                Collections.sort(columnList);
                for (EMSColumnAnalysis columnAnalysis : columnList) {
                    LinkedHashMap<String, String> column = new LinkedHashMap<String, String>();
                    String type = typeMap.get(columnAnalysis.getPropertyDescriptor().getPropertyType());
                    if (type == null) {
                        throw new Exception("\u4e0d\u652f\u6301" + columnAnalysis.getPropertyDescriptor().getPropertyType().getName() + "\u7c7b\u578b\uff01");
                    }
                    column.put("Name", columnAnalysis.getName());
                    column.put("Type", type);
                    columns.add(column);
                }
                String primaryKey = tableAnalysis.getPrimaryKey();
                if (primaryKey != null && !"".equals(primaryKey)) {
                    key.add(primaryKey);
                }
                for (EMSIndexAnalysis indexAnalysis : tableAnalysis.getIndexList()) {
                    Boolean unique = indexAnalysis.getUnique();
                    if (unique != null && unique.booleanValue() && (primaryKey == null || "".equals(primaryKey))) {
                        key.addAll(indexAnalysis.getColumnList());
                        continue;
                    }
                    LinkedHashMap<String, Object> index = new LinkedHashMap<String, Object>();
                    index.put("Name", UUID.randomUUID().toString().replace("-", ""));
                    index.put("Columns", indexAnalysis.getColumnList());
                    indexes.add(index);
                }
                String zillionSql = SystemConstant.jsonMapper.writeValueAsString(tableCreate);
                this.queryBySql(zillionSql, null);
                tableSet.add(tableName);
            }
        }
        if (sortList.size() > 0) {
            zillionMap.put("OrderBy", sortList);
        }
        if (limitMap.size() > 0) {
            zillionMap.put("Limit", limitMap);
        }
        return zillionMap;
    }

    public ZillionAgent getAgent() {
        return this.agent;
    }
}

