/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.mvc.dao.impl;

import com.persagy.core.annotation.Entity;
import com.persagy.core.constant.SystemConstant;
import com.persagy.core.dto.analysis.EMSColumnAnalysis;
import com.persagy.core.dto.analysis.EMSEntityAnalysis;
import com.persagy.core.dto.analysis.EMSTableAnalysis;
import com.persagy.core.mvc.dao.CoreDao;
import com.persagy.core.mvc.dao.impl.ZillionDaoImpl;
import com.persagy.core.mvc.pojo.BusinessObject;
import com.persagy.core.utils.CommonUtils;
import com.persagy.core.utils.HttpUtils;
import com.sagacloud.json.JSONArray;
import com.sagacloud.json.JSONObject;
import com.sagacloud.json.JSONValue;
import java.beans.PropertyDescriptor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;

@Repository(value="sagaHttpDao")
public class SagaHttpDaoImpl
extends ZillionDaoImpl
implements CoreDao {
    private static Logger log = Logger.getLogger(SagaHttpDaoImpl.class);
    private String server = null;

    @PostConstruct
    private void init() throws Exception {
        log.info((Object)"SagaHttp\u521d\u59cb\u5316\u5f00\u59cb......");
        Properties properties = CommonUtils.loadProperties("/config/system.properties");
        String sagaZillionServer = properties.getProperty("saga.zillion.server", "http://192.168.20.225:8080/database/execute");
        String sagaZillionServerAccess = properties.getProperty("saga.zillion.server.access", "false");
        String sagaZillionServerUser = properties.getProperty("saga.zillion.server.user", "cu002");
        String sagaZillionServerSecret = properties.getProperty("saga.zillion.server.secret", "dbf54bde365d4e9c");
        this.server = String.valueOf(sagaZillionServer) + "?systemId=" + sagaZillionServerUser + "&secret=" + sagaZillionServerSecret;
        if (new Boolean(sagaZillionServerAccess).booleanValue()) {
            this.isConnect = true;
            Set<String> tableSet = Collections.synchronizedSet(new HashSet());
            tableMap.put("", tableSet);
            LinkedHashMap<String, String> zillionMap = new LinkedHashMap<String, String>();
            zillionMap.put("QueryType", "table_list");
            String zillionSql = SystemConstant.jsonMapper.writeValueAsString(zillionMap);
            try {
                List<Map<String, Object>> tableList = this.queryBySql(zillionSql, null);
                for (Map<String, Object> table : tableList) {
                    String tableName = (String)table.get("key");
                    tableSet.add(tableName);
                }
            }
            catch (Exception e) {
                this.isConnect = false;
                log.error((Object)("Zillion\u672a\u8fde\u63a5......[error]" + e));
            }
            log.info((Object)"Zillion\u5df2\u8fde\u63a5......");
        } else {
            log.info((Object)"Zillion\u672a\u8fde\u63a5......");
        }
        log.info((Object)"SagaHttp\u521d\u59cb\u5316\u7ed3\u675f......");
    }

    @Override
    public <T extends BusinessObject> List<T> query(String sql, List<Object> args, Class<T> cls) throws Exception {
        this.check();
        if (this.systemSetting.getSystemPrintSql().booleanValue()) {
            log.info((Object)sql);
        }
        String resultJson = HttpUtils.postJson(this.server, sql);
        JSONObject result = (JSONObject)JSONValue.parse((String)resultJson);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Entity entity = cls.getAnnotation(Entity.class);
        EMSEntityAnalysis entityAnalysis = this.analysis.getEntityMap().get(entity.name());
        EMSTableAnalysis tableAnalysis = entityAnalysis.getTable();
        Map<String, EMSColumnAnalysis> columnMap = tableAnalysis.getColumnMap();
        Set<Map.Entry<String, EMSColumnAnalysis>> set = columnMap.entrySet();
        ArrayList<BusinessObject> list = new ArrayList<BusinessObject>();
        JSONArray jsonArray = (JSONArray)result.get((Object)"Content");
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject map = (JSONObject)jsonArray.get(i);
            BusinessObject object = (BusinessObject)cls.newInstance();
            for (Map.Entry<String, EMSColumnAnalysis> entry : set) {
                EMSColumnAnalysis column = entry.getValue();
                PropertyDescriptor property = column.getPropertyDescriptor();
                Class<?> type = property.getPropertyType();
                Object columnValue = null;
                Object value = map.get((Object)column.getName());
                if (value == null) continue;
                if (type.equals(Integer.class)) {
                    columnValue = ((Number)value).intValue();
                } else if (type.equals(Long.class)) {
                    columnValue = ((Number)value).longValue();
                } else if (type.equals(Double.class)) {
                    columnValue = ((Number)value).doubleValue();
                } else if (type.equals(Date.class)) {
                    columnValue = sdf.parse((String)value);
                } else if (type.equals(Boolean.class)) {
                    columnValue = value;
                } else if (type.equals(String.class)) {
                    columnValue = value;
                }
                property.getWriteMethod().invoke((Object)object, columnValue);
            }
            list.add(object);
            ++i;
        }
        return list;
    }

    @Override
    public int executeUpdate(String sql, List<Object> args) throws Exception {
        Long count;
        String resultJson;
        JSONObject result;
        this.check();
        if (this.systemSetting.getSystemPrintSql().booleanValue()) {
            log.info((Object)sql);
        }
        if (!"success".equals((String)(result = (JSONObject)JSONValue.parse((String)(resultJson = HttpUtils.postJson(this.server, sql)))).get((Object)"Result"))) {
            throw new Exception("\u64cd\u4f5c\u5931\u8d25\uff1a" + result.toJSONString());
        }
        JSONArray content = (JSONArray)result.get((Object)"Content");
        if (content != null && content.size() > 0) {
            count = 0L;
            if (content != null) {
                int i = 0;
                while (i < content.size()) {
                    JSONObject sub = (JSONObject)content.get(i);
                    count = count + (Long)sub.get((Object)"Count");
                    ++i;
                }
            }
        } else {
            count = (Long)result.get((Object)"Count");
        }
        return count.intValue();
    }

    @Override
    public List<Map<String, Object>> queryBySql(String sql, List<Object> args) throws Exception {
        String resultJson;
        JSONObject result;
        this.check();
        if (this.systemSetting.getSystemPrintSql().booleanValue()) {
            log.info((Object)sql);
        }
        if (!"success".equals((String)(result = (JSONObject)JSONValue.parse((String)(resultJson = HttpUtils.postJson(this.server, sql)))).get((Object)"Result"))) {
            throw new Exception("\u64cd\u4f5c\u5931\u8d25\uff1a" + result);
        }
        Object content = result.get((Object)"Content");
        JSONArray jsonArray = null;
        if (content != null) {
            if (content instanceof JSONObject) {
                jsonArray = new JSONArray();
                jsonArray.add(content);
            } else if (content instanceof JSONArray) {
                jsonArray = (JSONArray)content;
            } else {
                throw new Exception("Content\u4e0d\u80fd\u8fa8\u6790\uff01");
            }
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (jsonArray != null) {
            List keyList = null;
            int i = 0;
            while (i < jsonArray.size()) {
                Object obj = jsonArray.get(i);
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                if (obj instanceof JSONObject) {
                    JSONObject value = (JSONObject)obj;
                    if (keyList == null) {
                        keyList = value.keySet();
                    }
                    for (String key : keyList) {
                        map.put(key, value.get((Object)key));
                    }
                } else {
                    map.put("key", obj);
                }
                list.add(map);
                ++i;
            }
        }
        return list;
    }
}

