/*
 * Decompiled with CFR 0.152.
 */
package com.persagy.core.constant;

import com.persagy.core.enumeration.SpecialOperator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EMSConstant {

    public static class DataType {
        public static final String TIME_TYPE = "timeType";
        public static final String ENERGY_TYPE_ID = "energyTypeId";
    }

    public static class Mark {
        public static final String EMS = "ems";
        public static final String UDM = "udm";
        public static final String EMSVDATA = "emsvdata";
        public static final String DATA = "data";
        public static final String TENANT = "tenant";
        public static final String WORKFLOW = "workflow";
        private static final Map<String, Boolean> setBuildingMap = new HashMap<String, Boolean>();

        static {
            setBuildingMap.put(EMS, false);
            setBuildingMap.put(UDM, false);
            setBuildingMap.put(EMSVDATA, true);
            setBuildingMap.put(DATA, true);
            setBuildingMap.put(TENANT, false);
            setBuildingMap.put(WORKFLOW, false);
        }

        public static Boolean isSetBuilding(String mark) {
            Boolean value = setBuildingMap.get(mark);
            if (value == null) {
                value = false;
            }
            return value;
        }
    }

    public static class Operation {
        public static final String INSERT = "insert";
        public static final String SELECT = "select";
        public static final String COUNT = "count";
        public static final String DELETE = "delete";
        public static final String UPDATE = "update";
    }

    public static class Operator {
        public static final String $REGEX = "$regex";
        public static final String $EXISTS = "$exists";
        public static final String $LT = "$lt";
        public static final String $LTE = "$lte";
        public static final String $GT = "$gt";
        public static final String $GTE = "$gte";
        public static final String $NE = "$ne";
        public static final String $IN = "$in";
        public static final String $NIN = "$nin";
        public static final String $ADDTOSET = "$addToSet";
        public static final String $PULL = "$pull";
        public static final String $ELEMMATCH = "$elemMatch";
        public static final String POINT = "\\.";
        public static final String $ = "\\.\\&\\.";
        private static final Set<String> criteriaSet = new HashSet<String>();
        private static final Map<String, SpecialOperator> specialOperatorMap;

        static {
            criteriaSet.add($LT);
            criteriaSet.add($LTE);
            criteriaSet.add($GT);
            criteriaSet.add($GTE);
            criteriaSet.add($NE);
            criteriaSet.add($IN);
            criteriaSet.add($NIN);
            criteriaSet.add($ELEMMATCH);
            specialOperatorMap = new HashMap<String, SpecialOperator>();
            specialOperatorMap.put($LT, SpecialOperator.$lt);
            specialOperatorMap.put($LTE, SpecialOperator.$lte);
            specialOperatorMap.put($GT, SpecialOperator.$gt);
            specialOperatorMap.put($GTE, SpecialOperator.$gte);
            specialOperatorMap.put($NE, SpecialOperator.$ne);
            specialOperatorMap.put($IN, SpecialOperator.$in);
            specialOperatorMap.put($NIN, SpecialOperator.$nin);
            specialOperatorMap.put(null, SpecialOperator.$null);
        }

        public static Boolean supportCriteria(String operator) {
            return criteriaSet.contains(operator);
        }

        public static SpecialOperator getSpecialOperator(String operator) {
            return specialOperatorMap.get(operator);
        }
    }

    public static class Result {
        public static final String VERSION = "version";
        public static final String RESULT = "result";
        public static final String CONTENT = "content";
        public static final String REASON = "reason";
        public static final String SUCCESS = "success";
        public static final String FAILURE = "failure";
    }

    public static class Structure {
        public static final String MARK = "mark";
        public static final String COLLECTION = "collection";
        public static final String VIEW = "view";
        public static final String TYPE = "type";
        public static final String BUILDING_SIGN = "buildingSign";
        public static final String DATA_TYPE = "dataType";
        public static final String OPERATION = "operation";
        public static final String CRITERIA = "criteria";
        public static final String INSERT_OBJ = "insertObj";
        public static final String UPDATE_OBJ = "updateObj";
        public static final String LIMIT = "limit";
        public static final String SKIP = "skip";
        public static final String SORT = "sort";
    }

    public static class Type {
        public static final String BUILDING = "building";
        public static final String UDM = "udm";
        private static final Map<String, Boolean> typeMap = new HashMap<String, Boolean>();

        static {
            typeMap.put(BUILDING, true);
            typeMap.put(UDM, true);
        }

        public static Boolean isType(String type) {
            Boolean value = typeMap.get(type);
            if (value == null) {
                value = false;
            }
            return value;
        }
    }
}

