/*
 * Decompiled with CFR 0.152.
 */
package org.zillion.util.json;

import com.sagacloud.json.JSONArray;
import com.sagacloud.json.JSONObject;
import com.sagacloud.json.JSONValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.zillion.util.common.MyException;

public class JSONReaderUtil {
    private static JSONReaderUtil instance = new JSONReaderUtil();

    public static JSONReaderUtil Instance() {
        return instance;
    }

    private JSONReaderUtil() {
    }

    public Object Read(File file) throws Exception {
        Object result = null;
        FileInputStream is = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader(is);
        result = JSONValue.parse((Reader)reader);
        ((Reader)reader).close();
        ((InputStream)is).close();
        return result;
    }

    public void Write(Object result, String filepath) throws Exception {
        if (result instanceof JSONObject) {
            this.WriteObject((JSONObject)result, filepath);
        } else if (result instanceof JSONArray) {
            this.WriteArray((JSONArray)result, filepath);
        } else {
            throw new MyException("JSONWrite: Object must be JSONObject/JSONArray");
        }
    }

    public void WriteObject(JSONObject result, String filepath) throws Exception {
        FileOutputStream os = new FileOutputStream(filepath);
        OutputStreamWriter writer = new OutputStreamWriter(os);
        result.writeFormatString((Writer)writer);
        ((Writer)writer).close();
        ((OutputStream)os).close();
    }

    public void WriteArray(JSONArray result, String filepath) throws Exception {
        FileOutputStream os = new FileOutputStream(filepath);
        OutputStreamWriter writer = new OutputStreamWriter(os);
        result.writeFormatString((Writer)writer);
        ((Writer)writer).close();
        ((OutputStream)os).close();
    }
}

