/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.async;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.database.async.AsyncJob;
import com.zillion.database.async.AsyncJobThread;
import com.zillion.database.async.AsyncResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.zillion.util.common.MyException;

public class AsyncJobRepository {
    static Map<String, AsyncJob> jobMap = new HashMap<String, AsyncJob>();
    static Map<String, AsyncJobThread> threadMap = new HashMap<String, AsyncJobThread>();

    public static synchronized void Add(AsyncJob job, AsyncJobThread thread) throws Exception {
        if (jobMap.containsKey(job.uuid)) {
            throw new MyException("UUID exist:" + job.uuid);
        }
        jobMap.put(job.uuid, job);
        threadMap.put(job.uuid, thread);
    }

    public static synchronized JSONObject QueryJobStatus(String uuid) throws Exception {
        if (!jobMap.containsKey(uuid)) {
            throw new MyException("UUID not exist:" + uuid);
        }
        JSONObject result = new JSONObject();
        AsyncJob job = jobMap.get(uuid);
        result.put("finish", (Object)job.IsFinish());
        result.put("success", (Object)job.success);
        result.put("exception", (Object)job.exception);
        result.put("count", (Object)job.count);
        result.put("queryResult", (Object)job.queryResult);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        result.put("time_start", (Object)sdf.format(job.time_start));
        if (job.time_end != null) {
            result.put("time_end", (Object)sdf.format(job.time_end));
        }
        return result;
    }

    public static synchronized void ClearJob(String uuid) throws Exception {
        if (!jobMap.containsKey(uuid)) {
            throw new MyException("UUID not exist:" + uuid);
        }
        AsyncJob job = jobMap.get(uuid);
        if (!job.IsFinish()) {
            throw new MyException("job not finish:" + uuid);
        }
        jobMap.remove(uuid);
        threadMap.remove(uuid);
    }

    public static synchronized JSONArray GetJobList() throws Exception {
        JSONArray result = new JSONArray();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (String uuid : jobMap.keySet()) {
            AsyncJob job = jobMap.get(uuid);
            JSONObject item = new JSONObject();
            item.put("uuid", (Object)job.uuid);
            item.put("finish", (Object)job.IsFinish());
            item.put("success", (Object)job.success);
            item.put("exception", (Object)job.exception);
            item.put("count", (Object)job.count);
            item.put("time_start", (Object)sdf.format(job.time_start));
            if (job.time_end != null) {
                item.put("time_end", (Object)sdf.format(job.time_end));
            }
            result.add((Object)item);
        }
        return result;
    }

    public static synchronized JSONArray RemoveTimeoutJob() throws Exception {
        JSONArray result = new JSONArray();
        Date currentTime = new Date();
        String[] uuids = jobMap.keySet().toArray(new String[0]);
        int i = 0;
        while (i < uuids.length) {
            String uuid = uuids[i];
            AsyncJob job = jobMap.get(uuid);
            if (job.IsFinish() && currentTime.getTime() - job.time_end.getTime() > 300000L) {
                result.add((Object)job.uuid);
                jobMap.remove(uuid);
                threadMap.remove(uuid);
            }
            ++i;
        }
        return result;
    }

    public static synchronized AsyncResultSet GetBufferedResultSet(String uuid) throws Exception {
        if (!jobMap.containsKey(uuid)) {
            throw new MyException("UUID not exist:" + uuid);
        }
        return AsyncJobRepository.jobMap.get((Object)uuid).brs;
    }
}

