/*
 * Decompiled with CFR 0.152.
 */
package org.zillion.util.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.util.common.JSONObjectComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemoryQueryUtil {
    private static MemoryQueryUtil instance = new MemoryQueryUtil();

    public static MemoryQueryUtil Instance() {
        return instance;
    }

    private MemoryQueryUtil() {
    }

    public JSONArray Delete(List<JSONObject> objectList, JSONObject criteria) {
        JSONArray Criterias = new JSONArray();
        Criterias.add((Object)criteria);
        return this.query_inner(objectList, Criterias, null, true);
    }

    public JSONArray Select(List<JSONObject> objectList, JSONObject criteria, JSONArray OrderBy) {
        JSONArray Criterias = new JSONArray();
        Criterias.add((Object)criteria);
        return this.query_inner(objectList, Criterias, OrderBy, false);
    }

    public JSONArray Select(List<JSONObject> objectList, JSONArray Criterias, JSONArray OrderBy) {
        return this.query_inner(objectList, Criterias, OrderBy, false);
    }

    private JSONArray query_inner(List<JSONObject> objectList, JSONArray Criterias, JSONArray OrderBy, boolean need_remove) {
        ArrayList<JSONObject> content = new ArrayList<JSONObject>();
        ArrayList PatternMapList = new ArrayList();
        int ii = 0;
        while (ii < Criterias.size()) {
            HashMap<String, Pattern> PatternMap = new HashMap<String, Pattern>();
            JSONObject criteria = (JSONObject)Criterias.get(ii);
            for (String key : criteria.keySet()) {
                JSONObject conditionJSON;
                Object condition = criteria.get((Object)key);
                if (!(condition instanceof JSONObject) || !(conditionJSON = (JSONObject)condition).containsKey((Object)"$regex")) continue;
                String regex = (String)conditionJSON.get((Object)"$regex");
                Pattern pattern = Pattern.compile(regex);
                PatternMap.put(key, pattern);
            }
            PatternMapList.add(PatternMap);
            ++ii;
        }
        int i = objectList.size() - 1;
        while (i >= 0) {
            JSONObject object = objectList.get(i);
            boolean has_all_match = false;
            int ii2 = 0;
            while (ii2 < Criterias.size()) {
                JSONObject criteria = (JSONObject)Criterias.get(ii2);
                Map PatternMap = (Map)PatternMapList.get(ii2);
                boolean all_match = true;
                for (String key : criteria.keySet()) {
                    Object itemValue = object.get((Object)key);
                    Object condition = criteria.get((Object)key);
                    Pattern Pattern2 = (Pattern)PatternMap.get(key);
                    if (this.Match(Pattern2, itemValue, condition)) continue;
                    all_match = false;
                    break;
                }
                if (all_match) {
                    has_all_match = true;
                    break;
                }
                ++ii2;
            }
            if (has_all_match) {
                content.add(object);
                if (need_remove) {
                    objectList.remove(i);
                }
            }
            --i;
        }
        if (OrderBy != null) {
            Collections.sort(content, new JSONObjectComparator(OrderBy));
        }
        JSONArray result = new JSONArray();
        for (JSONObject item : content) {
            result.add((Object)item);
        }
        return result;
    }

    private boolean Match(Pattern Pattern2, Object itemValue, Object condition) {
        if (condition == null) {
            return itemValue == null;
        }
        if (condition instanceof JSONObject) {
            JSONObject conditionJSON = (JSONObject)condition;
            boolean all_match = true;
            for (String key : conditionJSON.keySet()) {
                Object valueInner;
                if (this.MatchItem(Pattern2, itemValue, key, valueInner = conditionJSON.get((Object)key))) continue;
                all_match = false;
                break;
            }
            return all_match;
        }
        return this.MatchItem(null, itemValue, "$e", condition);
    }

    private boolean MatchItem(Pattern Pattern2, Object itemValue, String operator, Object valueInner) {
        if (operator.equals("in")) {
            boolean in_exist = false;
            JSONArray valueArray = (JSONArray)valueInner;
            int i = 0;
            while (i < valueArray.size()) {
                Object valueObject = valueArray.get(i);
                if (this.MatchItem(Pattern2, itemValue, "$e", valueObject)) {
                    in_exist = true;
                    break;
                }
                ++i;
            }
            return in_exist;
        }
        if (operator.equals("$regex")) {
            if (itemValue == null) {
                return false;
            }
            Matcher matcher = Pattern2.matcher((String)itemValue);
            return matcher.matches();
        }
        if (itemValue == null || valueInner == null) {
            if (operator.equals("$e")) {
                return itemValue == null && valueInner == null;
            }
            if (operator.equals("$lt")) {
                return itemValue == null && valueInner != null;
            }
            if (operator.equals("$lte")) {
                return itemValue == null;
            }
            if (operator.equals("$gt")) {
                return itemValue != null;
            }
            if (operator.equals("$gte")) {
                return valueInner == null;
            }
            return false;
        }
        if (itemValue instanceof Boolean && valueInner instanceof Boolean) {
            long v1 = (Boolean)itemValue != false ? 1 : 0;
            long v2 = (Boolean)valueInner != false ? 1 : 0;
            if (operator.equals("$e")) {
                return v1 == v2;
            }
            if (operator.equals("$lt")) {
                return v1 < v2;
            }
            if (operator.equals("$lte")) {
                return v1 <= v2;
            }
            if (operator.equals("$gt")) {
                return v1 > v2;
            }
            if (operator.equals("$gte")) {
                return v1 >= v2;
            }
            return false;
        }
        if (itemValue instanceof Long && valueInner instanceof Long) {
            long v1 = (Long)itemValue;
            long v2 = (Long)valueInner;
            if (operator.equals("$e")) {
                return v1 == v2;
            }
            if (operator.equals("$lt")) {
                return v1 < v2;
            }
            if (operator.equals("$lte")) {
                return v1 <= v2;
            }
            if (operator.equals("$gt")) {
                return v1 > v2;
            }
            if (operator.equals("$gte")) {
                return v1 >= v2;
            }
            return false;
        }
        if (itemValue instanceof Double && valueInner instanceof Double) {
            double v1 = (Double)itemValue;
            double v2 = (Double)valueInner;
            if (operator.equals("$e")) {
                return v1 == v2;
            }
            if (operator.equals("$lt")) {
                return v1 < v2;
            }
            if (operator.equals("$lte")) {
                return v1 <= v2;
            }
            if (operator.equals("$gt")) {
                return v1 > v2;
            }
            if (operator.equals("$gte")) {
                return v1 >= v2;
            }
            return false;
        }
        if (itemValue instanceof String && valueInner instanceof String) {
            String v1 = (String)itemValue;
            String v2 = (String)valueInner;
            if (operator.equals("$e")) {
                return v1.equals(v2);
            }
            if (operator.equals("$lt")) {
                return v1.compareTo(v2) < 0;
            }
            if (operator.equals("$lte")) {
                return v1.compareTo(v2) <= 0;
            }
            if (operator.equals("$gt")) {
                return v1.compareTo(v2) > 0;
            }
            if (operator.equals("$gte")) {
                return v1.compareTo(v2) >= 0;
            }
            return false;
        }
        return false;
    }

    public void SetColumn(JSONObject object, String Name, String Multiplicity, List<?> objectListInner) {
        if (Multiplicity.equals("1") || Multiplicity.equals("0..1")) {
            if (objectListInner.size() > 0) {
                object.put(Name, objectListInner.get(0));
            } else {
                object.put(Name, null);
            }
        } else if (Multiplicity.equals("0..n")) {
            JSONArray objectItems = new JSONArray();
            int index_objectSub = 0;
            while (index_objectSub < objectListInner.size()) {
                objectItems.add(objectListInner.get(index_objectSub));
                ++index_objectSub;
            }
            object.put(Name, (Object)objectItems);
        }
    }
}

