/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferBackedDataInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.PureJavaCrc32;
import org.jetbrains.annotations.NotNull;

public final class FileInput
implements ByteBufferBackedDataInput {
    private ByteBuffer buf;
    private FileIO io;
    private long pos;
    private ByteBufferExpander expBuf;

    public FileInput(FileIO io, ByteBufferExpander buf) throws IOException {
        assert (io != null);
        this.io = io;
        this.buf = buf.buffer();
        this.expBuf = buf;
        this.pos = io.position();
        this.clearBuffer();
    }

    public FileIO io() {
        return this.io;
    }

    private void clearBuffer() {
        this.buf.clear();
        this.buf.limit(0);
        assert (this.buf.remaining() == 0);
    }

    public void seek(long pos) throws IOException {
        if (pos > this.io.size()) {
            throw new EOFException();
        }
        this.io.position(pos);
        this.pos = pos;
        this.clearBuffer();
    }

    @Override
    public ByteBuffer buffer() {
        return this.buf;
    }

    @Override
    public void ensure(int requested) throws IOException {
        int read;
        int available = this.buf.remaining();
        if (available >= requested) {
            return;
        }
        if (this.buf.capacity() < requested) {
            if (this.expBuf == null) {
                throw new IOException("Requested size is greater than buffer: " + requested);
            }
            this.buf = this.expBuf.expand(requested);
            assert (available == this.buf.remaining());
        }
        this.buf.compact();
        do {
            if ((read = this.io.read(this.buf)) == -1) {
                throw new EOFException("EOF at position [" + this.io.position() + "] expected to read [" + requested + "] bytes");
            }
            this.pos += (long)read;
        } while ((available += read) < requested);
        this.buf.flip();
    }

    public long position() {
        return this.pos - (long)this.buf.remaining();
    }

    @Override
    public void readFully(@NotNull byte[] b) throws IOException {
        this.ensure(b.length);
        this.buf.get(b);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) throws IOException {
        this.ensure(len);
        this.buf.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (this.buf.remaining() >= n) {
            this.buf.position(this.buf.position() + n);
        } else {
            this.seek(this.pos + (long)n);
        }
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        this.ensure(1);
        return this.buf.get();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        this.ensure(2);
        return this.buf.getShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        this.ensure(2);
        return this.buf.getChar();
    }

    @Override
    public int readInt() throws IOException {
        this.ensure(4);
        return this.buf.getInt();
    }

    @Override
    public long readLong() throws IOException {
        this.ensure(8);
        return this.buf.getLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.ensure(4);
        return this.buf.getFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.ensure(8);
        return this.buf.getDouble();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Crc32CheckingFileInput startRead(boolean skipCheck) {
        return new Crc32CheckingFileInput(this.buf.position(), skipCheck);
    }

    public class Crc32CheckingFileInput
    implements ByteBufferBackedDataInput,
    AutoCloseable {
        private final PureJavaCrc32 crc32 = new PureJavaCrc32();
        private int lastCalcPosition;
        private boolean skipCheck;

        public Crc32CheckingFileInput(int position, boolean skipCheck) {
            this.lastCalcPosition = position;
            this.skipCheck = skipCheck;
        }

        @Override
        public void ensure(int requested) throws IOException {
            int available = FileInput.this.buf.remaining();
            if (available >= requested) {
                return;
            }
            this.updateCrc();
            FileInput.this.ensure(requested);
            this.lastCalcPosition = 0;
        }

        @Override
        public void close() throws Exception {
            this.updateCrc();
            int val = this.crc32.getValue();
            int writtenCrc = this.readInt();
            if ((val ^ writtenCrc) != 0 && !this.skipCheck) {
                this.ensure(5);
                throw new IgniteDataIntegrityViolationException("val: " + val + " writtenCrc: " + writtenCrc);
            }
        }

        private void updateCrc() {
            if (this.skipCheck) {
                return;
            }
            int oldPos = FileInput.this.buf.position();
            FileInput.this.buf.position(this.lastCalcPosition);
            this.crc32.update(FileInput.this.buf, oldPos - this.lastCalcPosition);
            this.lastCalcPosition = oldPos;
        }

        @Override
        public int skipBytes(int n) throws IOException {
            this.ensure(n);
            int skipped = Math.min(FileInput.this.buf.remaining(), n);
            FileInput.this.buf.position(FileInput.this.buf.position() + skipped);
            return skipped;
        }

        @Override
        public void readFully(@NotNull byte[] b) throws IOException {
            this.ensure(b.length);
            FileInput.this.buf.get(b);
        }

        @Override
        public void readFully(@NotNull byte[] b, int off, int len) throws IOException {
            this.ensure(len);
            FileInput.this.buf.get(b, off, len);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.readByte() == 1;
        }

        @Override
        public byte readByte() throws IOException {
            this.ensure(1);
            return FileInput.this.buf.get();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.readByte() & 0xFF;
        }

        @Override
        public short readShort() throws IOException {
            this.ensure(2);
            return FileInput.this.buf.getShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.readShort() & 0xFFFF;
        }

        @Override
        public char readChar() throws IOException {
            this.ensure(2);
            return FileInput.this.buf.getChar();
        }

        @Override
        public int readInt() throws IOException {
            this.ensure(4);
            return FileInput.this.buf.getInt();
        }

        @Override
        public long readLong() throws IOException {
            this.ensure(8);
            return FileInput.this.buf.getLong();
        }

        @Override
        public float readFloat() throws IOException {
            this.ensure(4);
            return FileInput.this.buf.getFloat();
        }

        @Override
        public double readDouble() throws IOException {
            this.ensure(8);
            return FileInput.this.buf.getDouble();
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer buffer() {
            return FileInput.this.buffer();
        }
    }
}

