/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs;

import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.igfs.IgfsIpcEndpointType;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgfsIpcEndpointConfiguration {
    public static IgfsIpcEndpointType DFLT_TYPE = U.hasSharedMemory() ? IgfsIpcEndpointType.SHMEM : IgfsIpcEndpointType.TCP;
    public static String DFLT_HOST = "127.0.0.1";
    public static int DFLT_PORT = 10500;
    public static final int DFLT_MEM_SIZE = 262144;
    public static final String DFLT_TOKEN_DIR_PATH = "ipc/shmem";
    public static final int DFLT_THREAD_CNT = IgniteConfiguration.AVAILABLE_PROC_CNT;
    private IgfsIpcEndpointType type = DFLT_TYPE;
    private String host = DFLT_HOST;
    private int port = DFLT_PORT;
    private int memSize = 262144;
    private String tokenDirPath = "ipc/shmem";
    private int threadCnt = DFLT_THREAD_CNT;

    public IgfsIpcEndpointConfiguration() {
    }

    public IgfsIpcEndpointConfiguration(IgfsIpcEndpointConfiguration cfg) {
        this.type = cfg.getType();
        this.host = cfg.getHost();
        this.port = cfg.getPort();
        this.memSize = cfg.getMemorySize();
        this.tokenDirPath = cfg.getTokenDirectoryPath();
    }

    public IgfsIpcEndpointType getType() {
        return this.type;
    }

    public IgfsIpcEndpointConfiguration setType(IgfsIpcEndpointType type) {
        this.type = type;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public IgfsIpcEndpointConfiguration setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public IgfsIpcEndpointConfiguration setPort(int port) {
        this.port = port;
        return this;
    }

    public int getMemorySize() {
        return this.memSize;
    }

    public IgfsIpcEndpointConfiguration setMemorySize(int memSize) {
        this.memSize = memSize;
        return this;
    }

    public String getTokenDirectoryPath() {
        return this.tokenDirPath;
    }

    public IgfsIpcEndpointConfiguration setTokenDirectoryPath(String tokenDirPath) {
        this.tokenDirPath = tokenDirPath;
        return this;
    }

    public int getThreadCount() {
        return this.threadCnt;
    }

    public IgfsIpcEndpointConfiguration setThreadCount(int threadCnt) {
        this.threadCnt = threadCnt;
        return this;
    }

    public String toString() {
        return S.toString(IgfsIpcEndpointConfiguration.class, this);
    }
}

