/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.wrappers;

import java.util.concurrent.Callable;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;

public class TraceCallable<V>
implements Callable<V> {
    private final Callable<V> impl;
    private final Span parent;
    private final String description;

    public TraceCallable(Callable<V> impl) {
        this(Trace.currentSpan(), impl);
    }

    public TraceCallable(Span parent, Callable<V> impl) {
        this(parent, impl, null);
    }

    public TraceCallable(Span parent, Callable<V> impl, String description) {
        this.impl = impl;
        this.parent = parent;
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        if (this.parent != null) {
            TraceScope chunk = Trace.startSpan(this.getDescription(), this.parent);
            try {
                V v = this.impl.call();
                return v;
            }
            finally {
                chunk.close();
            }
        }
        return this.impl.call();
    }

    public Callable<V> getImpl() {
        return this.impl;
    }

    private String getDescription() {
        return this.description == null ? Thread.currentThread().getName() : this.description;
    }
}

