/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.json;

import com.sagacloud.json.JSONAware;
import com.sagacloud.json.JSONItem;
import com.sagacloud.json.JSONStreamAware;
import com.sagacloud.json.JSONValue;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObject
implements JSONAware,
JSONStreamAware {
    List<String> keyList = new ArrayList<String>();
    List<JSONItem> valueList = new ArrayList<JSONItem>();

    @Override
    public String toFormatString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator<String> iter = this.keySet().iterator();
        sb.append('{');
        while (iter.hasNext()) {
            String key = iter.next();
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append("\r\n\t");
            sb.append('\"');
            JSONValue.escape(key, sb);
            sb.append('\"').append(':');
            String valueString = JSONValue.toFormatString(this.get(key));
            sb.append(valueString.replaceAll("\r\n", "\r\n\t"));
        }
        sb.append("\r\n");
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void writeFormatString(Writer out) throws IOException {
        out.write(this.toFormatString());
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        boolean first = true;
        Iterator<String> iter = this.keySet().iterator();
        out.write(123);
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                out.write(44);
            }
            String key = iter.next();
            out.write(34);
            out.write(JSONValue.escape(String.valueOf(key)));
            out.write(34);
            out.write(58);
            JSONValue.writeJSONString(this.get(key), out);
        }
        out.write(125);
    }

    @Override
    public String toJSONString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Iterator<String> iter = this.keySet().iterator();
        sb.append('{');
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            String key = iter.next();
            sb.append('\"');
            if (key == null) {
                sb.append("null");
            } else {
                JSONValue.escape(key, sb);
            }
            sb.append('\"').append(':');
            sb.append(JSONValue.toJSONString(this.get(key)));
        }
        sb.append('}');
        return sb.toString();
    }

    public String toString() {
        return this.toJSONString();
    }

    public boolean containsKey(Object key) {
        for (int i = 0; i < this.keyList.size(); ++i) {
            String keyInner = this.keyList.get(i);
            if (!keyInner.equals(key)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        for (int i = 0; i < this.keyList.size(); ++i) {
            String keyInner = this.keyList.get(i);
            if (!keyInner.equals(key)) continue;
            JSONItem value = this.valueList.get(i);
            return value.Value();
        }
        return null;
    }

    public Object put(Object key, Object value) {
        String keyString = (String)key;
        this.remove(keyString);
        this.keyList.add(keyString);
        JSONItem valueJSON = new JSONItem(value);
        this.valueList.add(valueJSON);
        return value;
    }

    public void clear() {
        this.keyList.clear();
        this.valueList.clear();
    }

    public List<String> keySet() {
        return this.keyList;
    }

    public void remove(String key) {
        for (int i = this.keyList.size() - 1; i >= 0; --i) {
            String keyInner = this.keyList.get(i);
            if (!keyInner.equals(key)) continue;
            this.keyList.remove(i);
            this.valueList.remove(i);
        }
    }

    public int size() {
        return this.keyList.size();
    }
}

