/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClusterNode;
import org.jetbrains.annotations.Nullable;

class ZkJoinEventDataForJoined
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final List<ZookeeperClusterNode> top;
    private final Map<Long, byte[]> discoData;
    private final Map<Long, Long> dupDiscoData;

    ZkJoinEventDataForJoined(List<ZookeeperClusterNode> top, Map<Long, byte[]> discoData, @Nullable Map<Long, Long> dupDiscoData) {
        assert (top != null);
        assert (discoData != null && !discoData.isEmpty());
        this.top = top;
        this.discoData = discoData;
        this.dupDiscoData = dupDiscoData;
    }

    byte[] discoveryDataForNode(long nodeOrder) {
        assert (this.discoData != null);
        byte[] dataBytes = this.discoData.get(nodeOrder);
        if (dataBytes != null) {
            return dataBytes;
        }
        assert (this.dupDiscoData != null);
        Long dupDataNode = this.dupDiscoData.get(nodeOrder);
        assert (dupDataNode != null);
        dataBytes = this.discoData.get(dupDataNode);
        assert (dataBytes != null);
        return dataBytes;
    }

    List<ZookeeperClusterNode> topology() {
        assert (this.top != null);
        return this.top;
    }
}

