/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2PlainRowFactory;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeTable;
import org.apache.ignite.internal.processors.query.h2.twostep.GridResultPage;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;

public final class GridMergeIndexUnsorted
extends GridMergeIndex {
    private static final IndexType TYPE = IndexType.createScan((boolean)false);
    private final PollableQueue<GridResultPage> queue = new PollableQueue();
    private final AtomicInteger activeSources = new AtomicInteger(-1);
    private Iterator<Value[]> iter = Collections.emptyIterator();

    public GridMergeIndexUnsorted(GridKernalContext ctx, GridMergeTable tbl, String name) {
        super(ctx, tbl, name, TYPE, IndexColumn.wrap((Column[])tbl.getColumns()));
    }

    public static GridMergeIndexUnsorted createDummy(GridKernalContext ctx) {
        return new GridMergeIndexUnsorted(ctx);
    }

    private GridMergeIndexUnsorted(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void setSources(Collection<ClusterNode> nodes, int segmentsCnt) {
        super.setSources(nodes, segmentsCnt);
        int x = nodes.size() * segmentsCnt;
        assert (x > 0) : x;
        this.activeSources.set(x);
    }

    @Override
    public boolean fetchedAll() {
        int x = this.activeSources.get();
        assert (x >= 0) : x;
        return x == 0 && this.queue.isEmpty();
    }

    @Override
    protected void addPage0(GridResultPage page) {
        assert (page.rowsInPage() > 0 || page.isLast() || page.isFail());
        if (page.rowsInPage() != 0 || page.isFail()) {
            this.queue.add(page);
        }
        if (page.isLast()) {
            int x = this.activeSources.decrementAndGet();
            assert (x >= 0) : x;
            if (x == 0) {
                this.queue.add(this.createDummyLastPage(page));
            }
        }
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        return this.getCostRangeIndex(masks, this.getRowCountApproximation(), filters, filter, sortOrder, true, allColumnsSet);
    }

    @Override
    protected Cursor findAllFetched(List<Row> fetched, SearchRow first, SearchRow last) {
        return new GridH2Cursor(fetched.iterator());
    }

    @Override
    protected Cursor findInStream(SearchRow first, SearchRow last) {
        return new GridMergeIndex.FetchingCursor(this, null, null, new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                GridMergeIndexUnsorted.this.iter = GridMergeIndexUnsorted.this.pollNextIterator(GridMergeIndexUnsorted.this.queue, GridMergeIndexUnsorted.this.iter);
                return GridMergeIndexUnsorted.this.iter.hasNext();
            }

            @Override
            public Row next() {
                return GridH2PlainRowFactory.create((Value[])GridMergeIndexUnsorted.this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    private static class PollableQueue<X>
    extends LinkedBlockingQueue<X>
    implements GridMergeIndex.Pollable<X> {
        private PollableQueue() {
        }
    }
}

