/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.igfs.IgfsIpcEndpointConfiguration;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.jetbrains.annotations.Nullable;

public class VisorIgfsConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private String metaCacheName;
    private String dataCacheName;
    private int blockSize;
    private int prefetchBlocks;
    private int streamBufSize;
    private int perNodeBatchSize;
    private int perNodeParallelBatchCnt;
    private IgfsMode dfltMode;
    private Map<String, IgfsMode> pathModes;
    private long maxTaskRangeLen;
    private int fragmentizerConcurrentFiles;
    private boolean fragmentizerEnabled;
    private long fragmentizerThrottlingBlockLen;
    private long fragmentizerThrottlingDelay;
    private String ipcEndpointCfg;
    private boolean ipcEndpointEnabled;
    private int mgmtPort;
    private int seqReadsBeforePrefetch;
    private boolean colocateMeta;
    private boolean relaxedConsistency;
    private boolean updateFileLenOnFlush;

    public VisorIgfsConfiguration() {
    }

    public VisorIgfsConfiguration(FileSystemConfiguration igfs) {
        this.name = igfs.getName();
        this.metaCacheName = igfs.getMetaCacheConfiguration().getName();
        this.dataCacheName = igfs.getDataCacheConfiguration().getName();
        this.blockSize = igfs.getBlockSize();
        this.prefetchBlocks = igfs.getPrefetchBlocks();
        this.streamBufSize = igfs.getBufferSize();
        this.perNodeBatchSize = igfs.getPerNodeBatchSize();
        this.perNodeParallelBatchCnt = igfs.getPerNodeParallelBatchCount();
        this.dfltMode = igfs.getDefaultMode();
        this.pathModes = igfs.getPathModes();
        this.maxTaskRangeLen = igfs.getMaximumTaskRangeLength();
        this.fragmentizerConcurrentFiles = igfs.getFragmentizerConcurrentFiles();
        this.fragmentizerEnabled = igfs.isFragmentizerEnabled();
        this.fragmentizerThrottlingBlockLen = igfs.getFragmentizerThrottlingBlockLength();
        this.fragmentizerThrottlingDelay = igfs.getFragmentizerThrottlingDelay();
        IgfsIpcEndpointConfiguration endpointCfg = igfs.getIpcEndpointConfiguration();
        this.ipcEndpointCfg = endpointCfg != null ? endpointCfg.toString() : null;
        this.ipcEndpointEnabled = igfs.isIpcEndpointEnabled();
        this.mgmtPort = igfs.getManagementPort();
        this.seqReadsBeforePrefetch = igfs.getSequentialReadsBeforePrefetch();
        this.colocateMeta = igfs.isColocateMetadata();
        this.relaxedConsistency = igfs.isRelaxedConsistency();
        this.updateFileLenOnFlush = igfs.isUpdateFileLengthOnFlush();
    }

    public static List<VisorIgfsConfiguration> list(FileSystemConfiguration[] igfss) {
        ArrayList<VisorIgfsConfiguration> res = new ArrayList<VisorIgfsConfiguration>();
        if (!F.isEmpty(igfss)) {
            for (FileSystemConfiguration igfs : igfss) {
                res.add(new VisorIgfsConfiguration(igfs));
            }
        }
        return res;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getMetaCacheName() {
        return this.metaCacheName;
    }

    @Nullable
    public String getDataCacheName() {
        return this.dataCacheName;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getPrefetchBlocks() {
        return this.prefetchBlocks;
    }

    public int getStreamBufferSize() {
        return this.streamBufSize;
    }

    public int getPerNodeBatchSize() {
        return this.perNodeBatchSize;
    }

    public int getPerNodeParallelBatchCount() {
        return this.perNodeParallelBatchCnt;
    }

    public IgfsMode getDefaultMode() {
        return this.dfltMode;
    }

    @Nullable
    public Map<String, IgfsMode> getPathModes() {
        return this.pathModes;
    }

    public long getMaxTaskRangeLength() {
        return this.maxTaskRangeLen;
    }

    public int getFragmentizerConcurrentFiles() {
        return this.fragmentizerConcurrentFiles;
    }

    public boolean isFragmentizerEnabled() {
        return this.fragmentizerEnabled;
    }

    public long getFragmentizerThrottlingBlockLength() {
        return this.fragmentizerThrottlingBlockLen;
    }

    public long getFragmentizerThrottlingDelay() {
        return this.fragmentizerThrottlingDelay;
    }

    @Nullable
    public String getIpcEndpointConfiguration() {
        return this.ipcEndpointCfg;
    }

    public boolean isIpcEndpointEnabled() {
        return this.ipcEndpointEnabled;
    }

    public int getManagementPort() {
        return this.mgmtPort;
    }

    public int getSequenceReadsBeforePrefetch() {
        return this.seqReadsBeforePrefetch;
    }

    public boolean isColocateMetadata() {
        return this.colocateMeta;
    }

    public boolean isRelaxedConsistency() {
        return this.relaxedConsistency;
    }

    public boolean isUpdateFileLengthOnFlush() {
        return this.updateFileLenOnFlush;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeString(out, this.metaCacheName);
        U.writeString(out, this.dataCacheName);
        out.writeInt(this.blockSize);
        out.writeInt(this.prefetchBlocks);
        out.writeInt(this.streamBufSize);
        out.writeInt(this.perNodeBatchSize);
        out.writeInt(this.perNodeParallelBatchCnt);
        U.writeEnum(out, this.dfltMode);
        U.writeMap(out, this.pathModes);
        out.writeLong(this.maxTaskRangeLen);
        out.writeInt(this.fragmentizerConcurrentFiles);
        out.writeBoolean(this.fragmentizerEnabled);
        out.writeLong(this.fragmentizerThrottlingBlockLen);
        out.writeLong(this.fragmentizerThrottlingDelay);
        U.writeString(out, this.ipcEndpointCfg);
        out.writeBoolean(this.ipcEndpointEnabled);
        out.writeInt(this.mgmtPort);
        out.writeInt(this.seqReadsBeforePrefetch);
        out.writeBoolean(this.colocateMeta);
        out.writeBoolean(this.relaxedConsistency);
        out.writeBoolean(this.updateFileLenOnFlush);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.metaCacheName = U.readString(in);
        this.dataCacheName = U.readString(in);
        this.blockSize = in.readInt();
        this.prefetchBlocks = in.readInt();
        this.streamBufSize = in.readInt();
        this.perNodeBatchSize = in.readInt();
        this.perNodeParallelBatchCnt = in.readInt();
        this.dfltMode = IgfsMode.fromOrdinal(in.readByte());
        this.pathModes = U.readMap(in);
        this.maxTaskRangeLen = in.readLong();
        this.fragmentizerConcurrentFiles = in.readInt();
        this.fragmentizerEnabled = in.readBoolean();
        this.fragmentizerThrottlingBlockLen = in.readLong();
        this.fragmentizerThrottlingDelay = in.readLong();
        this.ipcEndpointCfg = U.readString(in);
        this.ipcEndpointEnabled = in.readBoolean();
        this.mgmtPort = in.readInt();
        this.seqReadsBeforePrefetch = in.readInt();
        this.colocateMeta = in.readBoolean();
        this.relaxedConsistency = in.readBoolean();
        this.updateFileLenOnFlush = in.readBoolean();
    }

    public String toString() {
        return S.toString(VisorIgfsConfiguration.class, this);
    }
}

