/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.cache.VisorModifyCacheMode;

public class VisorCacheModifyTaskArg
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String cacheName;
    private VisorModifyCacheMode mode;
    private Object key;
    private Object value;

    public VisorCacheModifyTaskArg() {
    }

    public VisorCacheModifyTaskArg(String cacheName, VisorModifyCacheMode mode, Object key, Object value) {
        this.cacheName = cacheName;
        this.mode = mode;
        this.key = key;
        this.value = value;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public VisorModifyCacheMode getMode() {
        return this.mode;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.cacheName);
        U.writeEnum(out, this.mode);
        out.writeObject(this.key);
        out.writeObject(this.value);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.cacheName = U.readString(in);
        this.mode = VisorModifyCacheMode.fromOrdinal(in.readByte());
        this.key = in.readObject();
        this.value = in.readObject();
    }

    public String toString() {
        return S.toString(VisorCacheModifyTaskArg.class, this);
    }
}

