/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc.loopback;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.ipc.IpcEndpoint;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IpcClientTcpEndpoint
implements IpcEndpoint {
    private Socket clientSock;

    public IpcClientTcpEndpoint(Socket clientSock) {
        assert (clientSock != null);
        this.clientSock = clientSock;
    }

    public IpcClientTcpEndpoint(String host, int port) throws IgniteCheckedException {
        this.clientSock = new Socket();
        try {
            this.clientSock.connect(new InetSocketAddress(host, port));
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to connect to endpoint [host=" + host + ", port=" + port + ']', e);
        }
    }

    @Override
    public InputStream inputStream() throws IgniteCheckedException {
        try {
            return this.clientSock.getInputStream();
        }
        catch (IOException e) {
            throw new IgniteCheckedException(e);
        }
    }

    @Override
    public OutputStream outputStream() throws IgniteCheckedException {
        try {
            return this.clientSock.getOutputStream();
        }
        catch (IOException e) {
            throw new IgniteCheckedException(e);
        }
    }

    @Override
    public void close() {
        U.closeQuiet(this.clientSock);
    }
}

