/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.zk;

import com.zillion.util.common.ZillionConstant;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.zillion.util.common.MyException;
import org.zillion.util.log.LogUtil;

public class ZKWrapper {
    String zookeeper_connectionAddress;
    int zookeeper_sessionTimeout;
    ZooKeeper zk;
    boolean sasl = false;
    String jaas_conf_path;
    String krb5_conf_path;
    boolean initialized = false;

    public ZKWrapper(String zookeeper_connectionAddress, int zookeeper_sessionTimeout) {
        this.zookeeper_connectionAddress = zookeeper_connectionAddress;
        this.zookeeper_sessionTimeout = zookeeper_sessionTimeout;
        this.Initialize();
    }

    public ZKWrapper(String zookeeper_connectionAddress, int zookeeper_sessionTimeout, String jaas_conf_path, String krb5_conf_path) {
        this.zookeeper_connectionAddress = zookeeper_connectionAddress;
        this.zookeeper_sessionTimeout = zookeeper_sessionTimeout;
        this.sasl = true;
        this.jaas_conf_path = jaas_conf_path;
        this.krb5_conf_path = krb5_conf_path;
        this.Initialize();
    }

    private void Initialize() {
        if (!this.initialized) {
            try {
                if (this.sasl) {
                    System.setProperty("java.security.auth.login.config", this.jaas_conf_path);
                    System.setProperty("java.security.krb5.conf", this.krb5_conf_path);
                }
                this.zk = new ZooKeeper(this.zookeeper_connectionAddress, this.zookeeper_sessionTimeout, null);
                this.initialized = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized Stat exists(String path, boolean watch) throws Exception {
        Stat result = this.existsInner(path, watch, ZillionConstant.retry_count);
        return result;
    }

    private Stat existsInner(String path, boolean watch, int retry_count) throws Exception {
        this.Initialize();
        if (!this.initialized) {
            throw new MyException("ZKWrapper: ZooKeeper not connected!");
        }
        Stat result = null;
        try {
            result = this.zk.exists(path, watch);
        }
        catch (Exception e) {
            LogUtil.warn("exists " + path + "\n" + e);
            this.close();
            if (retry_count > 0) {
                result = this.existsInner(path, watch, retry_count - 1);
            }
            throw e;
        }
        return result;
    }

    public synchronized Stat exists(String path, Watcher watcher) throws Exception {
        Stat result = this.exists(path, watcher, ZillionConstant.retry_count);
        return result;
    }

    private Stat exists(String path, Watcher watcher, int retry_count) throws Exception {
        this.Initialize();
        if (!this.initialized) {
            throw new MyException("ZKWrapper: ZooKeeper not connected!");
        }
        Stat result = null;
        try {
            result = this.zk.exists(path, watcher);
        }
        catch (Exception e) {
            LogUtil.warn("exists " + path + "\n" + e);
            this.close();
            if (retry_count > 0) {
                result = this.exists(path, watcher, retry_count - 1);
            }
            throw e;
        }
        return result;
    }

    public synchronized String create(String path, byte[] data, CreateMode createMode) throws Exception {
        ArrayList acl = this.sasl ? ZooDefs.Ids.CREATOR_ALL_ACL : ZooDefs.Ids.OPEN_ACL_UNSAFE;
        String result = this.create(path, data, acl, createMode);
        return result;
    }

    private String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws Exception {
        String result;
        Stat statInner = this.exists(path, false);
        if (statInner != null) {
            throw new MyException("ZKWrapper: path exist:" + path);
        }
        try {
            result = this.zk.create(path, data, acl, createMode);
        }
        catch (Exception e) {
            LogUtil.warn("create " + path + "\n" + e);
            throw e;
        }
        return result;
    }

    public synchronized List<String> getChildren(String path, boolean watch) throws Exception {
        List result;
        Stat statInner = this.exists(path, false);
        if (statInner == null) {
            throw new MyException("ZKWrapper: path not exist:" + path);
        }
        try {
            result = this.zk.getChildren(path, watch);
        }
        catch (Exception e) {
            LogUtil.warn("getChildren " + path + "\n" + e);
            throw e;
        }
        return result;
    }

    public synchronized byte[] getData(String path, boolean watch, Stat stat) throws Exception {
        byte[] result;
        Stat statInner = this.exists(path, false);
        if (statInner == null) {
            throw new MyException("ZKWrapper: path not exist:" + path);
        }
        try {
            result = this.zk.getData(path, watch, stat);
        }
        catch (Exception e) {
            LogUtil.warn("getData " + path + "\n" + e);
            throw e;
        }
        return result;
    }

    public synchronized Stat setData(String path, byte[] data, int version) throws Exception {
        Stat result;
        Stat statInner = this.exists(path, false);
        if (statInner == null) {
            throw new MyException("ZKWrapper: path not exist:" + path);
        }
        try {
            result = this.zk.setData(path, data, version);
        }
        catch (Exception e) {
            LogUtil.warn("setData " + path + "\n" + e);
            throw e;
        }
        return result;
    }

    public synchronized void delete(String path, int version) throws Exception {
        Stat statInner = this.exists(path, false);
        if (statInner == null) {
            throw new MyException("ZKWrapper: path not exist:" + path);
        }
        try {
            this.zk.delete(path, version);
        }
        catch (Exception e) {
            LogUtil.warn("delete " + path + "\n" + e);
            throw e;
        }
    }

    public synchronized void close() {
        if (!this.initialized) {
            return;
        }
        try {
            this.zk.close();
        }
        catch (Exception e) {
            LogUtil.warn(e);
        }
        this.initialized = false;
    }
}

