/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.zk;

import com.zillion.util.zk.ZKLockSingal;
import com.zillion.util.zk.ZKLockWatcher;
import com.zillion.util.zk.ZKWrapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ZKLockCEDU {
    public static boolean PreCheck(ZKWrapper zk, String parent_path, String lock_type) throws Exception {
        byte[] data_bytes;
        String data;
        boolean success = false;
        Stat stat = zk.exists(parent_path, false);
        if (stat == null) {
            try {
                zk.create(parent_path, "d".getBytes("UTF-8"), CreateMode.PERSISTENT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String exist = null;
        List<String> children = zk.getChildren(parent_path, false);
        for (String child : children) {
            if (!child.equals(lock_type)) continue;
            exist = child;
            break;
        }
        success = exist != null ? false : !(data = new String(data_bytes = zk.getData(parent_path, false, stat = new Stat()), "UTF-8")).equals(lock_type);
        return success;
    }

    public static String Create(ZKWrapper zk, String parent_path, String lock_type, String lock_content) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        byte[] data = (String.valueOf(sdf.format(new Date())) + "_" + lock_content).getBytes("UTF-8");
        String node_path = zk.create(String.valueOf(parent_path) + "/" + lock_type + "-", data, CreateMode.EPHEMERAL_SEQUENTIAL);
        return node_path;
    }

    public static boolean Check(ZKWrapper zk, String parent_path, int sequence_id, String lock_type) throws Exception {
        Stat stat;
        byte[] data_bytes;
        String data;
        boolean success = false;
        String exist = null;
        List<String> children = zk.getChildren(parent_path, false);
        for (String child : children) {
            int tmp_id = Integer.parseInt(child.substring(2));
            if (!child.equals(lock_type) || tmp_id >= sequence_id) continue;
            exist = child;
            break;
        }
        success = exist != null ? false : !(data = new String(data_bytes = zk.getData(parent_path, false, stat = new Stat()), "UTF-8")).equals(lock_type);
        return success;
    }

    public static boolean WaitFor(ZKWrapper zk, String parent_path, String node_path, int seconds) throws Exception {
        Date currentTime;
        boolean result = false;
        Date time_from = new Date();
        do {
            boolean wait_success;
            if (wait_success = ZKLockCEDU.WaitOnce(zk, parent_path, node_path)) {
                result = true;
                break;
            }
            Thread.sleep(1000L);
        } while ((currentTime = new Date()).getTime() - time_from.getTime() <= 1000L * (long)seconds);
        return result;
    }

    public static boolean WaitOnce(ZKWrapper zk, String parent_path, String node_path) throws Exception {
        char lock_type = node_path.charAt(parent_path.length() + 1);
        int sequence_id = Integer.parseInt(node_path.substring(parent_path.length() + 3));
        String exist = null;
        exist = null;
        List<String> children = zk.getChildren(parent_path, false);
        if (lock_type == 'u') {
            for (String child : children) {
                char tmp_lock_type = child.charAt(0);
                int tmp_id = Integer.parseInt(child.substring(2));
                if (tmp_lock_type != 'e' || tmp_id >= sequence_id) continue;
                exist = child;
                break;
            }
        } else {
            for (String child : children) {
                int tmp_id = Integer.parseInt(child.substring(2));
                if (tmp_id >= sequence_id) continue;
                exist = child;
                break;
            }
        }
        return exist == null;
    }

    private static void Wait(ZKWrapper zk, String parent_path, String node_path) throws Exception {
        char lock_type = node_path.charAt(parent_path.length() + 1);
        int sequence_id = Integer.parseInt(node_path.substring(parent_path.length() + 3));
        String status = "begin";
        String exist = null;
        ZKLockSingal singal = null;
        while (true) {
            Thread.sleep(1L);
            if (status.equals("begin")) {
                exist = null;
                List<String> children = zk.getChildren(parent_path, false);
                if (lock_type == 'u') {
                    for (String child : children) {
                        char tmp_lock_type = child.charAt(0);
                        int tmp_id = Integer.parseInt(child.substring(2));
                        if (tmp_lock_type != 'e' || tmp_id >= sequence_id) continue;
                        exist = child;
                        break;
                    }
                } else {
                    for (String child : children) {
                        int tmp_id = Integer.parseInt(child.substring(2));
                        if (tmp_id >= sequence_id) continue;
                        exist = child;
                        break;
                    }
                }
                if (exist != null) {
                    status = "exist_Y";
                    continue;
                }
                status = "exist_N";
                continue;
            }
            if (status.equals("exist_Y")) {
                singal = new ZKLockSingal();
                Stat stat = zk.exists(String.valueOf(parent_path) + "/" + exist, new ZKLockWatcher(singal));
                if (stat == null) {
                    status = "begin";
                    continue;
                }
                status = "wait";
                continue;
            }
            if (status.equals("wait")) {
                if (!singal.deleted) continue;
                status = "begin";
                continue;
            }
            if (status.equals("exist_N")) {
                status = "success";
                continue;
            }
            if (status.equals("success")) break;
        }
    }

    public static void Finish(ZKWrapper zk, String node_path) throws Exception {
        Stat stat = zk.exists(node_path, false);
        if (stat != null) {
            zk.delete(node_path, -1);
        }
    }
}

