/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.table;

import com.zillion.database.util.ITableWrapper;
import com.zillion.util.common.HashObject;
import com.zillion.util.common.ZillionConstant;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.ZillionTableSchema;
import com.zillion.util.zk.ZKLockRW;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.zillion.util.common.MyException;
import org.zillion.util.log.LogUtil;

public class ZillionTableIndex {
    public ZillionTableSchema schema;
    public String index_name;
    public String[] Key;
    public Map<String, Boolean> KeyMap;
    private List<ITableWrapper> wrapperList = new ArrayList<ITableWrapper>();
    private Map<String, List<ITableWrapper>> split_wrapperListMap = new HashMap<String, List<ITableWrapper>>();

    public ZillionTableIndex(ZillionTableSchema schema, String IndexName) {
        this.schema = schema;
        this.index_name = IndexName;
    }

    public synchronized ITableWrapper connect(SchemaRepositoryContainer container, String child_name, boolean create_split_table) throws Exception {
        ITableWrapper wrapper = null;
        if (this.schema.table_type != null && this.schema.table_type.startsWith("split_")) {
            int wrapper_count = 0;
            if (this.split_wrapperListMap.containsKey(child_name)) {
                List<ITableWrapper> split_wrapperList = this.split_wrapperListMap.get(child_name);
                for (ITableWrapper entity : split_wrapperList) {
                    if (!entity.can_use()) continue;
                    wrapper = entity;
                    break;
                }
                if (wrapper != null) {
                    wrapper.use();
                    return wrapper;
                }
                wrapper_count = split_wrapperList.size();
            }
            String tableName = "zillion_index_" + this.schema.table_name + "." + this.index_name + "_" + child_name;
            if (container.DatabaseImpl.table_split_index_exist(this.schema.Namespace, this.schema.table_name, this.index_name, child_name)) {
                wrapper = container.DatabaseImpl.generateTableWrapper(this.schema.Namespace, tableName, wrapper_count);
                if (!this.split_wrapperListMap.containsKey(child_name)) {
                    this.split_wrapperListMap.put(child_name, new ArrayList());
                }
                List<ITableWrapper> split_wrapperList = this.split_wrapperListMap.get(child_name);
                split_wrapperList.add(wrapper);
                wrapper.use();
                return wrapper;
            }
            if (create_split_table) {
                String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
                String zkpath_namespace = "/zillion/ns/" + this.schema.Namespace;
                Stat stat = container.ZK.exists(String.valueOf(zkpath_namespace) + "/splitlocks", false);
                if (stat == null) {
                    try {
                        container.ZK.create(String.valueOf(zkpath_namespace) + "/splitlocks", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String parent_path_meta = String.valueOf(zkpath_namespace) + "/splitlocks" + "/" + this.schema.table_name;
                String lock_type_meta = "w";
                stat = container.ZK.exists(parent_path_meta, false);
                if (stat == null) {
                    try {
                        container.ZK.create(parent_path_meta, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String node_path_meta = ZKLockRW.Create(container.ZK, parent_path_meta, lock_type_meta, "create_split_table");
                try {
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
                    boolean wait_success = ZKLockRW.WaitFor(container.ZK, parent_path_meta, node_path_meta, ZillionConstant.WaitFor_seconds_create_split_table);
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                    if (!wait_success) {
                        throw new MyException("ZillionAgent: WaitFor fail " + node_path_meta);
                    }
                    HashObject hashObject = new HashObject();
                    byte[] hash = hashObject.toBytes();
                    container.ZK.create(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + this.schema.table_name + "." + this.index_name + "/" + child_name, hash, CreateMode.PERSISTENT);
                    container.ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + this.schema.table_name + "." + this.index_name + "/" + child_name, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                    container.DatabaseImpl.meta_query_insert_split(this.schema.Namespace, String.valueOf(this.schema.table_name) + "." + this.index_name + "_" + child_name, hashObject);
                    container.DatabaseImpl.table_manage_create_split_index(this.schema.Namespace, this.schema.table_name, this.index_name, child_name, this);
                    wrapper = container.DatabaseImpl.generateTableWrapper(this.schema.Namespace, tableName, wrapper_count);
                    if (!this.split_wrapperListMap.containsKey(child_name)) {
                        this.split_wrapperListMap.put(child_name, new ArrayList());
                    }
                    List<ITableWrapper> split_wrapperList = this.split_wrapperListMap.get(child_name);
                    split_wrapperList.add(wrapper);
                    wrapper.use();
                    ITableWrapper iTableWrapper = wrapper;
                    return iTableWrapper;
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    ZKLockRW.Finish(container.ZK, node_path_meta);
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
                }
            }
            return null;
        }
        for (ITableWrapper entity : this.wrapperList) {
            if (!entity.can_use()) continue;
            wrapper = entity;
            break;
        }
        if (wrapper == null) {
            wrapper = container.DatabaseImpl.generateTableWrapper(this.schema.Namespace, "zillion_index_" + this.schema.table_name + "." + this.index_name, this.wrapperList.size());
            this.wrapperList.add(wrapper);
        }
        wrapper.use();
        return wrapper;
    }

    public synchronized void RefreshTableWrapper(SchemaRepositoryContainer container) throws Exception {
        ArrayList<String> removeList = new ArrayList<String>();
        Iterator<String> keyIter = this.split_wrapperListMap.keySet().iterator();
        if (keyIter.hasNext()) {
            String key = keyIter.next();
            List<ITableWrapper> split_wrapperList = this.split_wrapperListMap.get(key);
            String child_name = key;
            if (!container.DatabaseImpl.table_split_index_exist(this.schema.Namespace, this.schema.table_name, this.index_name, child_name)) {
                for (ITableWrapper entity : split_wrapperList) {
                    entity.close();
                }
                removeList.add(child_name);
                LogUtil.warn("child_name\t" + this.schema.table_name + "." + this.index_name + "_" + child_name + "\t" + "clear");
            }
        }
        for (String remove : removeList) {
            this.split_wrapperListMap.remove(remove);
        }
    }

    public synchronized void close() throws Exception {
        for (ITableWrapper entity : this.wrapperList) {
            entity.close();
        }
        this.wrapperList.clear();
    }
}

