/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.common;

import com.zillion.util.table.ZillionTableColumnEnum;
import java.nio.charset.Charset;
import org.apache.hadoop.hbase.util.Bytes;

public class ByteToObject {
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_BOOLEAN = 1;
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static int lengthOfColumnEnum(ZillionTableColumnEnum ColumnEnum) {
        if (ColumnEnum == ZillionTableColumnEnum.INT) {
            return 8;
        }
        if (ColumnEnum == ZillionTableColumnEnum.LONG) {
            return 8;
        }
        if (ColumnEnum == ZillionTableColumnEnum.FLOAT) {
            return 8;
        }
        if (ColumnEnum == ZillionTableColumnEnum.DOUBLE) {
            return 8;
        }
        if (ColumnEnum == ZillionTableColumnEnum.BOOLEAN) {
            return 1;
        }
        return 0;
    }

    public static void putInt(byte[] byteArray, int offset, int value) {
        Bytes.putInt((byte[])byteArray, (int)offset, (int)value);
        ByteToObject.process_Long(byteArray, offset);
    }

    public static void putLong(byte[] byteArray, int offset, long value) {
        Bytes.putLong((byte[])byteArray, (int)offset, (long)value);
        ByteToObject.process_Long(byteArray, offset);
    }

    public static void putFloat(byte[] byteArray, int offset, float value) {
        Bytes.putFloat((byte[])byteArray, (int)offset, (float)value);
        ByteToObject.process_Double_toBytes(byteArray, offset, 4);
    }

    public static void putDouble(byte[] byteArray, int offset, double value) {
        Bytes.putDouble((byte[])byteArray, (int)offset, (double)value);
        ByteToObject.process_Double_toBytes(byteArray, offset, 8);
    }

    public static void putBoolean(byte[] byteArray, int offset, boolean value) {
        byteArray[offset] = value ? -1 : 0;
    }

    public static byte[] toBytes(int value) {
        byte[] result = Bytes.toBytes((int)value);
        ByteToObject.process_Long(result, 0);
        return result;
    }

    public static byte[] toBytes(long value) {
        byte[] result = Bytes.toBytes((long)value);
        ByteToObject.process_Long(result, 0);
        return result;
    }

    public static byte[] toBytes(float value) {
        byte[] result = Bytes.toBytes((float)value);
        ByteToObject.process_Double_toBytes(result, 0, 4);
        return result;
    }

    public static byte[] toBytes(double value) {
        byte[] result = Bytes.toBytes((double)value);
        ByteToObject.process_Double_toBytes(result, 0, 8);
        return result;
    }

    public static byte[] toBytes(String value) {
        return value.getBytes(UTF8_CHARSET);
    }

    public static byte[] toBytes(boolean value) {
        return new byte[]{value ? (byte)-1 : 0};
    }

    public static int toInt(byte[] value) {
        return ByteToObject.toInt(value, 0);
    }

    public static int toInt(byte[] value, int offset) {
        byte[] result = new byte[4];
        System.arraycopy(value, offset, result, 0, result.length);
        ByteToObject.process_Long(result, 0);
        return Bytes.toInt((byte[])result);
    }

    public static long toLong(byte[] value) {
        return ByteToObject.toLong(value, 0);
    }

    public static long toLong(byte[] value, int offset) {
        byte[] result = new byte[8];
        System.arraycopy(value, offset, result, 0, result.length);
        ByteToObject.process_Long(result, 0);
        return Bytes.toLong((byte[])result);
    }

    public static float toFloat(byte[] value) {
        return ByteToObject.toFloat(value, 0);
    }

    public static float toFloat(byte[] value, int offset) {
        byte[] result = new byte[4];
        System.arraycopy(value, offset, result, 0, result.length);
        ByteToObject.process_Double_toDouble(result, 0, result.length);
        return Bytes.toFloat((byte[])result);
    }

    public static double toDouble(byte[] value) {
        return ByteToObject.toDouble(value, 0);
    }

    public static double toDouble(byte[] value, int offset) {
        byte[] result = new byte[8];
        System.arraycopy(value, offset, result, 0, result.length);
        ByteToObject.process_Double_toDouble(result, 0, result.length);
        return Bytes.toDouble((byte[])result);
    }

    public static String toString(byte[] value) {
        return ByteToObject.toString(value, 0, value.length);
    }

    public static String toString(byte[] value, int offset, int len) {
        return new String(value, offset, len, UTF8_CHARSET);
    }

    public static boolean toBoolean(byte[] value) {
        return ByteToObject.toBoolean(value, 0);
    }

    public static boolean toBoolean(byte[] value, int offset) {
        return value[offset] != 0;
    }

    public static void process_Long(byte[] result, int offset) {
        int first = 0xFF & result[offset];
        first = first >= 128 ? (first -= 128) : (first += 128);
        result[offset] = (byte)first;
    }

    public static void process_Double_toBytes(byte[] result, int offset, int len) {
        int first = 0xFF & result[offset];
        if (first >= 128) {
            int i = offset;
            while (i < offset + len) {
                int tmp = 0xFF & result[i];
                tmp = 255 - tmp;
                result[i] = (byte)tmp;
                ++i;
            }
        } else {
            result[offset] = (byte)(first += 128);
        }
    }

    public static void process_Double_toDouble(byte[] result, int offset, int len) {
        int first = 0xFF & result[offset];
        if (first < 128) {
            int i = offset;
            while (i < offset + len) {
                int tmp = 0xFF & result[i];
                tmp = 255 - tmp;
                result[i] = (byte)tmp;
                ++i;
            }
        } else {
            result[offset] = (byte)(first -= 128);
        }
    }

    public static byte[] lastBytes(byte[] bytes_gt) {
        byte[] result;
        int index_not_0 = -1;
        int i = bytes_gt.length - 1;
        while (i >= 0) {
            if (bytes_gt[i] != 0) {
                index_not_0 = i;
                break;
            }
            --i;
        }
        if (index_not_0 == -1) {
            result = new byte[]{};
            result = new byte[bytes_gt.length - 1];
            System.arraycopy(bytes_gt, 0, result, 0, bytes_gt.length - 1);
        } else {
            result = new byte[bytes_gt.length];
            System.arraycopy(bytes_gt, 0, result, 0, index_not_0 + 1);
            byte a = result[index_not_0];
            int b = a - 1;
            result[index_not_0] = (byte)b;
            int i2 = index_not_0 + 1;
            while (i2 < bytes_gt.length) {
                result[i2] = -1;
                ++i2;
            }
        }
        return result;
    }
}

