/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.zillion.database.agent.ZillionCriteriaGroup;
import com.zillion.database.agent.ZillionQueryResult;
import com.zillion.database.agent.ZillionQueryTmp;
import com.zillion.database.async.AsyncJob;
import com.zillion.database.util.Configuration_MySQL;
import com.zillion.database.util.DataSourceConfig_DBCP;
import com.zillion.database.util.DataSourceConfig_c3p0;
import com.zillion.database.util.IDatabase;
import com.zillion.database.util.ITableWrapper;
import com.zillion.database.util.MySQLUtil;
import com.zillion.database.util.ResultSet_MySQL;
import com.zillion.database.util.TableWrapper_MySQL;
import com.zillion.util.common.HashObject;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.SchemaWrapper;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import com.zillion.util.zk.ZKWrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.dbcp2.BasicDataSource;
import org.zillion.util.log.LogUtil;

public class DatabaseImpl_MySQL
implements IDatabase {
    public static String DEFAULT_CHARACTER_SET = "utf8mb4";
    public static String DEFAULT_CHARACTER_SET_CI = "utf8mb4_general_ci";
    public static String DEFAULT_STORAGE_ENGINE = "MYISAM";
    public static int DEFAULT_VARCHAR_LENGTH = 125;
    Configuration_MySQL configuration;
    DataSource ds;

    static {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public DatabaseImpl_MySQL(Configuration_MySQL configuration) {
        this.configuration = configuration;
    }

    public String getDataSourceStatus() throws SQLException {
        if (this.ds instanceof BasicDataSource) {
            BasicDataSource bds = (BasicDataSource)this.ds;
            StringBuffer sb = new StringBuffer();
            sb.append("\tNumActive:" + bds.getNumActive());
            sb.append("\tNumIdle:" + bds.getNumIdle());
            return sb.toString();
        }
        if (this.ds instanceof ComboPooledDataSource) {
            ComboPooledDataSource cpds = (ComboPooledDataSource)this.ds;
            StringBuffer sb = new StringBuffer();
            sb.append("\tNumBusyConnections:" + cpds.getNumBusyConnections());
            sb.append("\tNumConnections:" + cpds.getNumConnections());
            sb.append("\tNumIdleConnections:" + cpds.getNumIdleConnections());
            return sb.toString();
        }
        return null;
    }

    @Override
    public void Start() throws Exception {
        if (this.configuration.config instanceof DataSourceConfig_DBCP) {
            DataSourceConfig_DBCP config_DBCP = (DataSourceConfig_DBCP)this.configuration.config;
            BasicDataSource bds = new BasicDataSource();
            bds.setDriverClassName("com.mysql.jdbc.Driver");
            bds.setUrl(config_DBCP.url);
            bds.setUsername(config_DBCP.username);
            bds.setPassword(config_DBCP.password);
            bds.setInitialSize(config_DBCP.initialSize);
            bds.setMaxTotal(config_DBCP.maxTotal);
            bds.setMaxIdle(config_DBCP.maxIdle);
            bds.setMinIdle(config_DBCP.minIdle);
            bds.setMaxWaitMillis((long)config_DBCP.maxWaitMillis);
            this.ds = bds;
        } else if (this.configuration.config instanceof DataSourceConfig_c3p0) {
            DataSourceConfig_c3p0 config_c3p0 = (DataSourceConfig_c3p0)this.configuration.config;
            ComboPooledDataSource cpds = new ComboPooledDataSource();
            cpds.setDriverClass("com.mysql.jdbc.Driver");
            cpds.setJdbcUrl(config_c3p0.jdbcUrl);
            cpds.setUser(config_c3p0.user);
            cpds.setPassword(config_c3p0.password);
            cpds.setAcquireIncrement(config_c3p0.acquireIncrement);
            cpds.setIdleConnectionTestPeriod(config_c3p0.idleConnectionTestPeriod);
            cpds.setInitialPoolSize(config_c3p0.initialPoolSize);
            cpds.setMaxIdleTime(config_c3p0.maxIdleTime);
            cpds.setMaxPoolSize(config_c3p0.maxPoolSize);
            cpds.setMaxStatements(config_c3p0.maxStatements);
            cpds.setMinPoolSize(config_c3p0.minPoolSize);
            this.ds = cpds;
        } else {
            throw new Exception("Unknowd DataSourceConfig:" + this.configuration.config.name);
        }
        LogUtil.warn("DatabaseImpl_MySQL.Start() begin");
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("select version()");
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String version = rs.getString(1);
                LogUtil.warn("MySQL " + version);
            }
            rs.close();
        }
        LogUtil.warn("DatabaseImpl_MySQL.Start() end");
    }

    @Override
    public void Stop() throws Exception {
        if (this.configuration.config instanceof DataSourceConfig_DBCP) {
            BasicDataSource bds = (BasicDataSource)this.ds;
            bds.close();
        } else if (this.configuration.config instanceof DataSourceConfig_c3p0) {
            ComboPooledDataSource cpds = (ComboPooledDataSource)this.ds;
            cpds.close();
        }
    }

    private Connection getConnection() throws Exception {
        Connection conn = this.ds.getConnection();
        return conn;
    }

    @Override
    public void namespace_create(String namespace) throws Exception {
        String stringSQL = "create database " + namespace + " DEFAULT CHARSET=" + DEFAULT_CHARACTER_SET + " COLLATE " + DEFAULT_CHARACTER_SET_CI;
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.execute();
            stmt.close();
        }
    }

    @Override
    public void namespace_drop(String namespace) throws Exception {
        String stringSQL = "drop database " + namespace;
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.execute();
            stmt.close();
        }
    }

    @Override
    public void meta_manage_create_data(String namespace) throws Exception {
        String stringSQL = "CREATE TABLE " + namespace + "." + "`zillion_meta_data`" + "(`tableName` varchar(250) NOT NULL,`q` text NOT NULL,`hi` varchar(500) DEFAULT NULL,`hd` varchar(500) DEFAULT NULL,`hc` varchar(500) DEFAULT NULL,PRIMARY KEY (`tableName`)) ENGINE=" + DEFAULT_STORAGE_ENGINE + " DEFAULT CHARSET=" + DEFAULT_CHARACTER_SET + ";";
        try (Connection conn = this.getConnection();){
            MySQLUtil.ori_execute(conn, stringSQL);
        }
    }

    @Override
    public void meta_manage_create_index(String namespace) throws Exception {
        String stringSQL = "CREATE TABLE " + namespace + "." + "`zillion_meta_index`" + "(`tableName` varchar(250) NOT NULL,`q` text NOT NULL,`hi` varchar(500) DEFAULT NULL,`hd` varchar(500) DEFAULT NULL,`hc` varchar(500) DEFAULT NULL,PRIMARY KEY (`tableName`)) ENGINE=" + DEFAULT_STORAGE_ENGINE + " DEFAULT CHARSET=" + DEFAULT_CHARACTER_SET + ";";
        try (Connection conn = this.getConnection();){
            MySQLUtil.ori_execute(conn, stringSQL);
        }
    }

    @Override
    public void meta_manage_make_sure_split(String namespace) throws Exception {
        if (this.ori_tableExists(namespace, "zillion_meta_split")) {
            return;
        }
        String stringSQL = "CREATE TABLE " + namespace + "." + "`zillion_meta_split`" + "(`tableName` varchar(250) NOT NULL,`hi` varchar(500) DEFAULT NULL,`hd` varchar(500) DEFAULT NULL,`hc` varchar(500) DEFAULT NULL,PRIMARY KEY (`tableName`)) ENGINE=" + DEFAULT_STORAGE_ENGINE + " DEFAULT CHARSET=" + DEFAULT_CHARACTER_SET + ";";
        try (Connection conn = this.getConnection();){
            MySQLUtil.ori_execute(conn, stringSQL);
        }
    }

    @Override
    public void meta_manage_drop_data(String namespace) throws Exception {
        this.ori_drop_table(namespace, "zillion_meta_data");
    }

    @Override
    public void meta_manage_drop_index(String namespace) throws Exception {
        this.ori_drop_table(namespace, "zillion_meta_index");
    }

    @Override
    public void meta_manage_drop_split(String namespace) throws Exception {
        this.ori_drop_table(namespace, "zillion_meta_split");
    }

    @Override
    public void meta_query_insert_data(String namespace, String tableName, JSONObject content, HashObject hashObject) throws Exception {
        String stringSQL = "insert into " + namespace + "." + "`zillion_meta_data` (tableName,q) VALUES(?,?)";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.setString(1, tableName);
            stmt.setString(2, JSON.toJSONString((Object)content, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            stmt.execute();
            stmt.close();
        }
    }

    @Override
    public void meta_query_insert_index(String namespace, String tableName, String indexName, JSONArray indexColumns, HashObject hashObject) throws Exception {
        String stringSQL = "insert into " + namespace + "." + "`zillion_meta_index` (tableName,q) VALUES(?,?)";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.setString(1, String.valueOf(tableName) + "." + indexName);
            stmt.setString(2, JSON.toJSONString((Object)indexColumns, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            stmt.execute();
            stmt.close();
        }
    }

    @Override
    public void meta_query_insert_split(String namespace, String tableName, HashObject hashObject) throws Exception {
        String stringSQL = "insert into " + namespace + "." + "`zillion_meta_split` (tableName) VALUES(?)";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.setString(1, tableName);
            stmt.execute();
            stmt.close();
        }
    }

    @Override
    public void meta_query_delete_data(String namespace, String tableName) throws Exception {
        String stringSQL = "delete from " + namespace + "." + "`zillion_meta_data` where tableName=?";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.setString(1, tableName);
            stmt.execute();
            stmt.close();
        }
    }

    @Override
    public void meta_query_delete_index(String namespace, String tableName, String indexName) throws Exception {
        String stringSQL = "delete from " + namespace + "." + "`zillion_meta_index` where tableName=?";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.setString(1, String.valueOf(tableName) + "." + indexName);
            stmt.execute();
            stmt.close();
        }
    }

    @Override
    public void meta_query_delete_split(String namespace, String tableName) throws Exception {
        String stringSQL = "delete from " + namespace + "." + "`zillion_meta_split` where tableName=?";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.setString(1, tableName);
            stmt.execute();
            stmt.close();
        }
    }

    @Override
    public void meta_query_update_data(String namespace, String tableName, JSONObject content) throws Exception {
        String stringSQL = "update " + namespace + "." + "`zillion_meta_data` set `q`=? where tableName='" + tableName + "'";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.setString(1, JSON.toJSONString((Object)content, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            stmt.execute();
            stmt.close();
        }
    }

    @Override
    public void meta_query_update_data(String namespace, String tableName, HashObject hashObject) throws Exception {
    }

    @Override
    public void meta_query_update_index(String namespace, String tableName, String indexName, HashObject hashObject) throws Exception {
    }

    @Override
    public void meta_query_update_split_data(String namespace, String tableName, String child_name, HashObject hashObject) throws Exception {
    }

    @Override
    public void meta_query_update_split_index(String namespace, String tableName, String indexName, String child_name, HashObject hashObject) throws Exception {
    }

    @Override
    public boolean table_split_index_exist(String namespace, String table_name, String index_name, String child_name) throws Exception {
        String tableName = "zillion_data_" + table_name + "_" + child_name;
        return this.ori_tableExists(namespace, tableName);
    }

    @Override
    public void table_manage_create_data(String namespace, ZillionTableSchema schema) throws Exception {
        String tableName = schema.table_name;
        String ori_tableName = "zillion_data_" + tableName;
        this.ori_create_table_MySQL(namespace, schema, ori_tableName);
    }

    @Override
    public void table_manage_create_index(String namespace, String tableName, ZillionTableIndex schema_index) throws Exception {
        ZillionTableSchema schema = schema_index.schema;
        String ori_tableName = "zillion_data_" + tableName;
        this.ori_create_index(namespace, schema, schema_index, ori_tableName);
    }

    @Override
    public void table_manage_create_split_data(String namespace, String tableName, String child_name, ZillionTableSchema schema) throws Exception {
        String ori_tableName = "zillion_data_" + tableName + "_" + child_name;
        this.ori_create_table_MySQL(namespace, schema, ori_tableName);
    }

    @Override
    public void table_manage_create_split_index(String namespace, String tableName, String indexName, String child_name, ZillionTableIndex schema_index) throws Exception {
        String ori_tableName = "zillion_data_" + tableName + "_" + child_name;
        ZillionTableSchema schema = schema_index.schema;
        this.ori_create_index(namespace, schema, schema_index, ori_tableName);
    }

    @Override
    public void table_manage_drop_data(String namespace, String tableName) throws Exception {
        try (Connection conn = this.getConnection();){
            this.ori_drop_table(namespace, "zillion_data_" + tableName);
        }
    }

    @Override
    public void table_manage_drop_index(String namespace, String tableName, String indexName) throws Exception {
        try (Connection conn = this.getConnection();){
            this.ori_drop_index(namespace, "zillion_data_" + tableName, indexName);
        }
    }

    @Override
    public void table_manage_drop_split_data(String namespace, String tableName, String child_name) throws Exception {
        try (Connection conn = this.getConnection();){
            this.ori_drop_table(namespace, "zillion_data_" + tableName + "_" + child_name);
        }
    }

    @Override
    public void table_manage_drop_split_index(String namespace, String tableName, String indexName, String child_name) throws Exception {
        try (Connection conn = this.getConnection();){
            this.ori_drop_index(namespace, "zillion_data_" + tableName + "_" + child_name, indexName);
        }
    }

    @Override
    public void table_manage_alter_add_column(String namespace, String ori_tableName, List<ZillionTableColumn> ztcList) throws Exception {
        StringBuffer sb_table = new StringBuffer();
        for (ZillionTableColumn column : ztcList) {
            this.generateColumn_MySQL(sb_table, column);
        }
        String stringSQL = "ALTER TABLE " + namespace + "." + "`" + ori_tableName + "`" + " ADD COLUMN (" + sb_table.toString() + ")";
        try (Connection conn = this.getConnection();){
            MySQLUtil.ori_execute(conn, stringSQL);
        }
    }

    @Override
    public void table_manage_alter_drop_column(String namespace, String ori_tableName, List<String> columnList) throws Exception {
        for (String column : columnList) {
            String stringSQL = "ALTER TABLE " + namespace + "." + "`" + ori_tableName + "`" + " DROP COLUMN " + "`" + column + "`";
            try (Connection conn = this.getConnection();){
                MySQLUtil.ori_execute(conn, stringSQL);
            }
        }
    }

    @Override
    public void table_manage_alter_compression(String namespace, String ori_tableName, boolean enable) throws Exception {
    }

    @Override
    public void table_manage_alter_in_memory(String namespace, String ori_tableName, boolean enable) throws Exception {
    }

    @Override
    public void meta_read(String namespace, List<String> tableNameList, List<String> tableContentList, List<HashObject> tableHashList, List<String> indexNameList, List<String> indexContentList, List<HashObject> indexHashList, List<String> splitNameList, List<HashObject> splitHashList) throws Exception {
        try (Connection conn = this.getConnection();){
            HashObject hashObject;
            String q;
            String row;
            Object[] columns;
            String stringSQL = "select * from " + namespace + ".`" + "zillion_meta_data" + "`";
            ArrayList<Integer> typeList = new ArrayList<Integer>();
            ArrayList<Object> params = new ArrayList<Object>();
            ResultSet_MySQL results = MySQLUtil.ori_select(conn, stringSQL, typeList, params);
            int i = 0;
            while (i < results.rowList.size()) {
                columns = results.rowList.get(i);
                row = (String)columns[0];
                q = (String)columns[1];
                hashObject = new HashObject();
                tableNameList.add(row);
                tableContentList.add(q);
                tableHashList.add(hashObject);
                ++i;
            }
            stringSQL = "select * from " + namespace + ".`" + "zillion_meta_index" + "`";
            typeList = new ArrayList();
            params = new ArrayList();
            results = MySQLUtil.ori_select(conn, stringSQL, typeList, params);
            i = 0;
            while (i < results.rowList.size()) {
                columns = results.rowList.get(i);
                row = (String)columns[0];
                q = (String)columns[1];
                hashObject = new HashObject();
                indexNameList.add(row);
                indexContentList.add(q);
                indexHashList.add(hashObject);
                ++i;
            }
            if (this.ori_tableExists(namespace, "zillion_meta_split")) {
                stringSQL = "select * from " + namespace + ".`" + "zillion_meta_split" + "`";
                typeList = new ArrayList();
                params = new ArrayList();
                results = MySQLUtil.ori_select(conn, stringSQL, typeList, params);
                i = 0;
                while (i < results.rowList.size()) {
                    columns = results.rowList.get(i);
                    row = (String)columns[0];
                    HashObject hashObject2 = new HashObject();
                    splitNameList.add(row);
                    splitHashList.add(hashObject2);
                    ++i;
                }
            }
        }
    }

    @Override
    public int clear_table_split(String namespace, ZillionTableSchema schema, List<String> query_monthList, ZKWrapper ZK) throws Exception {
        int count = 0;
        try (Connection conn = this.getConnection();){
            String zkpath_namespace = "/zillion/ns/" + namespace;
            HashObject hashObject = new HashObject();
            byte[] hash = hashObject.toBytes();
            int index_split = 0;
            while (index_split < query_monthList.size()) {
                String query_month = query_monthList.get(index_split);
                ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name + "/" + query_month, hash, -1);
                count = MySQLUtil.ori_executeQuery(conn, "delete from " + namespace + ".`" + "zillion_data_" + schema.table_name + "_" + query_month + "`");
                ++index_split;
            }
        }
        return count;
    }

    @Override
    public int clear_table_not_split(String namespace, ZillionTableSchema schema, ZKWrapper ZK) throws Exception {
        int count = 0;
        try (Connection conn = this.getConnection();){
            String zkpath_namespace = "/zillion/ns/" + namespace;
            HashObject hashObject = new HashObject();
            byte[] hash = hashObject.toBytes();
            ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name, hash, -1);
            count = MySQLUtil.ori_executeQuery(conn, "delete from " + namespace + ".`" + "zillion_data_" + schema.table_name + "`");
        }
        return count;
    }

    @Override
    public void scan(SchemaRepositoryContainer container, ZillionTableSchema schema, SchemaWrapper schemaWrapper, JSONArray ReturnColumns, ZillionCriteriaGroup group, String QueryType, JSONArray content, ZillionQueryTmp zqt, ZipArchiveOutputStream out, AsyncJob job, boolean SortInDB, JSONArray OrderBy, long Limit_Skip, long Limit_Count, ZillionQueryResult result, JSONObject Set2) throws Exception {
        try (Connection conn = this.getConnection();){
            String ori_tableName = "zillion_data_" + schema.table_name + (schemaWrapper.child_name == null ? "" : "_" + schemaWrapper.child_name);
            String ori_tableName_full = String.valueOf(schema.Namespace) + ".`" + ori_tableName + "`";
            String[] keysInner = group.index_index == -1 ? schema.Key : schema.Indexes.get((int)group.index_index).Key;
            MySQLUtil.scan(conn, ori_tableName_full, container, schema, schemaWrapper, ReturnColumns, group.CriteriaList, QueryType, content, zqt, out, job, keysInner, SortInDB, OrderBy, Limit_Skip, Limit_Count, result, Set2);
        }
    }

    @Override
    public void batch_process(ZillionTableSchema schema, SchemaWrapper wrapper, String QueryType, JSONArray InsertObjects, JSONObject Set2, boolean is_put) throws Exception {
        try (Connection conn = this.getConnection();){
            String ori_tableName = "zillion_data_" + schema.table_name + (wrapper.child_name == null ? "" : "_" + wrapper.child_name);
            String ori_tableName_full = String.valueOf(schema.Namespace) + ".`" + ori_tableName + "`";
            MySQLUtil.batch_process(conn, ori_tableName_full, schema, QueryType, InsertObjects, is_put);
        }
    }

    @Override
    public JSONArray batch_get(ZillionTableSchema schema, ITableWrapper table_wrapper, JSONArray InsertObjects, JSONArray content, Map<String, Boolean> ReturnColumnsMap) throws Exception {
        JSONArray result = new JSONArray();
        try (Connection conn = this.getConnection();){
            TableWrapper_MySQL TableWrapper_MySQL2 = (TableWrapper_MySQL)table_wrapper;
            String ori_tableName_full = String.valueOf(schema.Namespace) + "." + "`" + TableWrapper_MySQL2.tableName + "`";
            result = MySQLUtil.batch_get(conn, ori_tableName_full, schema, InsertObjects, content, ReturnColumnsMap);
        }
        return result;
    }

    @Override
    public ITableWrapper generateTableWrapper(String namespace, String ori_tableName, int exist_count) throws Exception {
        TableWrapper_MySQL wrapper = new TableWrapper_MySQL(exist_count, ori_tableName);
        return wrapper;
    }

    private void ori_create_index(String namespace, ZillionTableSchema schema, ZillionTableIndex schema_index, String ori_tableName) throws Exception {
        StringBuffer sb_key = new StringBuffer();
        String[] stringArray = schema_index.Key;
        int n = schema_index.Key.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            ZillionTableColumn column = schema.ColumnMap.get(key);
            if (sb_key.length() != 0) {
                sb_key.append(",");
            }
            sb_key.append("`");
            sb_key.append(column.Name);
            sb_key.append("`");
            ++n2;
        }
        String stringSQL = "ALTER TABLE " + namespace + "." + "`" + ori_tableName + "`" + " ADD INDEX " + schema_index.index_name + "(" + sb_key.toString() + ")";
        try (Connection conn = this.getConnection();){
            MySQLUtil.ori_execute(conn, stringSQL);
        }
    }

    private void ori_create_table_MySQL(String namespace, ZillionTableSchema schema, String ori_tableName) throws Exception {
        ZillionTableColumn column;
        String key;
        StringBuffer sb_table = new StringBuffer();
        StringBuffer sb_key = new StringBuffer();
        String[] stringArray = schema.Key;
        int n = schema.Key.length;
        int n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            column = schema.ColumnMap.get(key);
            this.generateColumn_MySQL(sb_table, column);
            if (sb_key.length() != 0) {
                sb_key.append(",");
            }
            sb_key.append("`");
            sb_key.append(column.Name);
            sb_key.append("`");
            ++n2;
        }
        stringArray = schema.OtherColumn;
        n = schema.OtherColumn.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            column = schema.ColumnMap.get(key);
            this.generateColumn_MySQL(sb_table, column);
            ++n2;
        }
        String stringSQL = "CREATE TABLE " + namespace + "." + "`" + ori_tableName + "`" + "(" + sb_table.toString() + ",PRIMARY KEY (" + sb_key.toString() + ")) ENGINE=" + DEFAULT_STORAGE_ENGINE + " DEFAULT CHARSET=" + DEFAULT_CHARACTER_SET + ";";
        try (Connection conn = this.getConnection();){
            MySQLUtil.ori_execute(conn, stringSQL);
        }
    }

    private void ori_drop_index(String namespace, String ori_tableName, String index_name) throws Exception {
        String stringSQL = "alter table " + namespace + "." + "`" + ori_tableName + "` drop index `" + index_name + "`";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.execute();
            stmt.close();
        }
    }

    @Override
    public void ori_drop_table(String namespace, String ori_tableName) throws Exception {
        String stringSQL = "drop table " + namespace + "." + "`" + ori_tableName + "`";
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.execute();
            stmt.close();
        }
    }

    private void generateColumn_MySQL(StringBuffer sb_table, ZillionTableColumn column) {
        if (sb_table.length() != 0) {
            sb_table.append(",");
        }
        sb_table.append("`");
        sb_table.append(column.Name);
        sb_table.append("`");
        sb_table.append(" ");
        if (column.Type == ZillionTableColumnEnum.LONG) {
            sb_table.append("bigint");
        } else if (column.Type == ZillionTableColumnEnum.DOUBLE) {
            sb_table.append("double");
        } else if (column.Type == ZillionTableColumnEnum.STRING || column.Type == ZillionTableColumnEnum.COMPRESSSTRING) {
            int max_length_real;
            int n = max_length_real = column.max_length == Integer.MAX_VALUE ? DEFAULT_VARCHAR_LENGTH : column.max_length;
            if (max_length_real <= 255) {
                sb_table.append("varchar(" + max_length_real + ")");
            } else if (max_length_real <= 65535) {
                sb_table.append("text");
            } else if (max_length_real <= 0xFFFFFF) {
                sb_table.append("mediumtext");
            } else {
                sb_table.append("longtext");
            }
            if (column.ASCIIString) {
                sb_table.append(" CHARACTER SET latin1 COLLATE latin1_general_ci");
            }
        } else if (column.Type == ZillionTableColumnEnum.BOOLEAN) {
            sb_table.append("int");
        }
        if (column.NotNull || !column.NotNull && column.NullValueConvert) {
            sb_table.append(" NOT NULL");
        } else {
            sb_table.append(" DEFAULT NULL");
        }
    }

    @Override
    public List<String> ori_namespaceList() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        try (Connection conn = this.getConnection();){
            String stringSQL = "select * from information_schema.schemata";
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String SCHEMA_NAME = rs.getString("SCHEMA_NAME");
                if (SCHEMA_NAME.equals("information_schema") || SCHEMA_NAME.equals("mysql")) continue;
                result.add(SCHEMA_NAME);
            }
            rs.close();
            stmt.close();
        }
        return result;
    }

    @Override
    public boolean ori_tableExists(String namespace, String ori_tableName) throws Exception {
        boolean result = false;
        try (Connection conn = this.getConnection();){
            String stringSQL = "select * from information_schema.tables where table_schema=? and table_name=?";
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.setString(1, namespace);
            stmt.setString(2, ori_tableName);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                result = true;
            }
            rs.close();
            stmt.close();
        }
        return result;
    }

    @Override
    public List<String> ori_tableList(String namespace) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        try (Connection conn = this.getConnection();){
            String stringSQL = "select * from information_schema.tables WHERE table_schema=?";
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            stmt.setString(1, namespace);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String TABLE_NAME = rs.getString("TABLE_NAME");
                result.add(TABLE_NAME);
            }
            rs.close();
            stmt.close();
        }
        return result;
    }

    public int ori_table_count(String namespace, String ori_tableName) throws Exception {
        int count = 0;
        try (Connection conn = this.getConnection();){
            String stringSQL = "select count(*) from " + namespace + "." + "`" + ori_tableName + "`";
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        return count;
    }
}

