/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.async;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.database.agent.IZillionAgent;
import com.zillion.database.async.AsyncJob;
import com.zillion.database.async.AsyncJobRepository;
import com.zillion.database.async.AsyncJobThread;
import com.zillion.database.async.AsyncResultSet;
import java.util.List;
import java.util.UUID;

public class AsyncUtil {
    public static long count_wait = 10000L;

    public static String SubmitJob(IZillionAgent agent, JSONObject queryJSON) throws Exception {
        String QueryType = (String)queryJSON.get((Object)"QueryType");
        String uuid = UUID.randomUUID().toString();
        AsyncJob job = new AsyncJob(uuid, queryJSON);
        if ((QueryType.equals("select") || QueryType.equals("combine_select")) && queryJSON.containsKey((Object)"PageSize") && queryJSON.containsKey((Object)"Timeout")) {
            long PageSize = (Long)queryJSON.get((Object)"PageSize");
            long Timeout = (Long)queryJSON.get((Object)"Timeout");
            job.brs = new AsyncResultSet(uuid, PageSize, Timeout);
        }
        AsyncJobThread thread = new AsyncJobThread(agent, queryJSON, job);
        AsyncJobRepository.Add(job, thread);
        thread.start();
        return uuid;
    }

    public static JSONObject QueryJobStatus(String uuid) throws Exception {
        JSONObject result = AsyncJobRepository.QueryJobStatus(uuid);
        return result;
    }

    public static void ClearJob(String uuid) throws Exception {
        AsyncJobRepository.ClearJob(uuid);
    }

    public static JSONArray GetJobList() throws Exception {
        JSONArray result = AsyncJobRepository.GetJobList();
        return result;
    }

    public static JSONArray RemoveTimeoutJob() throws Exception {
        JSONArray result = AsyncJobRepository.RemoveTimeoutJob();
        return result;
    }

    public static JSONArray TryPopOnePage(String uuid) throws Exception {
        AsyncResultSet brs = AsyncJobRepository.GetBufferedResultSet(uuid);
        List<JSONObject> dataList = brs.TryPopOnePage();
        JSONArray result = new JSONArray();
        for (JSONObject data : dataList) {
            result.add((Object)data);
        }
        return result;
    }

    public static void Finish(String uuid) throws Exception {
        AsyncJobRepository.GetBufferedResultSet(uuid).Finish(false, "Client end job");
    }
}

