/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.igfs.IgfsCommunicationMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class IgfsDeleteMessage
extends IgfsCommunicationMessage {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id;
    @GridDirectTransient
    private IgniteCheckedException err;
    private byte[] errBytes;

    public IgfsDeleteMessage() {
    }

    public IgfsDeleteMessage(IgniteUuid id) {
        assert (id != null);
        this.id = id;
    }

    public IgfsDeleteMessage(IgniteUuid id, IgniteCheckedException err) {
        assert (err != null);
        this.id = id;
        this.err = err;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public IgniteCheckedException error() {
        return this.err;
    }

    @Override
    public void prepareMarshal(Marshaller marsh) throws IgniteCheckedException {
        super.prepareMarshal(marsh);
        if (this.err != null) {
            this.errBytes = U.marshal(marsh, (Object)this.err);
        }
    }

    @Override
    public void finishUnmarshal(Marshaller marsh, @Nullable ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(marsh, ldr);
        if (this.errBytes != null) {
            this.err = (IgniteCheckedException)U.unmarshal(marsh, this.errBytes, ldr);
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeIgniteUuid("id", this.id)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.id = reader.readIgniteUuid("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(IgfsDeleteMessage.class);
    }

    @Override
    public short directType() {
        return 67;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return S.toString(IgfsDeleteMessage.class, this);
    }
}

