/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.igfs.IgfsBlockLocation;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgfsBlockLocationImpl
implements IgfsBlockLocation,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private long start;
    private long len;
    @GridToStringInclude
    private Collection<UUID> nodeIds;
    private Collection<String> names;
    @GridToStringInclude
    private Collection<String> hosts;

    public IgfsBlockLocationImpl() {
    }

    public IgfsBlockLocationImpl(IgfsBlockLocation location, long len) {
        assert (location != null);
        this.start = location.start();
        this.len = len;
        this.nodeIds = location.nodeIds();
        this.names = location.names();
        this.hosts = location.hosts();
    }

    public IgfsBlockLocationImpl(long start, long len, Collection<ClusterNode> nodes) {
        assert (start >= 0L);
        assert (len > 0L);
        assert (nodes != null && !nodes.isEmpty());
        this.start = start;
        this.len = len;
        this.convertFromNodes(nodes);
    }

    public IgfsBlockLocationImpl(long start, long len, IgfsBlockLocation block) {
        assert (start >= 0L);
        assert (len > 0L);
        this.start = start;
        this.len = len;
        this.nodeIds = block.nodeIds();
        this.names = block.names();
        this.hosts = block.hosts();
    }

    public IgfsBlockLocationImpl(long start, long len, Collection<String> names, Collection<String> hosts) {
        assert (start >= 0L);
        assert (len > 0L);
        assert (names != null && !names.isEmpty());
        assert (hosts != null && !hosts.isEmpty());
        this.start = start;
        this.len = len;
        this.nodeIds = Collections.emptySet();
        this.names = names;
        this.hosts = hosts;
    }

    @Override
    public long start() {
        return this.start;
    }

    @Override
    public long length() {
        return this.len;
    }

    public void increaseLength(long addLen) {
        this.len += addLen;
    }

    public void length(long len) {
        this.len = len;
    }

    @Override
    public Collection<UUID> nodeIds() {
        return this.nodeIds;
    }

    @Override
    public Collection<String> names() {
        return this.names;
    }

    @Override
    public Collection<String> hosts() {
        return this.hosts;
    }

    public int hashCode() {
        int res = (int)(this.start ^ this.start >>> 32);
        res = 31 * res + (int)(this.len ^ this.len >>> 32);
        res = 31 * res + this.nodeIds.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgfsBlockLocationImpl that = (IgfsBlockLocationImpl)o;
        return this.len == that.len && this.start == that.start && F.eq(this.nodeIds, that.nodeIds) && F.eq(this.names, that.names) && F.eq(this.hosts, that.hosts);
    }

    public String toString() {
        return S.toString(IgfsBlockLocationImpl.class, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (this.names != null);
        assert (this.hosts != null);
        out.writeLong(this.start);
        out.writeLong(this.len);
        out.writeBoolean(this.nodeIds != null);
        if (this.nodeIds != null) {
            out.writeInt(this.nodeIds.size());
            for (UUID nodeId : this.nodeIds) {
                U.writeUuid(out, nodeId);
            }
        }
        out.writeInt(this.names.size());
        for (String name : this.names) {
            out.writeUTF(name);
        }
        out.writeInt(this.hosts.size());
        for (String host : this.hosts) {
            out.writeUTF(host);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int i;
        int size;
        this.start = in.readLong();
        this.len = in.readLong();
        if (in.readBoolean()) {
            size = in.readInt();
            this.nodeIds = new ArrayList<UUID>(size);
            for (i = 0; i < size; ++i) {
                this.nodeIds.add(U.readUuid(in));
            }
        }
        size = in.readInt();
        this.names = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.names.add(in.readUTF());
        }
        size = in.readInt();
        this.hosts = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.hosts.add(in.readUTF());
        }
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter rawWriter = writer.rawWriter();
        assert (this.names != null);
        assert (this.hosts != null);
        rawWriter.writeLong(this.start);
        rawWriter.writeLong(this.len);
        rawWriter.writeBoolean(this.nodeIds != null);
        if (this.nodeIds != null) {
            rawWriter.writeInt(this.nodeIds.size());
            for (UUID nodeId : this.nodeIds) {
                U.writeUuid(rawWriter, nodeId);
            }
        }
        rawWriter.writeInt(this.names.size());
        for (String name : this.names) {
            rawWriter.writeString(name);
        }
        rawWriter.writeInt(this.hosts.size());
        for (String host : this.hosts) {
            rawWriter.writeString(host);
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        int i;
        int size;
        BinaryRawReader rawReader = reader.rawReader();
        this.start = rawReader.readLong();
        this.len = rawReader.readLong();
        if (rawReader.readBoolean()) {
            size = rawReader.readInt();
            this.nodeIds = new ArrayList<UUID>(size);
            for (i = 0; i < size; ++i) {
                this.nodeIds.add(U.readUuid(rawReader));
            }
        }
        size = rawReader.readInt();
        this.names = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.names.add(rawReader.readString());
        }
        size = rawReader.readInt();
        this.hosts = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.hosts.add(rawReader.readString());
        }
    }

    private void convertFromNodes(Collection<ClusterNode> nodes) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        LinkedHashSet<String> hosts = new LinkedHashSet<String>();
        ArrayList<UUID> nodeIds = new ArrayList<UUID>(nodes.size());
        for (ClusterNode node : nodes) {
            try {
                Collection<InetAddress> addrs = U.toInetAddresses(node);
                for (InetAddress addr : addrs) {
                    if (addr.getHostName() == null) {
                        names.add(addr.getHostAddress() + ":" + 9001);
                        continue;
                    }
                    names.add(addr.getHostName() + ":" + 9001);
                    hosts.add(addr.getHostName());
                }
            }
            catch (IgniteCheckedException ignored) {
                names.addAll(node.addresses());
            }
            nodeIds.add(node.id());
        }
        this.nodeIds = nodeIds;
        this.names = names;
        this.hosts = hosts;
    }
}

