/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheGroupMetricsMXBeanImpl;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.AllocatedPageTracker;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FileVersionCheckingFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.PersistentStorageIOException;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePageStoreManager
extends GridCacheSharedManagerAdapter
implements IgnitePageStoreManager {
    public static final String FILE_SUFFIX = ".bin";
    public static final String PART_FILE_PREFIX = "part-";
    public static final String INDEX_FILE_NAME = "index.bin";
    public static final String PART_FILE_TEMPLATE = "part-%d.bin";
    public static final String CACHE_DIR_PREFIX = "cache-";
    public static final String CACHE_GRP_DIR_PREFIX = "cacheGroup-";
    public static final String CACHE_DATA_FILENAME = "cache_data.dat";
    public static final String DFLT_STORE_DIR = "db";
    private static final Marshaller marshaller = new JdkMarshaller();
    private final Map<Integer, CacheStoreHolder> idxCacheStores = new ConcurrentHashMap<Integer, CacheStoreHolder>();
    private final IgniteConfiguration igniteCfg;
    private FileIOFactory pageStoreFileIoFactory;
    private FileIOFactory pageStoreV1FileIoFactory;
    private final DataStorageConfiguration dsCfg;
    private File storeWorkDir;
    private final long metaPageId = PageIdUtils.pageId(-1, (byte)2, 0);
    private final Set<Integer> grpsWithoutIdx = Collections.newSetFromMap(new ConcurrentHashMap());

    public FilePageStoreManager(GridKernalContext ctx) {
        this.igniteCfg = ctx.config();
        DataStorageConfiguration dsCfg = this.igniteCfg.getDataStorageConfiguration();
        assert (dsCfg != null);
        this.dsCfg = dsCfg;
        this.pageStoreV1FileIoFactory = this.pageStoreFileIoFactory = dsCfg.getFileIOFactory();
    }

    @Override
    public void start0() throws IgniteCheckedException {
        GridKernalContext ctx = this.cctx.kernalContext();
        if (ctx.clientNode()) {
            return;
        }
        PdsFolderSettings folderSettings = ctx.pdsFolderResolver().resolveFolders();
        this.storeWorkDir = new File(folderSettings.persistentStoreRootPath(), folderSettings.folderName());
        U.ensureDirectory(this.storeWorkDir, "page store work directory", this.log);
    }

    @Override
    public void stop0(boolean cancel) {
        IgniteCheckedException ex;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping page store manager.");
        }
        if ((ex = this.shutdown(false)) != null) {
            U.error(this.log, "Failed to gracefully stop page store manager", ex);
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activate page store manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.start0();
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate page store manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.stop0(true);
        this.idxCacheStores.clear();
    }

    @Override
    public void beginRecover() {
        for (CacheStoreHolder holder : this.idxCacheStores.values()) {
            holder.idxStore.beginRecover();
            for (FilePageStore partStore : holder.partStores) {
                partStore.beginRecover();
            }
        }
    }

    @Override
    public void finishRecover() throws IgniteCheckedException {
        try {
            for (CacheStoreHolder holder : this.idxCacheStores.values()) {
                holder.idxStore.finishRecover();
                for (FilePageStore partStore : holder.partStores) {
                    partStore.finishRecover();
                }
            }
        }
        catch (PersistentStorageIOException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public void initializeForCache(CacheGroupDescriptor grpDesc, StoredCacheData cacheData) throws IgniteCheckedException {
        int grpId = grpDesc.groupId();
        if (!this.idxCacheStores.containsKey(grpId)) {
            CacheStoreHolder holder = this.initForCache(grpDesc, cacheData.config());
            CacheStoreHolder old = this.idxCacheStores.put(grpId, holder);
            assert (old == null) : "Non-null old store holder for cache: " + cacheData.config().getName();
        }
    }

    @Override
    public void initializeForMetastorage() throws IgniteCheckedException {
        int grpId = MetaStorage.METASTORAGE_CACHE_ID;
        if (!this.idxCacheStores.containsKey(grpId)) {
            CacheStoreHolder holder = this.initDir(new File(this.storeWorkDir, "metastorage"), grpId, 1, delta -> {});
            CacheStoreHolder old = this.idxCacheStores.put(grpId, holder);
            assert (old == null) : "Non-null old store holder for metastorage";
        }
    }

    @Override
    public void storeCacheData(StoredCacheData cacheData, boolean overwrite) throws IgniteCheckedException {
        File cacheWorkDir = this.cacheWorkDir(cacheData.config());
        this.checkAndInitCacheWorkDir(cacheWorkDir);
        assert (cacheWorkDir.exists()) : "Work directory does not exist: " + cacheWorkDir;
        File file = cacheData.config().getGroupName() != null ? new File(cacheWorkDir, cacheData.config().getName() + CACHE_DATA_FILENAME) : new File(cacheWorkDir, CACHE_DATA_FILENAME);
        if (overwrite || !file.exists() || file.length() == 0L) {
            try {
                file.createNewFile();
                try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
                    marshaller.marshal(cacheData, stream);
                }
            }
            catch (IOException ex) {
                throw new IgniteCheckedException("Failed to persist cache configuration: " + cacheData.config().getName(), ex);
            }
        }
    }

    @Override
    public void shutdownForCacheGroup(CacheGroupContext grp, boolean destroy) throws IgniteCheckedException {
        this.grpsWithoutIdx.remove(grp.groupId());
        CacheStoreHolder old = this.idxCacheStores.remove(grp.groupId());
        assert (old != null) : "Missing cache store holder [cache=" + grp.cacheOrGroupName() + ", locNodeId=" + this.cctx.localNodeId() + ", gridName=" + this.cctx.igniteInstanceName() + ']';
        IgniteCheckedException ex = this.shutdown(old, destroy, null);
        if (destroy) {
            this.removeCacheGroupConfigurationData(grp);
        }
        if (ex != null) {
            throw ex;
        }
    }

    @Override
    public void onPartitionCreated(int grpId, int partId) throws IgniteCheckedException {
    }

    @Override
    public void onPartitionDestroyed(int grpId, int partId, int tag) throws IgniteCheckedException {
        assert (partId <= 65500);
        PageStore store = this.getStore(grpId, partId);
        assert (store instanceof FilePageStore) : store;
        ((FilePageStore)store).truncate(tag);
    }

    @Override
    public void read(int grpId, long pageId, ByteBuffer pageBuf) throws IgniteCheckedException {
        this.read(grpId, pageId, pageBuf, false);
    }

    public void read(int cacheId, long pageId, ByteBuffer pageBuf, boolean keepCrc) throws IgniteCheckedException {
        PageStore store = this.getStore(cacheId, PageIdUtils.partId(pageId));
        try {
            store.read(pageId, pageBuf, keepCrc);
        }
        catch (PersistentStorageIOException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public boolean exists(int grpId, int partId) throws IgniteCheckedException {
        PageStore store = this.getStore(grpId, partId);
        return store.exists();
    }

    @Override
    public void readHeader(int grpId, int partId, ByteBuffer buf) throws IgniteCheckedException {
        PageStore store = this.getStore(grpId, partId);
        try {
            store.readHeader(buf);
        }
        catch (PersistentStorageIOException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public void write(int grpId, long pageId, ByteBuffer pageBuf, int tag) throws IgniteCheckedException {
        this.writeInternal(grpId, pageId, pageBuf, tag, true);
    }

    @Override
    public long pageOffset(int grpId, long pageId) throws IgniteCheckedException {
        PageStore store = this.getStore(grpId, PageIdUtils.partId(pageId));
        return store.pageOffset(pageId);
    }

    public PageStore writeInternal(int cacheId, long pageId, ByteBuffer pageBuf, int tag, boolean calculateCrc) throws IgniteCheckedException {
        int partId = PageIdUtils.partId(pageId);
        PageStore store = this.getStore(cacheId, partId);
        try {
            store.write(pageId, pageBuf, tag, calculateCrc);
        }
        catch (PersistentStorageIOException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
        return store;
    }

    public Path getPath(boolean isSharedGroup, String cacheOrGroupName, int partId) {
        return this.getPartitionFile(this.cacheWorkDir(isSharedGroup, cacheOrGroupName), partId).toPath();
    }

    private CacheStoreHolder initForCache(CacheGroupDescriptor grpDesc, CacheConfiguration ccfg) throws IgniteCheckedException {
        assert (!grpDesc.sharedGroup() || ccfg.getGroupName() != null) : ccfg.getName();
        File cacheWorkDir = this.cacheWorkDir(ccfg);
        String dataRegionName = grpDesc.config().getDataRegionName();
        DataRegionMetricsImpl regionMetrics = this.cctx.database().dataRegion(dataRegionName).memoryMetrics();
        int grpId = CU.cacheId(grpDesc.cacheOrGroupName());
        CacheGroupMetricsMXBeanImpl.GroupAllocationTrucker allocatedTracker = regionMetrics.getOrAllocateGroupPageAllocationTracker(grpId);
        return this.initDir(cacheWorkDir, grpDesc.groupId(), grpDesc.config().getAffinity().partitions(), allocatedTracker);
    }

    private CacheStoreHolder initDir(File cacheWorkDir, int grpId, int partitions, AllocatedPageTracker allocatedTracker) throws IgniteCheckedException {
        try {
            boolean dirExisted = this.checkAndInitCacheWorkDir(cacheWorkDir);
            File idxFile = new File(cacheWorkDir, INDEX_FILE_NAME);
            if (dirExisted && !idxFile.exists()) {
                this.grpsWithoutIdx.add(grpId);
            }
            FileVersionCheckingFactory pageStoreFactory = new FileVersionCheckingFactory(this.pageStoreFileIoFactory, this.pageStoreV1FileIoFactory, this.igniteCfg.getDataStorageConfiguration());
            FilePageStore idxStore = pageStoreFactory.createPageStore((byte)2, idxFile, allocatedTracker);
            FilePageStore[] partStores = new FilePageStore[partitions];
            for (int partId = 0; partId < partStores.length; ++partId) {
                FilePageStore partStore;
                partStores[partId] = partStore = pageStoreFactory.createPageStore((byte)1, this.getPartitionFile(cacheWorkDir, partId), allocatedTracker);
            }
            return new CacheStoreHolder(idxStore, partStores);
        }
        catch (PersistentStorageIOException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @NotNull
    private File getPartitionFile(File cacheWorkDir, int partId) {
        return new File(cacheWorkDir, String.format(PART_FILE_TEMPLATE, partId));
    }

    private boolean checkAndInitCacheWorkDir(File cacheWorkDir) throws IgniteCheckedException {
        boolean dirExisted = false;
        if (!cacheWorkDir.exists()) {
            boolean res = cacheWorkDir.mkdirs();
            if (!res) {
                throw new IgniteCheckedException("Failed to initialize cache working directory (failed to create, make sure the work folder has correct permissions): " + cacheWorkDir.getAbsolutePath());
            }
        } else {
            if (cacheWorkDir.isFile()) {
                throw new IgniteCheckedException("Failed to initialize cache working directory (a file with the same name already exists): " + cacheWorkDir.getAbsolutePath());
            }
            File lockF = new File(cacheWorkDir, "snapshot-started.loc");
            Path cacheWorkDirPath = cacheWorkDir.toPath();
            Path tmp = cacheWorkDirPath.getParent().resolve(cacheWorkDir.getName() + ".tmp");
            if (Files.exists(tmp, new LinkOption[0]) && Files.isDirectory(tmp, new LinkOption[0]) && Files.exists(tmp.resolve("finished.tmp"), new LinkOption[0])) {
                U.warn(this.log, "Ignite node crashed during the snapshot restore process (there is a snapshot restore lock file left for cache). But old version of cache was saved. Trying to restore it. Cache - [" + cacheWorkDir.getAbsolutePath() + ']');
                U.delete(cacheWorkDir);
                try {
                    Files.move(tmp, cacheWorkDirPath, StandardCopyOption.ATOMIC_MOVE);
                    cacheWorkDirPath.resolve("finished.tmp").toFile().delete();
                }
                catch (IOException e) {
                    throw new IgniteCheckedException(e);
                }
            } else if (lockF.exists()) {
                U.warn(this.log, "Ignite node crashed during the snapshot restore process (there is a snapshot restore lock file left for cache). Will remove both the lock file and incomplete cache directory [cacheDir=" + cacheWorkDir.getAbsolutePath() + ']');
                boolean deleted = U.delete(cacheWorkDir);
                if (!deleted) {
                    throw new IgniteCheckedException("Failed to remove obsolete cache working directory (remove the directory manually and make sure the work folder has correct permissions): " + cacheWorkDir.getAbsolutePath());
                }
                cacheWorkDir.mkdirs();
            } else {
                dirExisted = true;
            }
            if (!cacheWorkDir.exists()) {
                throw new IgniteCheckedException("Failed to initialize cache working directory (failed to create, make sure the work folder has correct permissions): " + cacheWorkDir.getAbsolutePath());
            }
            if (Files.exists(tmp, new LinkOption[0])) {
                U.delete(tmp);
            }
        }
        return dirExisted;
    }

    @Override
    public void sync(int grpId, int partId) throws IgniteCheckedException {
        try {
            this.getStore(grpId, partId).sync();
        }
        catch (PersistentStorageIOException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public void ensure(int grpId, int partId) throws IgniteCheckedException {
        try {
            this.getStore(grpId, partId).ensure();
        }
        catch (PersistentStorageIOException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public long allocatePage(int grpId, int partId, byte flags) throws IgniteCheckedException {
        assert (partId <= 65500 || partId == 65535);
        PageStore store = this.getStore(grpId, partId);
        try {
            long pageIdx = store.allocatePage();
            return PageIdUtils.pageId(partId, flags, (int)pageIdx);
        }
        catch (PersistentStorageIOException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
    }

    @Override
    public long metaPageId(int grpId) {
        return this.metaPageId;
    }

    @Override
    public int pages(int grpId, int partId) throws IgniteCheckedException {
        PageStore store = this.getStore(grpId, partId);
        return store.pages();
    }

    @Override
    public Map<String, StoredCacheData> readCacheConfigurations() throws IgniteCheckedException {
        if (this.cctx.kernalContext().clientNode()) {
            return Collections.emptyMap();
        }
        File[] files = this.storeWorkDir.listFiles();
        if (files == null) {
            return Collections.emptyMap();
        }
        HashMap<String, StoredCacheData> ccfgs = new HashMap<String, StoredCacheData>();
        for (File file : files) {
            if (!file.isDirectory()) continue;
            if (file.getName().startsWith(CACHE_DIR_PREFIX)) {
                File conf = new File(file, CACHE_DATA_FILENAME);
                if (!conf.exists() || conf.length() <= 0L) continue;
                StoredCacheData cacheData = this.readCacheData(conf);
                ccfgs.put(cacheData.config().getName(), cacheData);
                continue;
            }
            if (!file.getName().startsWith(CACHE_GRP_DIR_PREFIX)) continue;
            this.readCacheGroupCaches(file, ccfgs);
        }
        return ccfgs;
    }

    private void readCacheGroupCaches(File grpDir, Map<String, StoredCacheData> ccfgs) throws IgniteCheckedException {
        File[] files = grpDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory() || !file.getName().endsWith(CACHE_DATA_FILENAME) || file.length() <= 0L) continue;
            StoredCacheData cacheData = this.readCacheData(file);
            ccfgs.put(cacheData.config().getName(), cacheData);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StoredCacheData readCacheData(File conf) throws IgniteCheckedException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(conf));){
            StoredCacheData storedCacheData = (StoredCacheData)marshaller.unmarshal(stream, U.resolveClassLoader(this.igniteCfg));
            return storedCacheData;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to read cache configuration from disk for cache: " + conf.getAbsolutePath(), e);
        }
    }

    @Override
    public boolean hasIndexStore(int grpId) {
        return !this.grpsWithoutIdx.contains(grpId);
    }

    @Override
    public long pagesAllocated(int grpId) {
        CacheStoreHolder holder = this.idxCacheStores.get(grpId);
        if (holder == null) {
            return 0L;
        }
        long pageCnt = holder.idxStore.pages();
        for (int i = 0; i < holder.partStores.length; ++i) {
            pageCnt += (long)holder.partStores[i].pages();
        }
        return pageCnt;
    }

    public File workDir() {
        return this.storeWorkDir;
    }

    public File cacheWorkDir(CacheConfiguration ccfg) {
        boolean isSharedGrp = ccfg.getGroupName() != null;
        return this.cacheWorkDir(isSharedGrp, isSharedGrp ? ccfg.getGroupName() : ccfg.getName());
    }

    public File cacheWorkDir(boolean isSharedGroup, String cacheOrGroupName) {
        String dirName = isSharedGroup ? CACHE_GRP_DIR_PREFIX + cacheOrGroupName : CACHE_DIR_PREFIX + cacheOrGroupName;
        return new File(this.storeWorkDir, dirName);
    }

    private IgniteCheckedException shutdown(boolean cleanFiles) {
        IgniteCheckedException ex = null;
        for (CacheStoreHolder holder : this.idxCacheStores.values()) {
            ex = this.shutdown(holder, cleanFiles, ex);
        }
        return ex;
    }

    private IgniteCheckedException shutdown(CacheStoreHolder holder, boolean cleanFile, @Nullable IgniteCheckedException aggr) {
        aggr = this.shutdown(holder.idxStore, cleanFile, aggr);
        for (FilePageStore store : holder.partStores) {
            if (store == null) continue;
            aggr = this.shutdown(store, cleanFile, aggr);
        }
        return aggr;
    }

    private void removeCacheGroupConfigurationData(CacheGroupContext ctx) throws IgniteCheckedException {
        File cacheGrpDir = this.cacheWorkDir(ctx.sharedGroup(), ctx.cacheOrGroupName());
        if (cacheGrpDir != null && cacheGrpDir.exists()) {
            DirectoryStream.Filter<Path> cacheCfgFileFilter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path path) {
                    return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(FilePageStoreManager.CACHE_DATA_FILENAME);
                }
            };
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(cacheGrpDir.toPath(), (DirectoryStream.Filter<? super Path>)cacheCfgFileFilter);){
                for (Path path : dirStream) {
                    Files.deleteIfExists(path);
                }
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to delete cache configurations of group: " + ctx.toString(), e);
            }
        }
    }

    @Override
    public void removeCacheData(StoredCacheData cacheData) throws IgniteCheckedException {
        CacheConfiguration<?, ?> cacheCfg = cacheData.config();
        File cacheWorkDir = this.cacheWorkDir(cacheCfg);
        File file = cacheData.config().getGroupName() != null ? new File(cacheWorkDir, cacheCfg.getName() + CACHE_DATA_FILENAME) : new File(cacheWorkDir, CACHE_DATA_FILENAME);
        if (file.exists() && !file.delete()) {
            throw new IgniteCheckedException("Failed to delete cache configuration:" + cacheCfg.getName());
        }
    }

    private IgniteCheckedException shutdown(FilePageStore store, boolean cleanFile, IgniteCheckedException aggr) {
        try {
            if (store != null) {
                store.stop(cleanFile);
            }
        }
        catch (IgniteCheckedException e) {
            if (aggr == null) {
                aggr = new IgniteCheckedException("Failed to gracefully shutdown store");
            }
            aggr.addSuppressed(e);
        }
        return aggr;
    }

    public PageStore getStore(int grpId, int partId) throws IgniteCheckedException {
        CacheStoreHolder holder = this.idxCacheStores.get(grpId);
        if (holder == null) {
            throw new IgniteCheckedException("Failed to get page store for the given cache ID (cache has not been started): " + grpId);
        }
        if (partId == 65535) {
            return holder.idxStore;
        }
        if (partId > 65500) {
            throw new IgniteCheckedException("Partition ID is reserved: " + partId);
        }
        FilePageStore store = holder.partStores[partId];
        if (store == null) {
            throw new IgniteCheckedException("Failed to get page store for the given partition ID (partition has not been created) [grpId=" + grpId + ", partId=" + partId + ']');
        }
        return store;
    }

    @Override
    public void beforeCacheGroupStart(CacheGroupDescriptor grpDesc) {
        if (grpDesc.persistenceEnabled()) {
            boolean localEnabled = this.cctx.database().walEnabled(grpDesc.groupId(), true);
            boolean globalEnabled = this.cctx.database().walEnabled(grpDesc.groupId(), false);
            if (!localEnabled || !globalEnabled) {
                File dir = this.cacheWorkDir(grpDesc.config());
                assert (dir.exists());
                boolean res = IgniteUtils.delete(dir);
                assert (res);
                if (!globalEnabled) {
                    grpDesc.walEnabled(false);
                }
            }
        }
    }

    public void setPageStoreFileIOFactories(FileIOFactory pageStoreFileIoFactory, FileIOFactory pageStoreV1FileIoFactory) {
        this.pageStoreFileIoFactory = pageStoreFileIoFactory;
        this.pageStoreV1FileIoFactory = pageStoreV1FileIoFactory;
    }

    public FileIOFactory getPageStoreFileIoFactory() {
        return this.pageStoreFileIoFactory;
    }

    public int pageSize() {
        return this.dsCfg.getPageSize();
    }

    private static class CacheStoreHolder {
        private final FilePageStore idxStore;
        private final FilePageStore[] partStores;

        public CacheStoreHolder(FilePageStore idxStore, FilePageStore[] partStores) {
            this.idxStore = idxStore;
            this.partStores = partStores;
        }
    }
}

