/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;

public class IncompleteObject<T> {
    protected byte[] data;
    private T obj;
    private int off;

    public IncompleteObject(byte[] data) {
        this.data = data;
    }

    protected IncompleteObject() {
    }

    public T object() {
        return this.obj;
    }

    public void object(T obj) {
        this.obj = obj;
    }

    public boolean isReady() {
        return this.data != null && this.off == this.data.length;
    }

    public byte[] data() {
        return this.data;
    }

    public void readData(ByteBuffer buf) {
        assert (this.data != null);
        int len = Math.min(this.data.length - this.off, buf.remaining());
        buf.get(this.data, this.off, len);
        this.off += len;
    }
}

