/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.TrackingPageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class TrackingPageDeltaRecord
extends PageDeltaRecord {
    private final long pageIdToMark;
    private final long nextSnapshotId;
    private final long lastSuccessfulSnapshotId;

    public TrackingPageDeltaRecord(int grpId, long pageId, long pageIdToMark, long nextSnapshotTag, long lastSuccessfulSnapshotId) {
        super(grpId, pageId);
        this.pageIdToMark = pageIdToMark;
        this.nextSnapshotId = nextSnapshotTag;
        this.lastSuccessfulSnapshotId = lastSuccessfulSnapshotId;
    }

    public long pageIdToMark() {
        return this.pageIdToMark;
    }

    public long nextSnapshotId() {
        return this.nextSnapshotId;
    }

    public long lastSuccessfulSnapshotId() {
        return this.lastSuccessfulSnapshotId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        TrackingPageIO.VERSIONS.forPage(pageAddr).markChanged(pageMem.pageBuffer(pageAddr), this.pageIdToMark, this.nextSnapshotId, this.lastSuccessfulSnapshotId, pageMem.pageSize());
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.TRACKING_PAGE_DELTA;
    }

    @Override
    public String toString() {
        return S.toString(TrackingPageDeltaRecord.class, this, "super", super.toString());
    }
}

