/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.cache.configuration.Factory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.client.ClientAuthenticationException;
import org.apache.ignite.client.ClientAuthorizationException;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.SslMode;
import org.apache.ignite.client.SslProtocol;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOffheapOutputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientChannelConfiguration;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ClientServerError;
import org.apache.ignite.internal.client.thin.ProtocolVersion;

class TcpClientChannel
implements ClientChannel {
    private static final ProtocolVersion V1_1_0 = new ProtocolVersion(1, 1, 0);
    private static final ProtocolVersion V1_0_0 = new ProtocolVersion(1, 0, 0);
    private static final Collection<ProtocolVersion> supportedVers = Arrays.asList(V1_1_0, V1_0_0);
    private ProtocolVersion ver = V1_1_0;
    private final Socket sock;
    private final OutputStream out;
    private final InputStream in;
    private final AtomicLong reqId = new AtomicLong(1L);

    TcpClientChannel(ClientChannelConfiguration cfg) throws ClientConnectionException, ClientAuthenticationException {
        TcpClientChannel.validateConfiguration(cfg);
        try {
            this.sock = TcpClientChannel.createSocket(cfg);
            this.out = this.sock.getOutputStream();
            this.in = this.sock.getInputStream();
        }
        catch (IOException e) {
            throw new ClientConnectionException(e);
        }
        this.handshake(cfg.getUserName(), cfg.getUserPassword());
    }

    @Override
    public void close() throws Exception {
        this.in.close();
        this.out.close();
        this.sock.close();
    }

    @Override
    public long send(ClientOperation op, Consumer<BinaryOutputStream> payloadWriter) throws ClientConnectionException {
        long id = this.reqId.getAndIncrement();
        try (BinaryHeapOutputStream req = new BinaryHeapOutputStream(1024);){
            req.writeInt(0);
            req.writeShort(op.code());
            req.writeLong(id);
            if (payloadWriter != null) {
                payloadWriter.accept(req);
            }
            req.writeInt(0, req.position() - 4);
            this.write(req.array(), req.position());
        }
        return id;
    }

    @Override
    public <T> T receive(ClientOperation op, long reqId, Function<BinaryInputStream, T> payloadReader) throws ClientConnectionException, ClientAuthorizationException {
        int MIN_RES_SIZE = 12;
        int resSize = new BinaryHeapInputStream(this.read(4)).readInt();
        if (resSize < 0) {
            throw new ClientProtocolError(String.format("Invalid response size: %s", resSize));
        }
        if (resSize == 0) {
            return null;
        }
        BinaryHeapInputStream resIn = new BinaryHeapInputStream(this.read(12));
        long resId = resIn.readLong();
        if (resId != reqId) {
            throw new ClientProtocolError(String.format("Unexpected response ID [%s], [%s] was expected", resId, reqId));
        }
        int status = resIn.readInt();
        if (status != 0) {
            resIn = new BinaryHeapInputStream(this.read(resSize - 12));
            String err = new BinaryReaderExImpl(null, resIn, null, true).readString();
            switch (status) {
                case 1012: {
                    throw new ClientAuthorizationException();
                }
            }
            throw new ClientServerError(err, status, reqId);
        }
        if (resSize <= 12 || payloadReader == null) {
            return null;
        }
        BinaryHeapInputStream payload = new BinaryHeapInputStream(this.read(resSize - 12));
        return payloadReader.apply(payload);
    }

    private static void validateConfiguration(ClientChannelConfiguration cfg) {
        String error = null;
        InetSocketAddress addr = cfg.getAddress();
        if (addr == null) {
            error = "At least one Ignite server node must be specified in the Ignite client configuration";
        } else if (addr.getPort() < 1024 || addr.getPort() > 49151) {
            error = String.format("Ignite client port %s is out of valid ports range 1024...49151", addr.getPort());
        }
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    private static Socket createSocket(ClientChannelConfiguration cfg) throws IOException {
        Socket sock = cfg.getSslMode() == SslMode.REQUIRED ? new ClientSslSocketFactory(cfg).create() : new Socket(cfg.getAddress().getHostName(), cfg.getAddress().getPort());
        sock.setTcpNoDelay(cfg.isTcpNoDelay());
        if (cfg.getTimeout() > 0) {
            sock.setSoTimeout(cfg.getTimeout());
        }
        if (cfg.getSendBufferSize() > 0) {
            sock.setSendBufferSize(cfg.getSendBufferSize());
        }
        if (cfg.getReceiveBufferSize() > 0) {
            sock.setReceiveBufferSize(cfg.getReceiveBufferSize());
        }
        return sock;
    }

    /*
     * Exception decompiling
     */
    private static byte[] marshalString(String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handshake(String user, String pwd) throws ClientConnectionException, ClientAuthenticationException {
        this.handshakeReq(user, pwd);
        this.handshakeRes(user, pwd);
    }

    private void handshakeReq(String user, String pwd) throws ClientConnectionException {
        try (BinaryOffheapOutputStream req = new BinaryOffheapOutputStream(32);){
            req.writeInt(0);
            req.writeByte((byte)1);
            req.writeShort(this.ver.major());
            req.writeShort(this.ver.minor());
            req.writeShort(this.ver.patch());
            req.writeByte((byte)2);
            if (this.ver.compareTo(V1_1_0) >= 0 && user != null && user.length() > 0) {
                req.writeByteArray(TcpClientChannel.marshalString(user));
                req.writeByteArray(TcpClientChannel.marshalString(pwd));
            }
            req.writeInt(0, req.position() - 4);
            this.write(req.array(), req.position());
        }
    }

    private void handshakeRes(String user, String pwd) throws ClientConnectionException, ClientAuthenticationException {
        int resSize = new BinaryHeapInputStream(this.read(4)).readInt();
        if (resSize <= 0) {
            throw new ClientProtocolError(String.format("Invalid handshake response size: %s", resSize));
        }
        BinaryHeapInputStream res = new BinaryHeapInputStream(this.read(resSize));
        if (!res.readBoolean()) {
            ProtocolVersion srvVer = new ProtocolVersion(res.readShort(), res.readShort(), res.readShort());
            try (BinaryReaderExImpl r = new BinaryReaderExImpl(null, res, null, true);){
                String err = r.readString();
                int errCode = 1;
                if (res.remaining() > 0) {
                    errCode = r.readInt();
                }
                if (errCode == 2000) {
                    throw new ClientAuthenticationException(err);
                }
                if (this.ver.equals(srvVer)) {
                    throw new ClientProtocolError(err);
                }
                if (!supportedVers.contains(srvVer) || srvVer.compareTo(V1_1_0) < 0 && user != null && user.length() > 0) {
                    throw new ClientProtocolError(String.format("Protocol version mismatch: client %s / server %s. Server details: %s", this.ver, srvVer, err));
                }
                this.ver = srvVer;
                this.handshake(user, pwd);
            }
            catch (IOException e) {
                throw new ClientConnectionException(e);
            }
        }
    }

    private byte[] read(int len) throws ClientConnectionException {
        int bytesNum;
        byte[] bytes = new byte[len];
        for (int readBytesNum = 0; readBytesNum < len; readBytesNum += bytesNum) {
            try {
                bytesNum = this.in.read(bytes, readBytesNum, len - readBytesNum);
            }
            catch (IOException e) {
                throw new ClientConnectionException(e);
            }
            if (bytesNum >= 0) continue;
            throw new ClientConnectionException();
        }
        return bytes;
    }

    private void write(byte[] bytes, int len) throws ClientConnectionException {
        try {
            this.out.write(bytes, 0, len);
            this.out.flush();
        }
        catch (IOException e) {
            throw new ClientConnectionException(e);
        }
    }

    private static class ClientSslSocketFactory {
        private static TrustManager ignoreErrorsTrustMgr = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }
        };
        private final ClientChannelConfiguration cfg;

        ClientSslSocketFactory(ClientChannelConfiguration cfg) {
            this.cfg = cfg;
        }

        SSLSocket create() throws IOException {
            InetSocketAddress addr = this.cfg.getAddress();
            SSLSocket sock = (SSLSocket)ClientSslSocketFactory.getSslSocketFactory(this.cfg).createSocket(addr.getHostName(), addr.getPort());
            sock.setUseClientMode(true);
            sock.startHandshake();
            return sock;
        }

        private static SSLSocketFactory getSslSocketFactory(ClientChannelConfiguration cfg) {
            TrustManager[] trustManagerArray;
            Factory<SSLContext> sslCtxFactory = cfg.getSslContextFactory();
            if (sslCtxFactory != null) {
                try {
                    return ((SSLContext)sslCtxFactory.create()).getSocketFactory();
                }
                catch (Exception e) {
                    throw new ClientError("SSL Context Factory failed", e);
                }
            }
            BiFunction<String, String, String> or = (val, dflt) -> val == null || val.length() == 0 ? dflt : val;
            String keyStore = or.apply(cfg.getSslClientCertificateKeyStorePath(), System.getProperty("javax.net.ssl.keyStore"));
            String keyStoreType = or.apply(cfg.getSslClientCertificateKeyStoreType(), or.apply(System.getProperty("javax.net.ssl.keyStoreType"), "JKS"));
            String keyStorePwd = or.apply(cfg.getSslClientCertificateKeyStorePassword(), System.getProperty("javax.net.ssl.keyStorePassword"));
            String trustStore = or.apply(cfg.getSslTrustCertificateKeyStorePath(), System.getProperty("javax.net.ssl.trustStore"));
            String trustStoreType = or.apply(cfg.getSslTrustCertificateKeyStoreType(), or.apply(System.getProperty("javax.net.ssl.trustStoreType"), "JKS"));
            String trustStorePwd = or.apply(cfg.getSslTrustCertificateKeyStorePassword(), System.getProperty("javax.net.ssl.trustStorePassword"));
            String algorithm = or.apply(cfg.getSslKeyAlgorithm(), "SunX509");
            String proto = ClientSslSocketFactory.toString(cfg.getSslProtocol());
            if (Stream.of(keyStore, keyStorePwd, keyStoreType, trustStore, trustStorePwd, trustStoreType).allMatch(s -> s == null || s.length() == 0)) {
                try {
                    return SSLContext.getDefault().getSocketFactory();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ClientError("Default SSL context cryptographic algorithm is not available", e);
                }
            }
            KeyManager[] keyManagers = ClientSslSocketFactory.getKeyManagers(algorithm, keyStore, keyStoreType, keyStorePwd);
            if (cfg.isSslTrustAll()) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = ignoreErrorsTrustMgr;
            } else {
                trustManagerArray = ClientSslSocketFactory.getTrustManagers(algorithm, trustStore, trustStoreType, trustStorePwd);
            }
            TrustManager[] trustManagers = trustManagerArray;
            try {
                SSLContext sslCtx = SSLContext.getInstance(proto);
                sslCtx.init(keyManagers, trustManagers, null);
                return sslCtx.getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("SSL context cryptographic algorithm is not available", e);
            }
            catch (KeyManagementException e) {
                throw new ClientError("Failed to create SSL Context", e);
            }
        }

        private static String toString(SslProtocol proto) {
            switch (proto) {
                case TLSv1_1: {
                    return "TLSv1.1";
                }
                case TLSv1_2: {
                    return "TLSv1.2";
                }
            }
            return proto.toString();
        }

        private static KeyManager[] getKeyManagers(String algorithm, String keyStore, String keyStoreType, String keyStorePwd) {
            KeyManagerFactory keyMgrFactory;
            try {
                keyMgrFactory = KeyManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("Key manager cryptographic algorithm is not available", e);
            }
            Predicate<String> empty = s -> s == null || s.length() == 0;
            if (!empty.test(keyStore) && !empty.test(keyStoreType)) {
                char[] pwd = keyStorePwd == null ? new char[]{} : keyStorePwd.toCharArray();
                KeyStore store = ClientSslSocketFactory.loadKeyStore("Client", keyStore, keyStoreType, pwd);
                try {
                    keyMgrFactory.init(store, pwd);
                }
                catch (UnrecoverableKeyException e) {
                    throw new ClientError("Could not recover key store key", e);
                }
                catch (KeyStoreException e) {
                    throw new ClientError(String.format("Client key store provider of type [%s] is not available", keyStoreType), e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ClientError("Client key store integrity check algorithm is not available", e);
                }
            }
            return keyMgrFactory.getKeyManagers();
        }

        private static TrustManager[] getTrustManagers(String algorithm, String trustStore, String trustStoreType, String trustStorePwd) {
            TrustManagerFactory trustMgrFactory;
            try {
                trustMgrFactory = TrustManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("Trust manager cryptographic algorithm is not available", e);
            }
            Predicate<String> empty = s -> s == null || s.length() == 0;
            if (!empty.test(trustStore) && !empty.test(trustStoreType)) {
                char[] pwd = trustStorePwd == null ? new char[]{} : trustStorePwd.toCharArray();
                KeyStore store = ClientSslSocketFactory.loadKeyStore("Trust", trustStore, trustStoreType, pwd);
                try {
                    trustMgrFactory.init(store);
                }
                catch (KeyStoreException e) {
                    throw new ClientError(String.format("Trust key store provider of type [%s] is not available", trustStoreType), e);
                }
            }
            return trustMgrFactory.getTrustManagers();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static KeyStore loadKeyStore(String lb, String path, String type, char[] pwd) {
            KeyStore store;
            try {
                store = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                throw new ClientError(String.format("%s key store provider of type [%s] is not available", lb, type), e);
            }
            try (FileInputStream in = new FileInputStream(new File(path));){
                store.load(in, pwd);
                KeyStore keyStore = store;
                return keyStore;
            }
            catch (FileNotFoundException e) {
                throw new ClientError(String.format("%s key store file [%s] does not exist", lb, path), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError(String.format("%s key store integrity check algorithm is not available", lb), e);
            }
            catch (CertificateException e) {
                throw new ClientError(String.format("Could not load certificate from %s key store", lb), e);
            }
            catch (IOException e) {
                throw new ClientError(String.format("Could not read %s key store", lb), e);
            }
        }
    }
}

