/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Schema;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2PkHashIndex;
import org.apache.ignite.internal.processors.query.h2.database.H2RowFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SystemIndexFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneIndex;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.index.Index;
import org.h2.table.Column;
import org.h2.table.IndexColumn;

public class H2TableDescriptor
implements GridH2SystemIndexFactory {
    private final IgniteH2Indexing idx;
    private final String fullTblName;
    private final GridQueryTypeDescriptor type;
    private final H2Schema schema;
    private final GridCacheContext cctx;
    private GridH2Table tbl;
    private GridLuceneIndex luceneIdx;
    private H2PkHashIndex pkHashIdx;

    public H2TableDescriptor(IgniteH2Indexing idx, H2Schema schema, GridQueryTypeDescriptor type, GridCacheContext cctx) {
        this.idx = idx;
        this.type = type;
        this.schema = schema;
        this.cctx = cctx;
        this.fullTblName = H2Utils.withQuotes(schema.schemaName()) + "." + H2Utils.withQuotes(type.tableName());
    }

    public GridH2Table table() {
        return this.tbl;
    }

    public void table(GridH2Table tbl) {
        this.tbl = tbl;
    }

    public H2Schema schema() {
        return this.schema;
    }

    public String schemaName() {
        return this.schema.schemaName();
    }

    String tableName() {
        return this.type.tableName();
    }

    String fullTableName() {
        return this.fullTblName;
    }

    String typeName() {
        return this.type.name();
    }

    public GridCacheContext cache() {
        return this.cctx;
    }

    GridQueryTypeDescriptor type() {
        return this.type;
    }

    GridLuceneIndex luceneIndex() {
        return this.luceneIdx;
    }

    public String toString() {
        return S.toString(H2TableDescriptor.class, (Object)this);
    }

    H2RowFactory rowFactory(GridH2RowDescriptor rowDesc) {
        if (this.cctx.affinityNode()) {
            return new H2RowFactory(rowDesc, this.cctx);
        }
        return null;
    }

    @Override
    public ArrayList<Index> createSystemIndexes(GridH2Table tbl) {
        GridH2RowDescriptor desc;
        Index hashIdx;
        ArrayList<Index> idxs = new ArrayList<Index>();
        IndexColumn keyCol = tbl.indexColumn(0, 0);
        IndexColumn affCol = tbl.getAffinityKeyColumn();
        if (affCol != null && H2Utils.equals(affCol, keyCol)) {
            affCol = null;
        }
        if ((hashIdx = this.createHashIndex(tbl, "_key_PK_hash", H2Utils.treeIndexColumns(desc = tbl.rowDescriptor(), new ArrayList<IndexColumn>(2), keyCol, affCol))) != null) {
            idxs.add(hashIdx);
        }
        GridH2IndexBase pkIdx = this.idx.createSortedIndex("_key_PK", tbl, true, H2Utils.treeIndexColumns(desc, new ArrayList<IndexColumn>(2), keyCol, affCol), -1);
        idxs.add((Index)pkIdx);
        if (this.type().valueClass() == String.class) {
            try {
                this.luceneIdx = new GridLuceneIndex(this.idx.kernalContext(), tbl.cacheName(), this.type);
            }
            catch (IgniteCheckedException e1) {
                throw new IgniteException((Throwable)e1);
            }
        }
        boolean affIdxFound = false;
        GridQueryIndexDescriptor textIdx = this.type.textIndex();
        if (textIdx != null) {
            try {
                this.luceneIdx = new GridLuceneIndex(this.idx.kernalContext(), tbl.cacheName(), this.type);
            }
            catch (IgniteCheckedException e1) {
                throw new IgniteException((Throwable)e1);
            }
        }
        if (affCol != null) {
            for (GridQueryIndexDescriptor idxDesc : this.type.indexes().values()) {
                if (idxDesc.type() != QueryIndexType.SORTED) continue;
                String firstField = (String)idxDesc.fields().iterator().next();
                Column col = tbl.getColumn(firstField);
                IndexColumn idxCol = tbl.indexColumn(col.getColumnId(), idxDesc.descending(firstField) ? 1 : 0);
                affIdxFound |= H2Utils.equals(idxCol, affCol);
            }
        }
        if (affCol != null && !affIdxFound) {
            idxs.add((Index)this.idx.createSortedIndex("AFFINITY_KEY", tbl, false, H2Utils.treeIndexColumns(desc, new ArrayList<IndexColumn>(2), affCol, keyCol), -1));
        }
        return idxs;
    }

    public Collection<GridH2IndexBase> createUserIndexes() {
        assert (this.tbl != null);
        ArrayList<GridH2IndexBase> res = new ArrayList<GridH2IndexBase>();
        for (GridQueryIndexDescriptor idxDesc : this.type.indexes().values()) {
            GridH2IndexBase idx = this.createUserIndex(idxDesc);
            res.add(idx);
        }
        return res;
    }

    public GridH2IndexBase createUserIndex(GridQueryIndexDescriptor idxDesc) {
        IndexColumn keyCol = this.tbl.indexColumn(0, 0);
        IndexColumn affCol = this.tbl.getAffinityKeyColumn();
        List<IndexColumn> cols = new ArrayList<IndexColumn>(idxDesc.fields().size() + 2);
        for (String field : idxDesc.fields()) {
            Column col = this.tbl.getColumn(field);
            cols.add(this.tbl.indexColumn(col.getColumnId(), idxDesc.descending(field) ? 1 : 0));
        }
        GridH2RowDescriptor desc = this.tbl.rowDescriptor();
        if (idxDesc.type() == QueryIndexType.SORTED) {
            cols = H2Utils.treeIndexColumns(desc, cols, keyCol, affCol);
            return this.idx.createSortedIndex(idxDesc.name(), this.tbl, false, cols, idxDesc.inlineSize());
        }
        if (idxDesc.type() == QueryIndexType.GEOSPATIAL) {
            return H2Utils.createSpatialIndex(this.tbl, idxDesc.name(), cols.toArray(new IndexColumn[cols.size()]));
        }
        throw new IllegalStateException("Index type: " + idxDesc.type());
    }

    private Index createHashIndex(GridH2Table tbl, String idxName, List<IndexColumn> cols) {
        if (this.cctx.affinityNode()) {
            assert (this.pkHashIdx == null) : this.pkHashIdx;
            this.pkHashIdx = new H2PkHashIndex(this.cctx, tbl, idxName, cols);
            return this.pkHashIdx;
        }
        return null;
    }

    void onDrop() {
        this.idx.removeDataTable(this.tbl);
        this.tbl.destroy();
        U.closeQuiet((AutoCloseable)this.luceneIdx);
    }
}

