/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.debug;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.debug.VisorThreadLockInfo;
import org.apache.ignite.internal.visor.debug.VisorThreadMonitorInfo;

public class VisorThreadInfo
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private long id;
    private Thread.State state;
    private VisorThreadLockInfo lock;
    private String lockName;
    private long lockOwnerId;
    private String lockOwnerName;
    private boolean inNative;
    private boolean suspended;
    private long waitedCnt;
    private long waitedTime;
    private long blockedCnt;
    private long blockedTime;
    private List<StackTraceElement> stackTrace;
    private List<VisorThreadLockInfo> locks;
    private List<VisorThreadMonitorInfo> lockedMonitors;

    public VisorThreadInfo() {
    }

    public VisorThreadInfo(ThreadInfo ti) {
        int i;
        assert (ti != null);
        this.name = ti.getThreadName();
        this.id = ti.getThreadId();
        this.state = ti.getThreadState();
        this.lock = ti.getLockInfo() != null ? new VisorThreadLockInfo(ti.getLockInfo()) : null;
        this.lockName = ti.getLockName();
        this.lockOwnerId = ti.getLockOwnerId();
        this.lockOwnerName = ti.getLockOwnerName();
        this.inNative = ti.isInNative();
        this.suspended = ti.isSuspended();
        this.waitedCnt = ti.getWaitedCount();
        this.waitedTime = ti.getWaitedTime();
        this.blockedCnt = ti.getBlockedCount();
        this.blockedTime = ti.getBlockedTime();
        this.stackTrace = Arrays.asList(ti.getStackTrace());
        ArrayList arrayList = this.locks = ti.getLockedSynchronizers() != null ? new ArrayList(ti.getLockedSynchronizers().length) : null;
        if (ti.getLockedSynchronizers() != null) {
            for (i = 0; i < ti.getLockedSynchronizers().length; ++i) {
                this.locks.add(new VisorThreadLockInfo(ti.getLockedSynchronizers()[i]));
            }
        }
        ArrayList arrayList2 = this.lockedMonitors = ti.getLockedMonitors() != null ? new ArrayList(ti.getLockedMonitors().length) : null;
        if (ti.getLockedMonitors() != null) {
            for (i = 0; i < ti.getLockedMonitors().length; ++i) {
                this.lockedMonitors.add(new VisorThreadMonitorInfo(ti.getLockedMonitors()[i]));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public Thread.State getState() {
        return this.state;
    }

    public VisorThreadLockInfo getLock() {
        return this.lock;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public boolean isInNative() {
        return this.inNative;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public long getWaitedCount() {
        return this.waitedCnt;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public long getBlockedCount() {
        return this.blockedCnt;
    }

    public long getBlockedTime() {
        return this.blockedTime;
    }

    public List<StackTraceElement> getStackTrace() {
        return this.stackTrace;
    }

    public List<VisorThreadLockInfo> getLocks() {
        return this.locks;
    }

    public List<VisorThreadMonitorInfo> getLockedMonitors() {
        return this.lockedMonitors;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        out.writeLong(this.id);
        U.writeString(out, this.state.toString());
        out.writeObject(this.lock);
        U.writeString(out, this.lockName);
        out.writeLong(this.lockOwnerId);
        U.writeString(out, this.lockOwnerName);
        out.writeBoolean(this.inNative);
        out.writeBoolean(this.suspended);
        out.writeLong(this.waitedCnt);
        out.writeLong(this.waitedTime);
        out.writeLong(this.blockedCnt);
        out.writeLong(this.blockedTime);
        U.writeCollection(out, this.stackTrace);
        U.writeCollection(out, this.locks);
        U.writeCollection(out, this.lockedMonitors);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.id = in.readLong();
        String statePresentation = U.readString(in);
        if (statePresentation != null) {
            this.state = Enum.valueOf(Thread.State.class, statePresentation);
        }
        this.lock = (VisorThreadLockInfo)in.readObject();
        this.lockName = U.readString(in);
        this.lockOwnerId = in.readLong();
        this.lockOwnerName = U.readString(in);
        this.inNative = in.readBoolean();
        this.suspended = in.readBoolean();
        this.waitedCnt = in.readLong();
        this.waitedTime = in.readLong();
        this.blockedCnt = in.readLong();
        this.blockedTime = in.readLong();
        this.stackTrace = U.readList(in);
        this.locks = U.readList(in);
        this.lockedMonitors = U.readList(in);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append('\"').append(this.name).append('\"').append(" Id=").append(this.id).append(' ').append((Object)this.state);
        if (this.lockName != null) {
            sb.append(" on ").append(this.lockName);
        }
        if (this.lockOwnerName != null) {
            sb.append(" owned by \"").append(this.lockOwnerName).append("\" Id=").append(this.lockOwnerId);
        }
        if (this.suspended) {
            sb.append(" (suspended)");
        }
        if (this.inNative) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (int i = 0; i < this.stackTrace.size(); ++i) {
            StackTraceElement ste = this.stackTrace.get(i);
            sb.append("\tat ").append(ste).append('\n');
            if (i == 0 && this.lock != null) {
                switch (this.state) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(this.lock).append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(this.lock).append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(this.lock).append('\n');
                        break;
                    }
                }
            }
            for (VisorThreadMonitorInfo mi : this.lockedMonitors) {
                if (mi.getStackDepth() != i) continue;
                sb.append("\t-  locked ").append(mi).append('\n');
            }
        }
        if (!F.isEmpty(this.locks)) {
            sb.append("\n\tNumber of locked synchronizers = ").append(this.locks.size()).append('\n');
            for (VisorThreadLockInfo li : this.locks) {
                sb.append("\t- ").append(li).append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

