/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc.shmem;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemorySpace;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IpcSharedMemoryOutputStream
extends OutputStream {
    private final IpcSharedMemorySpace out;

    public IpcSharedMemoryOutputStream(IpcSharedMemorySpace out) {
        assert (out != null);
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.out.write(b, off, len, 0L);
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void forceClose() {
        this.out.forceClose();
    }

    public String toString() {
        return S.toString(IpcSharedMemoryOutputStream.class, this);
    }
}

