/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.util.GridIntIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridIntList
implements Message,
Externalizable {
    private static final long serialVersionUID = 0L;
    private int[] arr;
    private int idx;

    public GridIntList() {
    }

    public GridIntList(int size) {
        this.arr = new int[size];
    }

    public GridIntList(int[] arr) {
        this.arr = arr;
        this.idx = arr.length;
    }

    public static GridIntList asList(int ... vals) {
        if (F.isEmpty(vals)) {
            return new GridIntList();
        }
        return new GridIntList(vals);
    }

    private GridIntList(int[] arr, int size) {
        this.arr = arr;
        this.idx = size;
    }

    public GridIntList copy() {
        if (this.idx == 0) {
            return new GridIntList();
        }
        return new GridIntList(Arrays.copyOf(this.arr, this.idx));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GridIntList)) {
            return false;
        }
        GridIntList that = (GridIntList)o;
        if (this.idx != that.idx) {
            return false;
        }
        if (this.idx == 0 || this.arr == that.arr) {
            return true;
        }
        for (int i = 0; i < this.idx; ++i) {
            if (this.arr[i] == that.arr[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int res = 1;
        for (int i = 0; i < this.idx; ++i) {
            int element = this.arr[i];
            res = 31 * res + element;
        }
        return res;
    }

    public void addAll(GridIntList l) {
        int len;
        assert (l != null);
        if (l.isEmpty()) {
            return;
        }
        if (this.arr == null) {
            this.arr = new int[4];
        }
        for (len = this.arr.length; len < this.idx + l.size(); len <<= 1) {
        }
        this.arr = Arrays.copyOf(this.arr, len);
        System.arraycopy(l.arr, 0, this.arr, this.idx, l.size());
        this.idx += l.size();
    }

    public void add(int x) {
        if (this.arr == null) {
            this.arr = new int[4];
        } else if (this.arr.length == this.idx) {
            this.arr = Arrays.copyOf(this.arr, this.arr.length << 1);
        }
        this.arr[this.idx++] = x;
    }

    public void clear() {
        this.idx = 0;
    }

    public int last() {
        return this.arr[this.idx - 1];
    }

    public int remove() throws NoSuchElementException {
        if (this.idx == 0) {
            throw new NoSuchElementException();
        }
        return this.arr[--this.idx];
    }

    public GridIntList copyWithout(GridIntList l) {
        assert (l != null);
        if (this.idx == 0) {
            return new GridIntList();
        }
        if (l.idx == 0) {
            return new GridIntList(Arrays.copyOf(this.arr, this.idx));
        }
        int[] newArr = Arrays.copyOf(this.arr, this.idx);
        int newIdx = this.idx;
        for (int i = 0; i < l.size(); ++i) {
            int rmVal = l.get(i);
            for (int j = 0; j < newIdx; ++j) {
                if (newArr[j] != rmVal) continue;
                while (newIdx > 0 && newArr[newIdx - 1] == rmVal) {
                    --newIdx;
                }
                if (newIdx <= 0) continue;
                newArr[j] = newArr[newIdx - 1];
                --newIdx;
            }
        }
        return new GridIntList(newArr, newIdx);
    }

    public int get(int i) {
        assert (i < this.idx);
        return this.arr[i];
    }

    public int size() {
        return this.idx;
    }

    public boolean isEmpty() {
        return this.idx == 0;
    }

    public boolean contains(int l) {
        for (int i = 0; i < this.idx; ++i) {
            if (this.arr[i] != l) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(GridIntList l) {
        for (int i = 0; i < l.size(); ++i) {
            if (this.contains(l.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean distinct() {
        for (int i = 0; i < this.idx; ++i) {
            for (int j = i + 1; j < this.idx; ++j) {
                if (this.arr[i] != this.arr[j]) continue;
                return false;
            }
        }
        return true;
    }

    public void truncate(int size, boolean last) {
        assert (size >= 0 && size <= this.idx);
        if (size == this.idx) {
            return;
        }
        if (!last && this.idx != 0 && size != 0) {
            System.arraycopy(this.arr, this.idx - size, this.arr, 0, size);
        }
        this.idx = size;
    }

    public int removeIndex(int i) {
        assert (i < this.idx) : i;
        int res = this.arr[i];
        if (i == this.idx - 1) {
            this.idx = i;
        } else {
            System.arraycopy(this.arr, i + 1, this.arr, i, this.idx - i - 1);
            --this.idx;
        }
        return res;
    }

    public int removeValue(int startIdx, int val) {
        assert (startIdx >= 0);
        for (int i = startIdx; i < this.idx; ++i) {
            if (this.arr[i] != val) continue;
            this.removeIndex(i);
            return i;
        }
        return -1;
    }

    public int replaceValue(int startIdx, int oldVal, int newVal) {
        for (int i = startIdx; i < this.idx; ++i) {
            if (this.arr[i] != oldVal) continue;
            this.arr[i] = newVal;
            return i;
        }
        return -1;
    }

    public int[] array() {
        int[] res = new int[this.idx];
        System.arraycopy(this.arr, 0, res, 0, this.idx);
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.idx);
        for (int i = 0; i < this.idx; ++i) {
            out.writeInt(this.arr[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.idx = in.readInt();
        this.arr = new int[this.idx];
        for (int i = 0; i < this.idx; ++i) {
            this.arr[i] = in.readInt();
        }
    }

    public String toString() {
        SB b = new SB("[");
        for (int i = 0; i < this.idx; ++i) {
            if (i != 0) {
                b.a(',');
            }
            b.a(this.arr[i]);
        }
        b.a(']');
        return b.toString();
    }

    @Nullable
    public static GridIntList readFrom(DataInput in) throws IOException {
        int idx = in.readInt();
        if (idx == -1) {
            return null;
        }
        int[] arr = new int[idx];
        for (int i = 0; i < idx; ++i) {
            arr[i] = in.readInt();
        }
        return new GridIntList(arr);
    }

    public static void writeTo(DataOutput out, @Nullable GridIntList list) throws IOException {
        out.writeInt(list != null ? list.idx : -1);
        if (list != null) {
            for (int i = 0; i < list.idx; ++i) {
                out.writeInt(list.arr[i]);
            }
        }
    }

    public static GridIntList addAll(@Nullable GridIntList to, GridIntList from) {
        if (to == null) {
            GridIntList res = new GridIntList(from.size());
            res.addAll(from);
            return res;
        }
        to.addAll(from);
        return to;
    }

    public GridIntList sort() {
        if (this.idx > 1) {
            Arrays.sort(this.arr, 0, this.idx);
        }
        return this;
    }

    public void pop(int cnt) {
        assert (cnt >= 0) : cnt;
        this.idx = this.idx < cnt ? 0 : (this.idx -= cnt);
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeIntArray("arr", this.arr)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("idx", this.idx)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.arr = reader.readIntArray("arr");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.idx = reader.readInt("idx");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridIntList.class);
    }

    @Override
    public short directType() {
        return -52;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public GridIntIterator iterator() {
        return new GridIntIterator(){
            int c = 0;

            @Override
            public boolean hasNext() {
                return this.c < GridIntList.this.idx;
            }

            @Override
            public int next() {
                return GridIntList.this.arr[this.c++];
            }
        };
    }
}

