/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;

public class ClientRequest
implements ClientListenerRequest {
    private final long reqId;

    public ClientRequest(BinaryRawReader reader) {
        this.reqId = reader.readLong();
    }

    public ClientRequest(long reqId) {
        this.reqId = reqId;
    }

    @Override
    public long requestId() {
        return this.reqId;
    }

    public ClientResponse process(ClientConnectionContext ctx) {
        return new ClientResponse(this.reqId);
    }

    protected static void runWithSecurityExceptionHandler(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (SecurityException ex) {
            throw new IgniteClientException(1012, "Client is not authorized to perform this operation", ex);
        }
    }

    protected void authorize(ClientConnectionContext ctx, SecurityPermission perm) {
        SecurityContext secCtx = ctx.securityContext();
        if (secCtx != null) {
            ClientRequest.runWithSecurityExceptionHandler(() -> ctx.kernalContext().security().authorize(null, perm, secCtx));
        }
    }
}

