/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.processors.cache.persistence.AllocatedPageTracker;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreV2;

public class FileVersionCheckingFactory
implements FilePageStoreFactory {
    public static final String LATEST_VERSION_OVERRIDE_PROPERTY = "file.page.store.latest.version.override";
    public static final int LATEST_VERSION = 2;
    private final FileIOFactory fileIOFactory;
    private FileIOFactory fileIOFactoryStoreV1;
    private final DataStorageConfiguration memCfg;

    public FileVersionCheckingFactory(FileIOFactory fileIOFactory, FileIOFactory fileIOFactoryStoreV1, DataStorageConfiguration memCfg) {
        this.fileIOFactory = fileIOFactory;
        this.fileIOFactoryStoreV1 = fileIOFactoryStoreV1;
        this.memCfg = memCfg;
    }

    public FileVersionCheckingFactory(FileIOFactory fileIOFactory, DataStorageConfiguration memCfg) {
        this(fileIOFactory, fileIOFactory, memCfg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FilePageStore createPageStore(byte type, File file, AllocatedPageTracker allocatedTracker) throws IgniteCheckedException {
        if (!file.exists()) {
            return this.createPageStore(type, file, this.latestVersion(), allocatedTracker);
        }
        try (FileIO fileIO = this.fileIOFactoryStoreV1.create(file);){
            int minHdr = 17;
            if (fileIO.size() < (long)minHdr) {
                FilePageStore filePageStore = this.createPageStore(type, file, this.latestVersion(), allocatedTracker);
                return filePageStore;
            }
            ByteBuffer hdr = ByteBuffer.allocate(minHdr).order(ByteOrder.LITTLE_ENDIAN);
            while (hdr.remaining() > 0) {
                fileIO.read(hdr);
            }
            hdr.rewind();
            hdr.getLong();
            int ver = hdr.getInt();
            FilePageStore filePageStore = this.createPageStore(type, file, ver, allocatedTracker);
            return filePageStore;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Error while creating file page store [file=" + file + "]:", e);
        }
    }

    public int latestVersion() {
        int latestVer = 2;
        try {
            latestVer = Integer.parseInt(System.getProperty(LATEST_VERSION_OVERRIDE_PROPERTY));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return latestVer;
    }

    public FilePageStore createPageStore(byte type, File file, int ver, AllocatedPageTracker allocatedTracker) {
        switch (ver) {
            case 1: {
                return new FilePageStore(type, file, this.fileIOFactoryStoreV1, this.memCfg, allocatedTracker);
            }
            case 2: {
                return new FilePageStoreV2(type, file, this.fileIOFactory, this.memCfg, allocatedTracker);
            }
        }
        throw new IllegalArgumentException("Unknown version of file page store: " + ver + " for file [" + file.getAbsolutePath() + "]");
    }
}

