/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.bulkload.pipeline;

import java.util.regex.Pattern;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.bulkload.pipeline.PipelineBlock;

public class CsvLineProcessorBlock
extends PipelineBlock<String, String[]> {
    private final Pattern fldDelim;
    private final String quoteChars;

    public CsvLineProcessorBlock(Pattern fldDelim, String quoteChars) {
        this.fldDelim = fldDelim;
        this.quoteChars = quoteChars;
    }

    @Override
    public void accept(String input, boolean isLastPortion) throws IgniteCheckedException {
        String[] fields = this.fldDelim.split(input);
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.trim(fields[i]);
        }
        this.nextBlock.accept(fields, isLastPortion);
    }

    private String trim(String str) {
        if (str.isEmpty()) {
            return null;
        }
        int startPos = this.quoteChars.indexOf(str.charAt(0)) != -1 ? 1 : 0;
        int endPos = this.quoteChars.indexOf(str.charAt(str.length() - 1)) != -1 ? str.length() - 1 : str.length();
        return str.substring(startPos, endPos);
    }
}

