/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.jcodings.CodeRange;
import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.joni.BitSet;
import org.joni.CodeRangeBuffer;
import org.joni.ScanEnvironment;
import org.joni.ast.Node;
import org.joni.constants.CCSTATE;
import org.joni.constants.CCVALTYPE;
import org.joni.exception.InternalException;
import org.joni.exception.SyntaxException;
import org.joni.exception.ValueException;

public final class CClassNode
extends Node {
    private static final int FLAG_NCCLASS_NOT = 1;
    private static final int FLAG_NCCLASS_SHARE = 2;
    int flags;
    public final BitSet bs = new BitSet();
    public CodeRangeBuffer mbuf;
    private int ctype;
    private Encoding enc;

    public CClassNode() {
    }

    public CClassNode(int ctype, Encoding enc, boolean not, int sbOut, int[] ranges) {
        this(not, sbOut, ranges);
        this.ctype = ctype;
        this.enc = enc;
    }

    public void clear() {
        this.bs.clear();
        this.flags = 0;
        this.mbuf = null;
    }

    public CClassNode(boolean not, int sbOut, int[] ranges) {
        if (not) {
            this.setNot();
        }
        if (sbOut > 0 && ranges != null) {
            int n = ranges[0];
            for (int i = 0; i < n; ++i) {
                int from = ranges[i * 2 + 1];
                int to = ranges[i * 2 + 2];
                for (int j = from; j <= to; ++j) {
                    if (j >= sbOut) {
                        this.setupBuffer(ranges);
                        return;
                    }
                    this.bs.set(j);
                }
            }
        }
        this.setupBuffer(ranges);
    }

    public int getType() {
        return 1;
    }

    public String getName() {
        return "Character Class";
    }

    public boolean equals(Object other) {
        if (!(other instanceof CClassNode)) {
            return false;
        }
        CClassNode cc = (CClassNode)other;
        return this.ctype == cc.ctype && this.isNot() == cc.isNot() && this.enc == cc.enc;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString(int level) {
        StringBuilder value = new StringBuilder();
        value.append("\n  flags: " + this.flagsToString());
        value.append("\n  bs: " + CClassNode.pad(this.bs, level + 1));
        value.append("\n  mbuf: " + CClassNode.pad(this.mbuf, level + 1));
        return value.toString();
    }

    public String flagsToString() {
        StringBuilder flags = new StringBuilder();
        if (this.isNot()) {
            flags.append("NOT ");
        }
        if (this.isShare()) {
            flags.append("SHARE ");
        }
        return flags.toString();
    }

    private void setupBuffer(int[] ranges) {
        if (ranges != null) {
            if (ranges[0] == 0) {
                return;
            }
            this.mbuf = new CodeRangeBuffer(ranges);
        }
    }

    public boolean isEmpty() {
        return this.mbuf == null && this.bs.isEmpty();
    }

    public void addCodeRangeToBuf(int from, int to) {
        this.mbuf = CodeRangeBuffer.addCodeRangeToBuff(this.mbuf, from, to);
    }

    public void addCodeRange(ScanEnvironment env, int from, int to) {
        this.mbuf = CodeRangeBuffer.addCodeRange(this.mbuf, env, from, to);
    }

    public void addAllMultiByteRange(Encoding enc) {
        this.mbuf = CodeRangeBuffer.addAllMultiByteRange(enc, this.mbuf);
    }

    public void clearNotFlag(Encoding enc) {
        if (this.isNot()) {
            this.bs.invert();
            if (!enc.isSingleByte()) {
                this.mbuf = CodeRangeBuffer.notCodeRangeBuff(enc, this.mbuf);
            }
            this.clearNot();
        }
    }

    public void and(CClassNode other, Encoding enc) {
        boolean not1 = this.isNot();
        BitSet bsr1 = this.bs;
        CodeRangeBuffer buf1 = this.mbuf;
        boolean not2 = other.isNot();
        BitSet bsr2 = other.bs;
        CodeRangeBuffer buf2 = other.mbuf;
        if (not1) {
            BitSet bs1 = new BitSet();
            bsr1.invertTo(bs1);
            bsr1 = bs1;
        }
        if (not2) {
            BitSet bs2 = new BitSet();
            bsr2.invertTo(bs2);
            bsr2 = bs2;
        }
        bsr1.and(bsr2);
        if (bsr1 != this.bs) {
            this.bs.copy(bsr1);
            bsr1 = this.bs;
        }
        if (not1) {
            this.bs.invert();
        }
        CodeRangeBuffer pbuf = null;
        if (!enc.isSingleByte()) {
            if (not1 && not2) {
                pbuf = CodeRangeBuffer.orCodeRangeBuff(enc, buf1, false, buf2, false);
            } else {
                pbuf = CodeRangeBuffer.andCodeRangeBuff(buf1, not1, buf2, not2);
                if (not1) {
                    pbuf = CodeRangeBuffer.notCodeRangeBuff(enc, pbuf);
                }
            }
            this.mbuf = pbuf;
        }
    }

    public void or(CClassNode other, Encoding enc) {
        boolean not1 = this.isNot();
        BitSet bsr1 = this.bs;
        CodeRangeBuffer buf1 = this.mbuf;
        boolean not2 = other.isNot();
        BitSet bsr2 = other.bs;
        CodeRangeBuffer buf2 = other.mbuf;
        if (not1) {
            BitSet bs1 = new BitSet();
            bsr1.invertTo(bs1);
            bsr1 = bs1;
        }
        if (not2) {
            BitSet bs2 = new BitSet();
            bsr2.invertTo(bs2);
            bsr2 = bs2;
        }
        bsr1.or(bsr2);
        if (bsr1 != this.bs) {
            this.bs.copy(bsr1);
            bsr1 = this.bs;
        }
        if (not1) {
            this.bs.invert();
        }
        if (!enc.isSingleByte()) {
            CodeRangeBuffer pbuf = null;
            if (not1 && not2) {
                pbuf = CodeRangeBuffer.andCodeRangeBuff(buf1, false, buf2, false);
            } else {
                pbuf = CodeRangeBuffer.orCodeRangeBuff(enc, buf1, not1, buf2, not2);
                if (not1) {
                    pbuf = CodeRangeBuffer.notCodeRangeBuff(enc, pbuf);
                }
            }
            this.mbuf = pbuf;
        }
    }

    public void addCTypeByRange(int ctype, boolean not, Encoding enc, int sbOut, int[] mbr) {
        int n = mbr[0];
        if (!not) {
            int i;
            for (i = 0; i < n; ++i) {
                for (int j = mbr[i * 2 + 1]; j <= mbr[i * 2 + 2]; ++j) {
                    if (j >= sbOut) {
                        if (j >= mbr[i * 2 + 1]) {
                            this.addCodeRangeToBuf(j, mbr[i * 2 + 2]);
                            ++i;
                        }
                        while (i < n) {
                            this.addCodeRangeToBuf(mbr[2 * i + 1], mbr[2 * i + 2]);
                            ++i;
                        }
                        return;
                    }
                    this.bs.set(j);
                }
            }
            for (i = 0; i < n; ++i) {
                this.addCodeRangeToBuf(mbr[2 * i + 1], mbr[2 * i + 2]);
            }
        } else {
            int i;
            int prev = 0;
            for (i = 0; i < n; ++i) {
                for (int j = prev; j < mbr[2 * i + 1]; ++j) {
                    if (j >= sbOut) {
                        prev = sbOut;
                        for (i = 0; i < n; ++i) {
                            if (prev < mbr[2 * i + 1]) {
                                this.addCodeRangeToBuf(prev, mbr[i * 2 + 1] - 1);
                            }
                            prev = mbr[i * 2 + 2] + 1;
                        }
                        if (prev < Integer.MAX_VALUE) {
                            this.addCodeRangeToBuf(prev, Integer.MAX_VALUE);
                        }
                        return;
                    }
                    this.bs.set(j);
                }
                prev = mbr[2 * i + 2] + 1;
            }
            for (int j = prev; j < sbOut; ++j) {
                this.bs.set(j);
            }
            prev = sbOut;
            for (i = 0; i < n; ++i) {
                if (prev < mbr[2 * i + 1]) {
                    this.addCodeRangeToBuf(prev, mbr[i * 2 + 1] - 1);
                }
                prev = mbr[i * 2 + 2] + 1;
            }
            if (prev < Integer.MAX_VALUE) {
                this.addCodeRangeToBuf(prev, Integer.MAX_VALUE);
            }
        }
    }

    public void addCType(int ctype, boolean not, ScanEnvironment env, IntHolder sbOut) {
        Encoding enc = env.enc;
        switch (ctype) {
            case 265: {
                if (!not && env.syntax.op2OptionECMAScript()) {
                    this.addCodeRange(env, 8232, 8233);
                }
            }
            case 260: 
            case 268: {
                ctype ^= 0x100;
                if (not) {
                    for (int c = 0; c < 256; ++c) {
                        if (ASCIIEncoding.INSTANCE.isCodeCType(c, ctype)) continue;
                        this.bs.set(c);
                    }
                    this.addAllMultiByteRange(enc);
                } else {
                    for (int c = 0; c < 256; ++c) {
                        if (!ASCIIEncoding.INSTANCE.isCodeCType(c, ctype)) continue;
                        this.bs.set(c);
                    }
                }
                return;
            }
        }
        int[] ranges = enc.ctypeCodeRange(ctype, sbOut);
        if (ranges != null) {
            this.addCTypeByRange(ctype, not, enc, sbOut.value, ranges);
            return;
        }
        switch (ctype) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                if (not) {
                    for (int c = 0; c < 256; ++c) {
                        if (enc.isCodeCType(c, ctype)) continue;
                        this.bs.set(c);
                    }
                    this.addAllMultiByteRange(enc);
                    break;
                }
                for (int c = 0; c < 256; ++c) {
                    if (!enc.isCodeCType(c, ctype)) continue;
                    this.bs.set(c);
                }
                break;
            }
            case 5: 
            case 7: {
                if (not) {
                    for (int c = 0; c < 256; ++c) {
                        if (enc.isCodeCType(c, ctype)) continue;
                        this.bs.set(c);
                    }
                    break;
                }
                for (int c = 0; c < 256; ++c) {
                    if (!enc.isCodeCType(c, ctype)) continue;
                    this.bs.set(c);
                }
                this.addAllMultiByteRange(enc);
                break;
            }
            case 12: {
                if (!not) {
                    for (int c = 0; c < 256; ++c) {
                        if (!enc.isSbWord(c)) continue;
                        this.bs.set(c);
                    }
                    this.addAllMultiByteRange(enc);
                    break;
                }
                for (int c = 0; c < 256; ++c) {
                    try {
                        if (enc.codeToMbcLength(c) <= 0 || enc.isWord(c)) continue;
                        this.bs.set(c);
                        continue;
                    }
                    catch (EncodingException ve) {
                        // empty catch block
                    }
                }
                break;
            }
            default: {
                throw new InternalException("internal parser error (bug)");
            }
        }
    }

    public void nextStateClass(CCStateArg arg, ScanEnvironment env) {
        if (arg.state == CCSTATE.RANGE) {
            throw new SyntaxException("char-class value at end of range");
        }
        if (arg.state == CCSTATE.VALUE && arg.type != CCVALTYPE.CLASS) {
            if (arg.type == CCVALTYPE.SB) {
                this.bs.set(arg.vs);
            } else if (arg.type == CCVALTYPE.CODE_POINT) {
                this.addCodeRange(env, arg.vs, arg.vs);
            }
        }
        arg.state = CCSTATE.VALUE;
        arg.type = CCVALTYPE.CLASS;
    }

    public void nextStateValue(CCStateArg arg, ScanEnvironment env) {
        switch (arg.state) {
            case VALUE: {
                if (arg.type == CCVALTYPE.SB) {
                    if (arg.vs > 255) {
                        throw new ValueException("invalid code point value");
                    }
                    this.bs.set(arg.vs);
                    break;
                }
                if (arg.type != CCVALTYPE.CODE_POINT) break;
                this.addCodeRange(env, arg.vs, arg.vs);
                break;
            }
            case RANGE: {
                if (arg.inType == arg.type) {
                    if (arg.inType == CCVALTYPE.SB) {
                        if (arg.vs > 255 || arg.v > 255) {
                            throw new ValueException("invalid code point value");
                        }
                        if (arg.vs > arg.v) {
                            if (env.syntax.allowEmptyRangeInCC()) {
                                arg.state = CCSTATE.COMPLETE;
                                break;
                            }
                            throw new ValueException("empty range in char class");
                        }
                        this.bs.setRange(arg.vs, arg.v);
                    } else {
                        this.addCodeRange(env, arg.vs, arg.v);
                    }
                } else {
                    if (arg.vs > arg.v) {
                        if (env.syntax.allowEmptyRangeInCC()) {
                            arg.state = CCSTATE.COMPLETE;
                            break;
                        }
                        throw new ValueException("empty range in char class");
                    }
                    this.bs.setRange(arg.vs, arg.v < 255 ? arg.v : 255);
                    this.addCodeRange(env, arg.vs, arg.v);
                }
                arg.state = CCSTATE.COMPLETE;
                break;
            }
            case COMPLETE: 
            case START: {
                arg.state = CCSTATE.VALUE;
                break;
            }
        }
        arg.vsIsRaw = arg.vIsRaw;
        arg.vs = arg.v;
        arg.type = arg.inType;
    }

    public boolean isCodeInCCLength(int encLength, int code) {
        boolean found = encLength > 1 || code >= 256 ? (this.mbuf == null ? false : CodeRange.isInCodeRange((int[])this.mbuf.getCodeRange(), (int)code)) : this.bs.at(code);
        if (this.isNot()) {
            return !found;
        }
        return found;
    }

    public boolean isCodeInCC(Encoding enc, int code) {
        int len = enc.minLength() > 1 ? 2 : enc.codeToMbcLength(code);
        return this.isCodeInCCLength(len, code);
    }

    public void setNot() {
        this.flags |= 1;
    }

    public void clearNot() {
        this.flags &= 0xFFFFFFFE;
    }

    public boolean isNot() {
        return (this.flags & 1) != 0;
    }

    public void setShare() {
        this.flags |= 2;
    }

    public void clearShare() {
        this.flags &= 0xFFFFFFFD;
    }

    public boolean isShare() {
        return (this.flags & 2) != 0;
    }

    public static final class CCStateArg {
        public int v;
        public int vs;
        public boolean vsIsRaw;
        public boolean vIsRaw;
        public CCVALTYPE inType;
        public CCVALTYPE type;
        public CCSTATE state;
    }
}

