/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.igfs;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.jetbrains.annotations.Nullable;

public class VisorIgfsEndpoint
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String igfsName;
    private String gridName;
    private String hostName;
    private int port;

    public VisorIgfsEndpoint() {
    }

    public VisorIgfsEndpoint(@Nullable String igfsName, String gridName, @Nullable String hostName, int port) {
        this.igfsName = igfsName;
        this.gridName = gridName;
        this.hostName = hostName;
        this.port = port;
    }

    @Nullable
    public String getIgfsName() {
        return this.igfsName;
    }

    public String getGridName() {
        return this.gridName;
    }

    @Nullable
    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthority() {
        String addr = this.hostName + ":" + this.port;
        if (this.igfsName == null && this.gridName == null) {
            return addr;
        }
        if (this.igfsName == null) {
            return this.gridName + "@" + addr;
        }
        if (this.gridName == null) {
            return this.igfsName + "@" + addr;
        }
        return this.igfsName + ":" + this.gridName + "@" + addr;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.igfsName);
        U.writeString(out, this.gridName);
        U.writeString(out, this.hostName);
        out.writeInt(this.port);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.igfsName = U.readString(in);
        this.gridName = U.readString(in);
        this.hostName = U.readString(in);
        this.port = in.readInt();
    }

    public String toString() {
        return S.toString(VisorIgfsEndpoint.class, this);
    }
}

