/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.snaptree;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.internal.util.snaptree.Epoch;

abstract class EpochNode
extends AtomicLong
implements Epoch.Ticket {
    private static final int TRIES_BEFORE_SUBTREE = 2;
    private static final int CLOSER_HEAD_START = 1000;
    private static final int MAX_LEVELS = 2 + EpochNode.log8(Runtime.getRuntime().availableProcessors());
    private static final int LOG_BF = 3;
    private static final int BF = 8;
    private static final int BF_MASK = 7;
    private static final int DATA_SUM_SHIFT = 32;
    private static final int CHILD_CLOSED_SHIFT = 24;
    private static long ALL_CHILDREN_CLOSED = 0xFF000000L;
    private static final int CHILD_PRESENT_SHIFT = 16;
    private static final long ANY_CHILD_PRESENT = 0xFF0000L;
    private static final long MARK = 32768L;
    private static final long ENTRY_COUNT_MASK = 32767L;
    private static final long CLOSED_MASK = 0x8000L | ALL_CHILDREN_CLOSED | 0x7FFFL;
    private static final long CLOSED_VALUE = 0x8000L | ALL_CHILDREN_CLOSED;
    private static final long ENTRY_FAST_PATH_MASK = 0xFFC000L;
    private static final AtomicReferenceFieldUpdater[] childrenUpdaters = new AtomicReferenceFieldUpdater[]{AtomicReferenceFieldUpdater.newUpdater(EpochNode.class, EpochNode.class, "_child0"), AtomicReferenceFieldUpdater.newUpdater(EpochNode.class, EpochNode.class, "_child1"), AtomicReferenceFieldUpdater.newUpdater(EpochNode.class, EpochNode.class, "_child2"), AtomicReferenceFieldUpdater.newUpdater(EpochNode.class, EpochNode.class, "_child3"), AtomicReferenceFieldUpdater.newUpdater(EpochNode.class, EpochNode.class, "_child4"), AtomicReferenceFieldUpdater.newUpdater(EpochNode.class, EpochNode.class, "_child5"), AtomicReferenceFieldUpdater.newUpdater(EpochNode.class, EpochNode.class, "_child6"), AtomicReferenceFieldUpdater.newUpdater(EpochNode.class, EpochNode.class, "_child7")};
    private final EpochNode _parent;
    private final int _whichInParent;
    private volatile EpochNode _child0;
    private volatile EpochNode _child1;
    private volatile EpochNode _child2;
    private volatile EpochNode _child3;
    private volatile EpochNode _child4;
    private volatile EpochNode _child5;
    private volatile EpochNode _child6;
    private volatile EpochNode _child7;

    private static int log8(int value) {
        return (31 - Integer.numberOfLeadingZeros(value)) / 3;
    }

    private static int dataSum(long state) {
        return (int)(state >> 32);
    }

    private static long withDataDelta(long state, int delta) {
        return state + ((long)delta << 32);
    }

    private static long childClosedBit(int which) {
        return 1L << 24 + which;
    }

    private static boolean isChildClosed(long state, int which) {
        return (state & EpochNode.childClosedBit(which)) != 0L;
    }

    private static long withChildClosed(long state, int which, long childState) {
        assert (!EpochNode.isChildClosed(state, which));
        return EpochNode.withDataDelta(state | EpochNode.childClosedBit(which), EpochNode.dataSum(childState));
    }

    private static boolean isAllChildrenClosed(long state) {
        return (state & ALL_CHILDREN_CLOSED) == ALL_CHILDREN_CLOSED;
    }

    private static long childPresentBit(int which) {
        return 1L << 16 + which;
    }

    private static boolean isChildPresent(long state, int which) {
        return (state & EpochNode.childPresentBit(which)) != 0L;
    }

    private static long withChildPresent(long state, int which) {
        return state | EpochNode.childPresentBit(which);
    }

    private static boolean isAnyChildPresent(long state) {
        return (state & 0xFF0000L) != 0L;
    }

    private static boolean isMarked(long state) {
        return (state & 0x8000L) != 0L;
    }

    private static long withMarked(long state) {
        int missingChildren = ~((int)state) >> 16 & 0xFF;
        return state | 0x8000L | (long)missingChildren << 24;
    }

    private static int entryCount(long state) {
        return (int)(state & 0x7FFFL);
    }

    private static long withArrive(long state) {
        return state + 1L;
    }

    private static long withLeave(long state, int dataDelta) {
        return EpochNode.withDataDelta(state - 1L, dataDelta);
    }

    private static boolean mayArrive(long state) {
        return (long)EpochNode.entryCount(state) != 32767L;
    }

    private static boolean mayLeave(long state) {
        return EpochNode.entryCount(state) != 0;
    }

    private static boolean isClosed(long state) {
        return (state & CLOSED_MASK) == CLOSED_VALUE;
    }

    private static boolean isEntryFastPath(long state) {
        return (state & 0xFFC000L) == 0L;
    }

    EpochNode() {
        this._parent = null;
        this._whichInParent = 0;
    }

    private EpochNode(EpochNode parent, int whichInParent) {
        this._parent = parent;
        this._whichInParent = whichInParent;
    }

    protected abstract void onClosed(int var1);

    private EpochNode getChildFromField(int which) {
        switch (which) {
            case 0: {
                return this._child0;
            }
            case 1: {
                return this._child1;
            }
            case 2: {
                return this._child2;
            }
            case 3: {
                return this._child3;
            }
            case 4: {
                return this._child4;
            }
            case 5: {
                return this._child5;
            }
            case 6: {
                return this._child6;
            }
            case 7: {
                return this._child7;
            }
        }
        return null;
    }

    private EpochNode getChild(long state, int which) {
        if (!EpochNode.isChildPresent(state, which)) {
            return null;
        }
        EpochNode existing = this.getChildFromField(which);
        return existing != null ? existing : this.constructPresentChild(which);
    }

    private EpochNode constructPresentChild(int which) {
        Child n = new Child(this, which);
        return childrenUpdaters[which].compareAndSet(this, null, n) ? n : this.getChildFromField(which);
    }

    private EpochNode getOrCreateChild(int which) {
        EpochNode existing = this.getChildFromField(which);
        return existing != null ? existing : this.createChild(which);
    }

    private EpochNode createChild(int which) {
        long state;
        do {
            if (!EpochNode.isMarked(state = this.get())) continue;
            return this.getChild(state, which);
        } while (!this.compareAndSet(state, EpochNode.withChildPresent(state, which)));
        return this.constructPresentChild(which);
    }

    public EpochNode attemptArrive() {
        long state = this.get();
        if (EpochNode.isEntryFastPath(state) && this.compareAndSet(state, EpochNode.withArrive(state))) {
            return this;
        }
        return this.attemptArrive(0, 1);
    }

    private int getIdentity() {
        int h = System.identityHashCode(Thread.currentThread());
        return h - (h << 7) | Integer.MIN_VALUE;
    }

    private EpochNode attemptArrive(int id, int level) {
        int tries = 0;
        long state;
        while (!EpochNode.isMarked(state = this.get())) {
            if (EpochNode.isAnyChildPresent(state) || tries >= 2 && level < MAX_LEVELS) {
                EpochNode child;
                if (id == 0) {
                    id = this.getIdentity();
                }
                if ((child = this.getOrCreateChild(id & 7)) == null) {
                    return null;
                }
                return child.attemptArrive(id >> 3, level + 1);
            }
            if (!EpochNode.mayArrive(state)) {
                throw new IllegalStateException("maximum arrival count of 32767 exceeded");
            }
            if (this.compareAndSet(state, EpochNode.withArrive(state))) {
                return this;
            }
            ++tries;
        }
        return null;
    }

    @Override
    public void leave(int dataDelta) {
        long after;
        long state;
        do {
            if (EpochNode.mayLeave(state = this.get())) continue;
            throw new IllegalStateException("incorrect call to Epoch.leave");
        } while (!this.compareAndSet(state, after = EpochNode.withLeave(state, dataDelta)));
        if (EpochNode.isClosed(after)) {
            this.newlyClosed(after);
        }
    }

    private void newlyClosed(long state) {
        if (this._parent != null) {
            this._parent.childIsNowClosed(this._whichInParent, state);
        } else {
            this.onClosed(EpochNode.dataSum(state));
        }
    }

    private void childIsNowClosed(int which, long childState) {
        long after;
        long state;
        do {
            if (!EpochNode.isChildClosed(state = this.get(), which)) continue;
            return;
        } while (!this.compareAndSet(state, after = EpochNode.withChildClosed(state, which, childState)));
        if (EpochNode.isClosed(after)) {
            this.newlyClosed(after);
        }
    }

    public void beginClose() {
        long after;
        long before;
        long state;
        block10: {
            long after2;
            int attempts = 0;
            while (true) {
                ++attempts;
                state = this.get();
                if (EpochNode.isClosed(state)) {
                    return;
                }
                if (EpochNode.isMarked(state)) {
                    if (attempts < 1000) {
                        continue;
                    }
                    break block10;
                }
                after2 = EpochNode.withMarked(state);
                if (this.compareAndSet(state, after2)) break;
            }
            if (EpochNode.isAllChildrenClosed(after2)) {
                if (EpochNode.isClosed(after2) && this._parent == null) {
                    this.onClosed(EpochNode.dataSum(after2));
                }
                return;
            }
        }
        for (int which = 0; which < 8; ++which) {
            EpochNode child = this.getChild(state, which);
            if (child == null) continue;
            child.beginClose();
        }
        do {
            after = before = this.get();
            for (int which = 0; which < 8; ++which) {
                long childState;
                if (EpochNode.isChildClosed(before, which) || !EpochNode.isClosed(childState = this.getChildFromField(which).get())) continue;
                after = EpochNode.withChildClosed(after, which, childState);
            }
            if (before != after) continue;
            return;
        } while (!this.compareAndSet(before, after));
        if (EpochNode.isClosed(after) && this._parent == null) {
            this.onClosed(EpochNode.dataSum(after));
        }
    }

    public Integer attemptDataSum() {
        long state = this.get();
        if (!EpochNode.isAnyChildPresent(state) && EpochNode.entryCount(state) == 0) {
            return EpochNode.dataSum(state);
        }
        return null;
    }

    int computeSpread() {
        long state = this.get();
        if (EpochNode.isAnyChildPresent(state)) {
            int sum = 0;
            for (int which = 0; which < 8; ++which) {
                EpochNode child = this.getChild(state, which);
                if (child != null) {
                    sum += child.computeSpread();
                    continue;
                }
                ++sum;
            }
            return sum;
        }
        return 1;
    }

    private static class Child
    extends EpochNode {
        private static final long serialVersionUID = 0L;

        private Child(EpochNode parent, int whichInParent) {
            super(parent, whichInParent);
        }

        @Override
        protected void onClosed(int dataSum) {
            throw new Error();
        }
    }
}

