/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridKeyLock {
    private final ConcurrentMap<Object, Sync> locks = new ConcurrentHashMap<Object, Sync>();

    public <T> Object lockInterruptibly(T key) throws InterruptedException {
        Sync old;
        assert (key != null);
        Sync t = new Sync();
        while ((old = this.locks.putIfAbsent(key, t)) != null) {
            old.await();
        }
        return t;
    }

    public <T> Object lock(T key) {
        assert (key != null);
        boolean interrupted = false;
        Sync t = new Sync();
        try {
            block6: while (true) {
                Sync old;
                if ((old = this.locks.putIfAbsent(key, t)) != null) {
                    while (true) {
                        try {
                            old.await();
                            continue block6;
                        }
                        catch (InterruptedException ignored) {
                            interrupted = true;
                            continue;
                        }
                        break;
                    }
                }
                Sync sync = t;
                return sync;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Nullable
    public <T> Object tryLock(T key) {
        assert (key != null);
        Sync t = new Sync();
        Sync old = this.locks.putIfAbsent(key, t);
        return old != null ? null : t;
    }

    public <T> void unlock(T key, Object sync) {
        if (!this.locks.remove(key, sync)) {
            throw new IllegalStateException("Lock has not been acquired for key: " + key);
        }
        ((Sync)sync).finish();
    }

    public String toString() {
        return S.toString(GridKeyLock.class, this, "locksSize", this.locks.size());
    }

    private static class Sync {
        private volatile boolean finished;

        private Sync() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void await() throws InterruptedException {
            if (this.finished) {
                return;
            }
            Sync sync = this;
            synchronized (sync) {
                while (!this.finished) {
                    this.wait();
                }
            }
        }

        synchronized void finish() {
            this.finished = true;
            this.notifyAll();
        }
    }
}

