/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache;

import org.apache.ignite.Ignite;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractPredicate;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.cache.PlatformCacheEntryFilter;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.resources.IgniteInstanceResource;

public class PlatformCacheEntryFilterImpl
extends PlatformAbstractPredicate
implements PlatformCacheEntryFilter {
    private static final long serialVersionUID = 0L;

    public PlatformCacheEntryFilterImpl() {
    }

    public PlatformCacheEntryFilterImpl(Object pred, long ptr, PlatformContext ctx) {
        super(pred, ptr, ctx);
        assert (pred != null);
    }

    public boolean apply(Object k, Object v) {
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeLong(this.ptr);
            writer.writeObject(k);
            writer.writeObject(v);
            out.synchronize();
            boolean bl = this.ctx.gateway().cacheEntryFilterApply(mem.pointer()) != 0;
            return bl;
        }
    }

    @Override
    public void onClose() {
        if (this.ptr == 0L) {
            return;
        }
        assert (this.ctx != null);
        this.ctx.gateway().cacheEntryFilterDestroy(this.ptr);
        this.ptr = 0L;
    }

    @IgniteInstanceResource
    public void setIgniteInstance(Ignite ignite) {
        this.ctx = PlatformUtils.platformContext(ignite);
        if (this.ptr != 0L) {
            return;
        }
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeObject(this.pred);
            out.synchronize();
            this.ptr = this.ctx.gateway().cacheEntryFilterCreate(mem.pointer());
        }
    }
}

