/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.igfs.IgfsContext;

public abstract class IgfsManager {
    protected IgfsContext igfsCtx;
    protected IgniteLogger log;
    private AtomicBoolean starting = new AtomicBoolean();

    public void start(IgfsContext igfsCtx) throws IgniteCheckedException {
        if (!this.starting.compareAndSet(false, true)) assert (false) : "Method start is called more than once for manager: " + this;
        assert (igfsCtx != null);
        this.igfsCtx = igfsCtx;
        this.log = igfsCtx.kernalContext().log(this.getClass());
        this.start0();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    public final void stop(boolean cancel) {
        if (!this.starting.get()) {
            return;
        }
        this.stop0(cancel);
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    public final void onKernalStart() throws IgniteCheckedException {
        this.onKernalStart0();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.kernalStartInfo());
        }
    }

    public final void onKernalStop(boolean cancel) {
        if (!this.starting.get()) {
            return;
        }
        this.onKernalStop0(cancel);
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.kernalStopInfo());
        }
    }

    protected void start0() throws IgniteCheckedException {
    }

    protected void stop0(boolean cancel) {
    }

    protected void onKernalStart0() throws IgniteCheckedException {
    }

    protected void onKernalStop0(boolean cancel) {
    }

    protected String startInfo() {
        return "Cache manager started: " + this.getClass().getSimpleName();
    }

    protected String stopInfo() {
        return "Cache manager stopped: " + this.getClass().getSimpleName();
    }

    protected String kernalStartInfo() {
        return "Cache manager received onKernalStart() callback: " + this.getClass().getSimpleName();
    }

    protected String kernalStopInfo() {
        return "Cache manager received onKernalStop() callback: " + this.getClass().getSimpleName();
    }
}

