/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteStateAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IgniteTxRemoteStateImpl
extends IgniteTxRemoteStateAdapter {
    @GridToStringInclude
    protected Map<IgniteTxKey, IgniteTxEntry> readMap;
    @GridToStringInclude
    protected Map<IgniteTxKey, IgniteTxEntry> writeMap;

    public IgniteTxRemoteStateImpl(Map<IgniteTxKey, IgniteTxEntry> readMap, Map<IgniteTxKey, IgniteTxEntry> writeMap) {
        this.readMap = readMap;
        this.writeMap = writeMap;
    }

    @Override
    public void unwindEvicts(GridCacheSharedContext cctx) {
        assert (this.readMap == null || this.readMap.isEmpty());
        int singleCacheId = 0;
        HashSet<Integer> cacheIds = null;
        for (IgniteTxKey writeKey : this.writeMap.keySet()) {
            GridCacheContext ctx;
            int cacheId = writeKey.cacheId();
            assert (cacheId != 0);
            if (cacheId == singleCacheId || cacheIds != null && !cacheIds.add(cacheId)) continue;
            if (singleCacheId == 0) {
                singleCacheId = cacheId;
            } else if (cacheIds == null) {
                cacheIds = new HashSet<Integer>(2);
                cacheIds.add(cacheId);
            }
            if ((ctx = cctx.cacheContext(cacheId)) == null) continue;
            CU.unwindEvicts(ctx);
        }
    }

    @Override
    public IgniteTxEntry entry(IgniteTxKey key) {
        IgniteTxEntry e;
        IgniteTxEntry igniteTxEntry = e = this.writeMap == null ? null : this.writeMap.get(key);
        if (e == null) {
            e = this.readMap == null ? null : this.readMap.get(key);
        }
        return e;
    }

    @Override
    public boolean hasWriteKey(IgniteTxKey key) {
        return this.writeMap.containsKey(key);
    }

    @Override
    public Set<IgniteTxKey> readSet() {
        return this.readMap.keySet();
    }

    @Override
    public Set<IgniteTxKey> writeSet() {
        return this.writeMap.keySet();
    }

    @Override
    public Collection<IgniteTxEntry> writeEntries() {
        return this.writeMap.values();
    }

    @Override
    public Collection<IgniteTxEntry> readEntries() {
        return this.readMap.values();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> writeMap() {
        return this.writeMap;
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> readMap() {
        return this.readMap;
    }

    @Override
    public boolean empty() {
        return this.readMap.isEmpty() && this.writeMap.isEmpty();
    }

    @Override
    public void addWriteEntry(IgniteTxKey key, IgniteTxEntry e) {
        this.writeMap.put(key, e);
    }

    @Override
    public void clearEntry(IgniteTxKey key) {
        this.readMap.remove(key);
        this.writeMap.remove(key);
    }

    @Override
    public Collection<IgniteTxEntry> allEntries() {
        return F.concat(false, this.writeEntries(), this.readEntries());
    }

    @Override
    public IgniteTxEntry singleWrite() {
        return null;
    }

    @Override
    public void invalidPartition(int part) {
        if (this.writeMap != null) {
            Iterator<IgniteTxEntry> it = this.writeMap.values().iterator();
            while (it.hasNext()) {
                IgniteTxEntry e = it.next();
                GridCacheContext<?, ?> cacheCtx = e.context();
                GridCacheEntryEx cached = e.cached();
                if (cached != null) {
                    if (cached.partition() != part) continue;
                    it.remove();
                    continue;
                }
                if (cacheCtx.affinity().partition(e.key()) != part) continue;
                it.remove();
            }
        }
    }

    public String toString() {
        return S.toString(IgniteTxRemoteStateImpl.class, this);
    }

    @Override
    public Collection<CacheStoreManager> stores(GridCacheSharedContext cctx) {
        int locStoreCnt = cctx.getLocalStoreCount();
        if (locStoreCnt > 0 && !this.writeMap.isEmpty()) {
            ArrayList<CacheStoreManager> stores = null;
            for (IgniteTxEntry e : this.writeMap.values()) {
                CacheStoreManager store;
                if (e.skipStore() || !(store = e.context().store()).configured() || !store.isLocal()) continue;
                if (stores == null) {
                    stores = new ArrayList<CacheStoreManager>(locStoreCnt);
                }
                stores.add(store);
                if (stores.size() != locStoreCnt) continue;
                break;
            }
            return stores;
        }
        return null;
    }
}

