/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.CheckpointWriteOrder;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.file.MappedFileMemoryProvider;
import org.apache.ignite.internal.mem.unsafe.UnsafeMemoryProvider;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.wal.StorageException;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MemoryRecoveryRecord;
import org.apache.ignite.internal.pagemem.wal.record.MetastoreDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionDestroyRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionMetaStateRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointFuture;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointWriteProgressSupplier;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointMetricsTracker;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.PureJavaCrc32;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.util.GridMultiCollectionWrapper;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.CountDownFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridInClosure3X;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.mxbean.DataStorageMetricsMXBean;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedHashMap;

public class GridCacheDatabaseSharedManager
extends IgniteCacheDatabaseSharedManager
implements CheckpointWriteProgressSupplier {
    public static final String IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC = "IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC";
    private static final String METASTORE_DATA_REGION_NAME = "metastoreMemPlc";
    private static final long GB = 0x40000000L;
    public static final Long DFLT_MIN_CHECKPOINTING_PAGE_BUFFER_SIZE = 0x10000000L;
    public static final Long DFLT_MAX_CHECKPOINTING_PAGE_BUFFER_SIZE = 0x80000000L;
    private final boolean skipSync = IgniteSystemProperties.getBoolean("IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC");
    private boolean skipCrc = IgniteSystemProperties.getBoolean("IGNITE_PDS_SKIP_CRC", false);
    private final int walRebalanceThreshold = IgniteSystemProperties.getInteger("IGNITE_PDS_WAL_REBALANCE_THRESHOLD", 500000);
    private final String throttlingPolicyOverride = IgniteSystemProperties.getString("IGNITE_OVERRIDE_WRITE_THROTTLING_ENABLED");
    private static final ThreadLocal<Integer> CHECKPOINT_LOCK_HOLD_COUNT = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final boolean ASSERTION_ENABLED = GridCacheDatabaseSharedManager.class.desiredAssertionStatus();
    private static final Pattern CP_FILE_NAME_PATTERN = Pattern.compile("(\\d+)-(.*)-(START|END)\\.bin");
    private static final Pattern NODE_STARTED_FILE_NAME_PATTERN = Pattern.compile("(\\d+)-node-started\\.bin");
    private static final String NODE_STARTED_FILE_NAME_SUFFIX = "-node-started.bin";
    private static final FileFilter CP_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return CP_FILE_NAME_PATTERN.matcher(f.getName()).matches();
        }
    };
    private static final FileFilter NODE_STARTED_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.getName().endsWith(GridCacheDatabaseSharedManager.NODE_STARTED_FILE_NAME_SUFFIX);
        }
    };
    private static final Comparator<GridDhtLocalPartition> ASC_PART_COMPARATOR = new Comparator<GridDhtLocalPartition>(){

        @Override
        public int compare(GridDhtLocalPartition a, GridDhtLocalPartition b) {
            return Integer.compare(a.id(), b.id());
        }
    };
    private static final Comparator<File> CP_TS_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            long ts2;
            Matcher m1 = CP_FILE_NAME_PATTERN.matcher(o1.getName());
            Matcher m2 = CP_FILE_NAME_PATTERN.matcher(o2.getName());
            boolean s1 = m1.matches();
            boolean s2 = m2.matches();
            assert (s1) : "Failed to match CP file: " + o1.getAbsolutePath();
            assert (s2) : "Failed to match CP file: " + o2.getAbsolutePath();
            long ts1 = Long.parseLong(m1.group(1));
            int res = Long.compare(ts1, ts2 = Long.parseLong(m2.group(1)));
            if (res == 0) {
                CheckpointEntryType type1 = CheckpointEntryType.valueOf(m1.group(3));
                CheckpointEntryType type2 = CheckpointEntryType.valueOf(m2.group(3));
                assert (type1 != type2) : "o1=" + o1.getAbsolutePath() + ", o2=" + o2.getAbsolutePath();
                res = type1 == CheckpointEntryType.START ? -1 : 1;
            }
            return res;
        }
    };
    private static final String MBEAN_NAME = "DataStorageMetrics";
    private static final String MBEAN_GROUP = "Persistent Store";
    private static final String WAL_KEY_PREFIX = "grp-wal-";
    private static final String WAL_GLOBAL_KEY_PREFIX = "grp-wal-disabled-";
    private static final String WAL_LOCAL_KEY_PREFIX = "grp-wal-local-disabled-";
    private static final IgnitePredicate<String> WAL_KEY_PREFIX_PRED = new IgnitePredicate<String>(){

        @Override
        public boolean apply(String key) {
            return key.startsWith(GridCacheDatabaseSharedManager.WAL_KEY_PREFIX);
        }
    };
    private static final long PARTITION_DESTROY_CHECKPOINT_TIMEOUT = 30000L;
    private volatile Checkpointer checkpointer;
    private volatile boolean checkpointsEnabled = true;
    private volatile GridFutureAdapter<Void> enableChangeApplied;
    private ReentrantReadWriteLock checkpointLock = new ReentrantReadWriteLock();
    private long checkpointFreq;
    private FilePageStoreManager storeMgr;
    private File cpDir;
    private volatile boolean printCheckpointStats = true;
    private final DataStorageConfiguration persistenceCfg;
    private final Collection<DbCheckpointListener> lsnrs = new CopyOnWriteArrayList<DbCheckpointListener>();
    private final CheckpointHistory checkpointHist = new CheckpointHistory();
    private boolean stopping;
    @Nullable
    private ExecutorService asyncRunner;
    private ThreadLocal<ByteBuffer> threadBuf;
    private final ConcurrentMap<Integer, GridFutureAdapter<Void>> idxRebuildFuts = new ConcurrentHashMap<Integer, GridFutureAdapter<Void>>();
    @Nullable
    private FileLockHolder fileLockHolder;
    private final long lockWaitTime;
    private final int maxCpHistMemSize;
    private Map<Integer, Map<Integer, T2<Long, WALPointer>>> reservedForExchange;
    private final ConcurrentMap<T2<Integer, Integer>, T2<Long, WALPointer>> reservedForPreloading = new ConcurrentHashMap<T2<Integer, Integer>, T2<Long, WALPointer>>();
    private IgniteCacheSnapshotManager snapshotMgr;
    private DataStorageMetricsImpl persStoreMetrics;
    private ObjectName persistenceMetricsMbeanName;
    private volatile AtomicInteger writtenPagesCntr = null;
    private volatile AtomicInteger syncedPagesCntr = null;
    private volatile AtomicInteger evictedPagesCntr = null;
    private volatile int currCheckpointPagesCnt;
    private MetaStorage metaStorage;
    private List<MetastorageLifecycleListener> metastorageLifecycleLsnrs;
    private Collection<Integer> initiallyGlobalWalDisabledGrps = new HashSet<Integer>();
    private Collection<Integer> initiallyLocalWalDisabledGrps = new HashSet<Integer>();

    public GridCacheDatabaseSharedManager(GridKernalContext ctx) {
        IgniteConfiguration cfg = ctx.config();
        this.persistenceCfg = cfg.getDataStorageConfiguration();
        assert (this.persistenceCfg != null);
        this.checkpointFreq = this.persistenceCfg.getCheckpointFrequency();
        this.lockWaitTime = this.persistenceCfg.getLockWaitTime();
        this.persStoreMetrics = new DataStorageMetricsImpl(this.persistenceCfg.isMetricsEnabled(), this.persistenceCfg.getMetricsRateTimeInterval(), this.persistenceCfg.getMetricsSubIntervalCount());
        this.metastorageLifecycleLsnrs = ctx.internalSubscriptionProcessor().getMetastorageSubscribers();
        this.maxCpHistMemSize = Math.min(this.persistenceCfg.getWalHistorySize(), IgniteSystemProperties.getInteger("IGNITE_PDS_MAX_CHECKPOINT_MEMORY_HISTORY_SIZE", 100));
    }

    private void notifyMetastorageReadyForRead() throws IgniteCheckedException {
        for (MetastorageLifecycleListener lsnr : this.metastorageLifecycleLsnrs) {
            lsnr.onReadyForRead(this.metaStorage);
        }
    }

    private void notifyMetastorageReadyForReadWrite() throws IgniteCheckedException {
        for (MetastorageLifecycleListener lsnr : this.metastorageLifecycleLsnrs) {
            lsnr.onReadyForReadWrite(this.metaStorage);
        }
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    public IgniteInternalFuture<Void> enableCheckpoints(boolean enable) {
        GridFutureAdapter<Void> fut = new GridFutureAdapter<Void>();
        this.enableChangeApplied = fut;
        this.checkpointsEnabled = enable;
        this.wakeupForCheckpoint("enableCheckpoints()");
        return fut;
    }

    @Override
    protected void initDataRegions(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        super.initDataRegions(memCfg);
        this.addDataRegion(memCfg, this.createDataRegionConfiguration(memCfg), false);
        this.persStoreMetrics.regionMetrics(this.memMetricsMap.values());
    }

    private DataRegionConfiguration createDataRegionConfiguration(DataStorageConfiguration storageCfg) {
        DataRegionConfiguration cfg = new DataRegionConfiguration();
        cfg.setName(METASTORE_DATA_REGION_NAME);
        cfg.setInitialSize(storageCfg.getSystemRegionInitialSize());
        cfg.setMaxSize(storageCfg.getSystemRegionMaxSize());
        cfg.setPersistenceEnabled(true);
        return cfg;
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.threadBuf = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(GridCacheDatabaseSharedManager.this.pageSize());
                tmpWriteBuf.order(ByteOrder.nativeOrder());
                return tmpWriteBuf;
            }
        };
        this.snapshotMgr = this.cctx.snapshot();
        GridKernalContext kernalCtx = this.cctx.kernalContext();
        if (!kernalCtx.clientNode()) {
            this.checkpointer = new Checkpointer(this.cctx.igniteInstanceName(), "db-checkpoint-thread", this.log);
            IgnitePageStoreManager store = this.cctx.pageStore();
            assert (store instanceof FilePageStoreManager) : "Invalid page store manager was created: " + store;
            this.storeMgr = (FilePageStoreManager)store;
            this.cpDir = Paths.get(this.storeMgr.workDir().getAbsolutePath(), "cp").toFile();
            if (!U.mkdirs(this.cpDir)) {
                throw new IgniteCheckedException("Could not create directory for checkpoint metadata: " + this.cpDir);
            }
            FileLockHolder preLocked = kernalCtx.pdsFolderResolver().resolveFolders().getLockedFileLockHolder();
            if (preLocked == null) {
                this.fileLockHolder = new FileLockHolder(this.storeMgr.workDir().getPath(), kernalCtx, this.log);
            }
            this.persStoreMetrics.wal(this.cctx.wal());
            this.readMetastore();
        }
    }

    private void initDataBase() {
        if (this.persistenceCfg.getCheckpointThreads() > 1) {
            this.asyncRunner = new IgniteThreadPoolExecutor("checkpoint-runner", this.cctx.igniteInstanceName(), this.persistenceCfg.getCheckpointThreads(), this.persistenceCfg.getCheckpointThreads(), 30000L, new LinkedBlockingQueue<Runnable>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMetastore() throws IgniteCheckedException {
        try {
            DataStorageConfiguration memCfg = this.cctx.kernalContext().config().getDataStorageConfiguration();
            DataRegionConfiguration plcCfg = this.createDataRegionConfiguration(memCfg);
            File allocPath = this.buildAllocPath(plcCfg);
            DirectMemoryProvider memProvider = allocPath == null ? new UnsafeMemoryProvider(this.log) : new MappedFileMemoryProvider(this.log, allocPath);
            DataRegionMetricsImpl memMetrics = new DataRegionMetricsImpl(plcCfg);
            PageMemoryEx storePageMem = (PageMemoryEx)this.createPageMemory(memProvider, memCfg, plcCfg, memMetrics, false);
            DataRegion regCfg = new DataRegion(storePageMem, plcCfg, memMetrics, this.createPageEvictionTracker(plcCfg, storePageMem));
            CheckpointStatus status = this.readCheckpointStatus();
            this.cctx.pageStore().initializeForMetastorage();
            storePageMem.start();
            this.checkpointReadLock();
            try {
                this.restoreMemory(status, true, storePageMem);
                this.metaStorage = new MetaStorage(this.cctx, regCfg, memMetrics, true);
                this.metaStorage.init(this);
                this.applyLastUpdates(status, true);
                this.fillWalDisabledGroups();
                this.notifyMetastorageReadyForRead();
            }
            finally {
                this.checkpointReadUnlock();
            }
            this.metaStorage = null;
            storePageMem.stop();
        }
        catch (StorageException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw new IgniteCheckedException(e);
        }
    }

    public static long checkpointBufferSize(DataRegionConfiguration regCfg) {
        if (!regCfg.isPersistenceEnabled()) {
            return 0L;
        }
        long res = regCfg.getCheckpointPageBufferSize();
        if (res == 0L) {
            res = regCfg.getMaxSize() < 0x40000000L ? Math.min(DFLT_MIN_CHECKPOINTING_PAGE_BUFFER_SIZE, regCfg.getMaxSize()) : (regCfg.getMaxSize() < 0x200000000L ? regCfg.getMaxSize() / 4L : DFLT_MAX_CHECKPOINTING_PAGE_BUFFER_SIZE);
        }
        return res;
    }

    @Override
    public void onActivate(GridKernalContext ctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activate database manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.snapshotMgr = this.cctx.snapshot();
        if (!this.cctx.localNode().isClient()) {
            this.initDataBase();
            this.registrateMetricsMBean();
        }
        if (this.checkpointer == null) {
            this.checkpointer = new Checkpointer(this.cctx.igniteInstanceName(), "db-checkpoint-thread", this.log);
        }
        super.onActivate(ctx);
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate database manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.onKernalStop0(false);
        this.stop0(false);
        this.stopping = false;
        if (!this.cctx.localNode().isClient() && this.fileLockHolder != null) {
            this.fileLockHolder = new FileLockHolder(this.storeMgr.workDir().getPath(), this.cctx.kernalContext(), this.log);
        }
    }

    private void registrateMetricsMBean() throws IgniteCheckedException {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        try {
            this.persistenceMetricsMbeanName = U.registerMBean(this.cctx.kernalContext().config().getMBeanServer(), this.cctx.kernalContext().igniteInstanceName(), MBEAN_GROUP, MBEAN_NAME, this.persStoreMetrics, DataStorageMetricsMXBean.class);
        }
        catch (Throwable e) {
            throw new IgniteCheckedException("Failed to register DataStorageMetrics MBean.", e);
        }
    }

    private void unRegistrateMetricsMBean() {
        if (this.persistenceMetricsMbeanName == null) {
            return;
        }
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            this.cctx.kernalContext().config().getMBeanServer().unregisterMBean(this.persistenceMetricsMbeanName);
            this.persistenceMetricsMbeanName = null;
        }
        catch (Throwable e) {
            U.error(this.log, "Failed to unregister DataStorageMetrics MBean.", e);
        }
    }

    @Override
    protected IgniteOutClosure<Long> freeSpaceProvider(DataRegionConfiguration dataRegCfg) {
        if (!dataRegCfg.isPersistenceEnabled()) {
            return super.freeSpaceProvider(dataRegCfg);
        }
        final String dataRegName = dataRegCfg.getName();
        return new IgniteOutClosure<Long>(){

            @Override
            public Long apply() {
                long freeSpace = 0L;
                for (CacheGroupContext grpCtx : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (!grpCtx.dataRegion().config().getName().equals(dataRegName)) continue;
                    assert (grpCtx.offheap() instanceof GridCacheOffheapManager);
                    freeSpace += ((GridCacheOffheapManager)grpCtx.offheap()).freeSpace();
                }
                return freeSpace;
            }
        };
    }

    @Override
    public void readCheckpointAndRestoreMemory(List<DynamicCacheDescriptor> cachesToStart) throws IgniteCheckedException {
        assert (!this.cctx.localNode().isClient());
        this.checkpointReadLock();
        try {
            if (!F.isEmpty(cachesToStart)) {
                for (DynamicCacheDescriptor desc : cachesToStart) {
                    if (!CU.affinityNode(this.cctx.localNode(), desc.cacheConfiguration().getNodeFilter())) continue;
                    this.storeMgr.initializeForCache(desc.groupDescriptor(), new StoredCacheData(desc.cacheConfiguration()));
                }
            }
            CheckpointStatus status = this.readCheckpointStatus();
            this.cctx.pageStore().initializeForMetastorage();
            this.metaStorage = new MetaStorage(this.cctx, (DataRegion)this.dataRegionMap.get(METASTORE_DATA_REGION_NAME), (DataRegionMetricsImpl)this.memMetricsMap.get(METASTORE_DATA_REGION_NAME));
            WALPointer restore = this.restoreMemory(status);
            if (restore == null && status.endPtr != CheckpointStatus.NULL_PTR) {
                throw new StorageException("Restore wal pointer = " + restore + ", while status.endPtr = " + status.endPtr + ". Can't restore memory - critical part of WAL archive is missing.");
            }
            this.cctx.wal().resumeLogging(restore);
            WALPointer ptr = this.cctx.wal().log(new MemoryRecoveryRecord(U.currentTimeMillis()));
            if (ptr != null) {
                this.cctx.wal().flush(ptr, true);
                this.nodeStart(ptr);
            }
            this.metaStorage.init(this);
            this.notifyMetastorageReadyForReadWrite();
        }
        catch (StorageException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw e;
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    private void nodeStart(WALPointer ptr) throws IgniteCheckedException {
        FileWALPointer p = (FileWALPointer)ptr;
        String fileName = U.currentTimeMillis() + NODE_STARTED_FILE_NAME_SUFFIX;
        ByteBuffer buf = ByteBuffer.allocate(20);
        buf.order(ByteOrder.nativeOrder());
        try (FileChannel ch = FileChannel.open(Paths.get(this.cpDir.getAbsolutePath(), fileName), StandardOpenOption.CREATE_NEW, StandardOpenOption.APPEND);){
            buf.putLong(p.index());
            buf.putInt(p.fileOffset());
            buf.putInt(p.length());
            buf.flip();
            ch.write(buf);
            buf.clear();
            ch.force(true);
        }
        catch (IOException e) {
            throw new IgniteCheckedException(e);
        }
    }

    public List<T2<Long, WALPointer>> nodeStartedPointers() throws IgniteCheckedException {
        ArrayList<T2<Long, WALPointer>> res = new ArrayList<T2<Long, WALPointer>>();
        File[] files = this.cpDir.listFiles(NODE_STARTED_FILE_FILTER);
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                Long ts2;
                String n1 = o1.getName();
                String n2 = o2.getName();
                Long ts1 = Long.valueOf(n1.substring(0, n1.length() - GridCacheDatabaseSharedManager.NODE_STARTED_FILE_NAME_SUFFIX.length()));
                if (ts1 == (ts2 = Long.valueOf(n2.substring(0, n2.length() - GridCacheDatabaseSharedManager.NODE_STARTED_FILE_NAME_SUFFIX.length())))) {
                    return 0;
                }
                if (ts1 < ts2) {
                    return -1;
                }
                return 1;
            }
        });
        ByteBuffer buf = ByteBuffer.allocate(20);
        buf.order(ByteOrder.nativeOrder());
        for (File f : files) {
            String name = f.getName();
            Long ts = Long.valueOf(name.substring(0, name.length() - NODE_STARTED_FILE_NAME_SUFFIX.length()));
            try (FileChannel ch = FileChannel.open(f.toPath(), StandardOpenOption.READ);){
                ch.read(buf);
                buf.flip();
                FileWALPointer ptr = new FileWALPointer(buf.getLong(), buf.getInt(), buf.getInt());
                res.add(new T2<Long, FileWALPointer>(ts, ptr));
                buf.clear();
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to read node started marker file: " + f.getAbsolutePath(), e);
            }
        }
        return res;
    }

    @Override
    public void lock() throws IgniteCheckedException {
        if (this.fileLockHolder != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Try to capture file lock [nodeId=" + this.cctx.localNodeId() + " path=" + this.fileLockHolder.lockPath() + "]");
            }
            this.fileLockHolder.tryLock(this.lockWaitTime);
        }
    }

    @Override
    public void unLock() {
        if (this.fileLockHolder != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Release file lock [nodeId=" + this.cctx.localNodeId() + " path=" + this.fileLockHolder.lockPath() + "]");
            }
            this.fileLockHolder.release();
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        this.checkpointLock.writeLock().lock();
        try {
            this.stopping = true;
        }
        finally {
            this.checkpointLock.writeLock().unlock();
        }
        this.shutdownCheckpointer(cancel);
        this.lsnrs.clear();
        super.onKernalStop0(cancel);
        if (!this.cctx.kernalContext().clientNode()) {
            this.unLock();
            if (this.fileLockHolder != null) {
                this.fileLockHolder.close();
            }
        }
        this.unRegistrateMetricsMBean();
    }

    private long[] calculateFragmentSizes(int concLvl, long cacheSize, long chpBufSize) {
        long fragmentSize;
        if (concLvl < 2) {
            concLvl = Runtime.getRuntime().availableProcessors();
        }
        if ((fragmentSize = cacheSize / (long)concLvl) < 0x100000L) {
            fragmentSize = 0x100000L;
        }
        long[] sizes = new long[concLvl + 1];
        for (int i = 0; i < concLvl; ++i) {
            sizes[i] = fragmentSize;
        }
        sizes[concLvl] = chpBufSize;
        return sizes;
    }

    @Override
    protected PageMemory createPageMemory(DirectMemoryProvider memProvider, DataStorageConfiguration memCfg, DataRegionConfiguration plcCfg, DataRegionMetricsImpl memMetrics, final boolean trackable) {
        if (!plcCfg.isPersistenceEnabled()) {
            return super.createPageMemory(memProvider, memCfg, plcCfg, memMetrics, trackable);
        }
        memMetrics.persistenceEnabled(true);
        long cacheSize = plcCfg.getMaxSize();
        long chpBufSize = GridCacheDatabaseSharedManager.checkpointBufferSize(plcCfg);
        if (chpBufSize > cacheSize) {
            U.quietAndInfo(this.log, "Configured checkpoint page buffer size is too big, setting to the max region size [size=" + U.readableSize(cacheSize, false) + ",  memPlc=" + plcCfg.getName() + ']');
            chpBufSize = cacheSize;
        }
        GridInClosure3X<Long, FullPageId, PageMemoryEx> changeTracker = trackable ? new GridInClosure3X<Long, FullPageId, PageMemoryEx>(){

            @Override
            public void applyx(Long page, FullPageId fullId, PageMemoryEx pageMem) throws IgniteCheckedException {
                if (trackable) {
                    GridCacheDatabaseSharedManager.this.snapshotMgr.onChangeTrackerPage(page, fullId, pageMem);
                }
            }
        } : null;
        PageMemoryImpl pageMem = new PageMemoryImpl(this.wrapMetricsMemoryProvider(memProvider, memMetrics), this.calculateFragmentSizes(memCfg.getConcurrencyLevel(), cacheSize, chpBufSize), this.cctx, memCfg.getPageSize(), (fullId, pageBuf, tag) -> {
            memMetrics.onPageWritten();
            this.storeMgr.write(fullId.groupId(), fullId.pageId(), pageBuf, tag);
            this.snapshotMgr.flushDirtyPageHandler(fullId, pageBuf, tag);
            AtomicInteger cntr = this.evictedPagesCntr;
            if (cntr != null) {
                cntr.incrementAndGet();
            }
        }, changeTracker, this, memMetrics, this.resolveThrottlingPolicy(), this);
        memMetrics.pageMemory(pageMem);
        return pageMem;
    }

    @NotNull
    private PageMemoryImpl.ThrottlingPolicy resolveThrottlingPolicy() {
        PageMemoryImpl.ThrottlingPolicy plc;
        PageMemoryImpl.ThrottlingPolicy throttlingPolicy = plc = this.persistenceCfg.isWriteThrottlingEnabled() ? PageMemoryImpl.ThrottlingPolicy.SPEED_BASED : PageMemoryImpl.ThrottlingPolicy.CHECKPOINT_BUFFER_ONLY;
        if (this.throttlingPolicyOverride != null) {
            try {
                plc = PageMemoryImpl.ThrottlingPolicy.valueOf(this.throttlingPolicyOverride.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.log.error("Incorrect value of IGNITE_OVERRIDE_WRITE_THROTTLING_ENABLED property: " + this.throttlingPolicyOverride + ". Default throttling policy " + (Object)((Object)plc) + " will be used.");
            }
        }
        return plc;
    }

    @Override
    protected void checkRegionEvictionProperties(DataRegionConfiguration regCfg, DataStorageConfiguration dbCfg) throws IgniteCheckedException {
        if (!regCfg.isPersistenceEnabled()) {
            super.checkRegionEvictionProperties(regCfg, dbCfg);
        }
        if (regCfg.getPageEvictionMode() != DataPageEvictionMode.DISABLED) {
            U.warn(this.log, "Page eviction mode set for [" + regCfg.getName() + "] data will have no effect" + " because the oldest pages are evicted automatically if Ignite persistence is enabled.");
        }
    }

    @Override
    protected void checkPageSize(DataStorageConfiguration memCfg) {
        if (memCfg.getPageSize() == 0) {
            try {
                assert (this.cctx.pageStore() instanceof FilePageStoreManager) : "Invalid page store manager was created: " + this.cctx.pageStore();
                Path anyIdxPartFile = IgniteUtils.searchFileRecursively(((FilePageStoreManager)this.cctx.pageStore()).workDir().toPath(), "index.bin");
                if (anyIdxPartFile != null) {
                    memCfg.setPageSize(this.resolvePageSizeFromPartitionFile(anyIdxPartFile));
                    return;
                }
            }
            catch (IOException | IllegalArgumentException | IgniteCheckedException e) {
                U.quietAndWarn(this.log, "Attempt to resolve pageSize from store files failed: " + e.getMessage());
                U.quietAndWarn(this.log, "Default page size will be used: 4096 bytes");
            }
            memCfg.setPageSize(4096);
        }
    }

    private int resolvePageSizeFromPartitionFile(Path partFile) throws IOException, IgniteCheckedException {
        try (FileIO fileIO = this.persistenceCfg.getFileIOFactory().create(partFile.toFile());){
            int minimalHdr = 17;
            if (fileIO.size() < (long)minimalHdr) {
                throw new IgniteCheckedException("Partition file is too small: " + partFile);
            }
            ByteBuffer hdr = ByteBuffer.allocate(minimalHdr).order(ByteOrder.LITTLE_ENDIAN);
            while (hdr.remaining() > 0) {
                fileIO.read(hdr);
            }
            hdr.rewind();
            hdr.getLong();
            hdr.getInt();
            hdr.get();
            int pageSize = hdr.getInt();
            if (pageSize == 2048) {
                U.quietAndWarn(this.log, "You are currently using persistent store with 2K pages (DataStorageConfiguration#pageSize). If you use SSD disk, consider migrating to 4K pages for better IO performance.");
            }
            int n = pageSize;
            return n;
        }
    }

    private void shutdownCheckpointer(boolean cancel) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            if (cancel) {
                cp.shutdownNow();
            } else {
                cp.cancel();
            }
            try {
                U.join(cp);
                this.checkpointer = null;
            }
            catch (IgniteInterruptedCheckedException ignore) {
                U.warn(this.log, "Was interrupted while waiting for checkpointer shutdown, will not wait for checkpoint to finish.");
                cp.shutdownNow();
                while (true) {
                    try {
                        U.join(cp);
                        this.checkpointer = null;
                        cp.scheduledCp.cpFinishFut.onDone(new NodeStoppingException("Checkpointer is stopped during node stop."));
                    }
                    catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                        continue;
                    }
                    break;
                }
                Thread.currentThread().interrupt();
            }
        }
        if (this.asyncRunner != null) {
            this.asyncRunner.shutdownNow();
            try {
                this.asyncRunner.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void beforeExchange(GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        block5: {
            ExchangeActions acts;
            block6: {
                DiscoveryEvent discoEvt = fut.firstEvent();
                boolean joinEvt = discoEvt.type() == 10;
                boolean locNode = discoEvt.eventNode().isLocal();
                boolean isSrvNode = !this.cctx.kernalContext().clientNode();
                boolean clusterInTransitionStateToActive = fut.activateCluster();
                if (clusterInTransitionStateToActive || joinEvt && locNode && isSrvNode) {
                    this.restoreState();
                } else if (fut.exchangeActions() != null && !F.isEmpty(fut.exchangeActions().cacheGroupsToStart())) {
                    Set<Integer> restoreGroups = fut.exchangeActions().cacheGroupsToStart().stream().map(actionData -> actionData.descriptor().groupId()).collect(Collectors.toSet());
                    this.restorePartitionStates(Collections.emptyMap(), restoreGroups);
                }
                if (!this.cctx.kernalContext().query().moduleEnabled() || (acts = fut.exchangeActions()) == null) break block5;
                if (F.isEmpty(acts.cacheStartRequests())) break block6;
                for (ExchangeActions.CacheActionData actionData2 : acts.cacheStartRequests()) {
                    this.prepareIndexRebuildFuture(CU.cacheId(actionData2.request().cacheName()));
                }
                break block5;
            }
            if (acts.localJoinContext() == null || F.isEmpty(acts.localJoinContext().caches())) break block5;
            for (T2<DynamicCacheDescriptor, NearCacheConfiguration> tup : acts.localJoinContext().caches()) {
                this.prepareIndexRebuildFuture(((DynamicCacheDescriptor)tup.get1()).cacheId());
            }
        }
    }

    private void prepareIndexRebuildFuture(int cacheId) {
        GridFutureAdapter old = this.idxRebuildFuts.put(cacheId, new GridFutureAdapter());
        if (old != null) {
            old.onDone();
        }
    }

    @Override
    public void rebuildIndexesIfNeeded(GridDhtPartitionsExchangeFuture fut) {
        if (this.cctx.kernalContext().query().moduleEnabled()) {
            for (final GridCacheContext cacheCtx : this.cctx.cacheContexts()) {
                if (!cacheCtx.startTopologyVersion().equals(fut.initialVersion())) continue;
                final int cacheId = cacheCtx.cacheId();
                final GridFutureAdapter usrFut = (GridFutureAdapter)this.idxRebuildFuts.get(cacheId);
                if (!this.cctx.pageStore().hasIndexStore(cacheCtx.groupId()) && cacheCtx.affinityNode()) {
                    IgniteInternalFuture<?> rebuildFut = this.cctx.kernalContext().query().rebuildIndexesFromHash(Collections.singletonList(cacheCtx.cacheId()));
                    assert (usrFut != null) : "Missing user future for cache: " + cacheCtx.name();
                    rebuildFut.listen(new CI1<IgniteInternalFuture>(){

                        @Override
                        public void apply(IgniteInternalFuture igniteInternalFut) {
                            GridCacheDatabaseSharedManager.this.idxRebuildFuts.remove(cacheId, usrFut);
                            usrFut.onDone(igniteInternalFut.error());
                            CacheConfiguration ccfg = cacheCtx.config();
                            if (ccfg != null) {
                                GridCacheDatabaseSharedManager.this.log().info("Finished indexes rebuilding for cache [name=" + ccfg.getName() + ", grpName=" + ccfg.getGroupName() + ']');
                            }
                        }
                    });
                    continue;
                }
                if (usrFut == null) continue;
                this.idxRebuildFuts.remove(cacheId, usrFut);
                usrFut.onDone();
            }
        }
    }

    @Override
    @Nullable
    public IgniteInternalFuture indexRebuildFuture(int cacheId) {
        return (IgniteInternalFuture)this.idxRebuildFuts.get(cacheId);
    }

    @Override
    public void onCacheGroupsStopped(Collection<IgniteBiTuple<CacheGroupContext, Boolean>> stoppedGrps) {
        HashMap<PageMemoryEx, HashSet<Integer>> destroyed = new HashMap<PageMemoryEx, HashSet<Integer>>();
        for (IgniteBiTuple<CacheGroupContext, Boolean> tup : stoppedGrps) {
            CacheGroupContext cacheGroupContext = tup.get1();
            if (!cacheGroupContext.persistenceEnabled()) continue;
            this.snapshotMgr.onCacheGroupStop(cacheGroupContext);
            PageMemoryEx pageMem = (PageMemoryEx)cacheGroupContext.dataRegion().pageMemory();
            HashSet<Integer> grpIds = (HashSet<Integer>)destroyed.get(pageMem);
            if (grpIds == null) {
                grpIds = new HashSet<Integer>();
                destroyed.put(pageMem, grpIds);
            }
            grpIds.add(tup.get1().groupId());
            pageMem.onCacheGroupDestroyed(tup.get1().groupId());
        }
        ArrayList<IgniteInternalFuture<Void>> clearFuts = new ArrayList<IgniteInternalFuture<Void>>(destroyed.size());
        for (Map.Entry entry : destroyed.entrySet()) {
            Collection grpIds = (Collection)entry.getValue();
            clearFuts.add(((PageMemoryEx)entry.getKey()).clearAsync((grpId, pageIdg) -> grpIds.contains(grpId), false));
        }
        for (IgniteInternalFuture igniteInternalFuture : clearFuts) {
            try {
                igniteInternalFuture.get();
            }
            catch (IgniteCheckedException e) {
                this.log.error("Failed to clear page memory", e);
            }
        }
        if (this.cctx.pageStore() != null) {
            for (IgniteBiTuple igniteBiTuple : stoppedGrps) {
                CacheGroupContext grp = (CacheGroupContext)igniteBiTuple.get1();
                if (!grp.affinityNode()) continue;
                try {
                    this.cctx.pageStore().shutdownForCacheGroup(grp, (Boolean)igniteBiTuple.get2());
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to gracefully clean page store resources for destroyed cache [cache=" + grp.cacheOrGroupName() + "]", e);
                }
            }
        }
    }

    @Override
    public void checkpointReadLock() {
        if (this.checkpointLock.writeLock().isHeldByCurrentThread()) {
            return;
        }
        while (true) {
            this.checkpointLock.readLock().lock();
            if (this.stopping) {
                this.checkpointLock.readLock().unlock();
                throw new RuntimeException("Failed to perform cache update: node is stopping.");
            }
            if (this.safeToUpdatePageMemories() || this.checkpointLock.getReadHoldCount() > 1) break;
            this.checkpointLock.readLock().unlock();
            try {
                this.checkpointer.wakeupForCheckpoint(0L, "too many dirty pages").cpBeginFut.getUninterruptibly();
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to wait for checkpoint begin.", e);
            }
        }
        if (ASSERTION_ENABLED) {
            CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() + 1);
        }
    }

    @Override
    public boolean checkpointLockIsHeldByThread() {
        return !ASSERTION_ENABLED || this.checkpointLock.isWriteLockedByCurrentThread() || CHECKPOINT_LOCK_HOLD_COUNT.get() > 0;
    }

    private boolean safeToUpdatePageMemories() {
        Collection<DataRegion> memPlcs = this.context().database().dataRegions();
        if (memPlcs == null) {
            return true;
        }
        for (DataRegion memPlc : memPlcs) {
            PageMemoryEx pageMemEx;
            if (!memPlc.config().isPersistenceEnabled() || (pageMemEx = (PageMemoryEx)memPlc.pageMemory()).safeToUpdate()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkpointReadUnlock() {
        Collection<DataRegion> dataRegs;
        if (this.checkpointLock.writeLock().isHeldByCurrentThread()) {
            return;
        }
        this.checkpointLock.readLock().unlock();
        if (this.checkpointer != null && (dataRegs = this.context().database().dataRegions()) != null) {
            for (DataRegion dataReg : dataRegs) {
                PageMemoryEx mem;
                if (!dataReg.config().isPersistenceEnabled() || (mem = (PageMemoryEx)dataReg.pageMemory()) == null || mem.safeToUpdate()) continue;
                this.checkpointer.wakeupForCheckpoint(0L, "too many dirty pages");
                break;
            }
        }
        if (ASSERTION_ENABLED) {
            CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() - 1);
        }
    }

    private void restoreState() throws IgniteCheckedException {
        try {
            CheckpointStatus status = this.readCheckpointStatus();
            this.checkpointReadLock();
            try {
                this.applyLastUpdates(status, false);
            }
            finally {
                this.checkpointReadUnlock();
            }
            this.snapshotMgr.restoreState();
            new IgniteThread(this.cctx.igniteInstanceName(), "db-checkpoint-thread", this.checkpointer).start();
            CheckpointProgressSnapshot chp = this.checkpointer.wakeupForCheckpoint(0L, "node started");
            if (chp != null) {
                chp.cpBeginFut.get();
            }
        }
        catch (StorageException e) {
            throw new IgniteCheckedException(e);
        }
    }

    @Override
    public synchronized Map<Integer, Map<Integer, Long>> reserveHistoryForExchange() {
        assert (this.reservedForExchange == null) : this.reservedForExchange;
        this.reservedForExchange = new HashMap<Integer, Map<Integer, T2<Long, WALPointer>>>();
        Map<Integer, Set<Integer>> parts4CheckpointHistSearch = this.partsForCheckpointHistorySearch();
        Map<Integer, Map<Integer, CheckpointEntry>> lastCheckpointEntry4Grp = this.searchLastCheckpointEntryPerPartition(parts4CheckpointHistSearch);
        HashMap<Integer, Map<Integer, Long>> grpPartsWithCnts = new HashMap<Integer, Map<Integer, Long>>();
        try {
            for (Map.Entry<Integer, Map<Integer, CheckpointEntry>> e : lastCheckpointEntry4Grp.entrySet()) {
                Integer grpId = e.getKey();
                for (Map.Entry<Integer, CheckpointEntry> e0 : e.getValue().entrySet()) {
                    Long partCnt;
                    CheckpointEntry cpEntry = e0.getValue();
                    Integer partId = e0.getKey();
                    if (!this.cctx.wal().reserve(cpEntry.cpMark)) continue;
                    Map<Integer, T2<Long, WALPointer>> grpChpState = this.reservedForExchange.get(grpId);
                    HashMap<Integer, Long> grpCnts = (HashMap<Integer, Long>)grpPartsWithCnts.get(grpId);
                    if (grpChpState == null) {
                        grpChpState = new HashMap<Integer, T2<Long, WALPointer>>();
                        this.reservedForExchange.put(grpId, grpChpState);
                        grpCnts = new HashMap<Integer, Long>();
                        grpPartsWithCnts.put(grpId, grpCnts);
                    }
                    if ((partCnt = cpEntry.partitionCounter(this.cctx, grpId, partId)) != null) {
                        grpChpState.put(partId, new T2<Long, WALPointer>(partCnt, cpEntry.cpMark));
                        grpCnts.put(partId, partCnt);
                        continue;
                    }
                    this.cctx.wal().release(cpEntry.cpMark);
                }
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Error while trying to reserve history", ex);
        }
        return grpPartsWithCnts;
    }

    private Map<Integer, Set<Integer>> partsForCheckpointHistorySearch() {
        HashMap<Integer, Set<Integer>> part4CheckpointHistSearch = new HashMap<Integer, Set<Integer>>();
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal()) continue;
            for (GridDhtLocalPartition part : grp.topology().currentLocalPartitions()) {
                if (part.state() != GridDhtPartitionState.OWNING || part.dataStore().fullSize() <= (long)this.walRebalanceThreshold) continue;
                HashSet<Integer> parts = (HashSet<Integer>)part4CheckpointHistSearch.get(grp.groupId());
                if (parts == null) {
                    parts = new HashSet<Integer>();
                    part4CheckpointHistSearch.put(grp.groupId(), parts);
                }
                parts.add(part.id());
            }
        }
        return part4CheckpointHistSearch;
    }

    @Override
    public synchronized void releaseHistoryForExchange() {
        if (this.reservedForExchange == null) {
            return;
        }
        for (Map.Entry<Integer, Map<Integer, T2<Long, WALPointer>>> e : this.reservedForExchange.entrySet()) {
            for (Map.Entry<Integer, T2<Long, WALPointer>> e0 : e.getValue().entrySet()) {
                try {
                    this.cctx.wal().release((WALPointer)e0.getValue().get2());
                }
                catch (IgniteCheckedException ex) {
                    U.error(this.log, "Could not release history lock", ex);
                }
            }
        }
        this.reservedForExchange = null;
    }

    @Override
    public boolean reserveHistoryForPreloading(int grpId, int partId, long cntr) {
        boolean reserved;
        CheckpointEntry cpEntry = this.searchCheckpointEntry(grpId, partId, cntr);
        if (cpEntry == null) {
            return false;
        }
        WALPointer ptr = cpEntry.cpMark;
        if (ptr == null) {
            return false;
        }
        try {
            reserved = this.cctx.wal().reserve(ptr);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Error while trying to reserve history", e);
            reserved = false;
        }
        if (reserved) {
            this.reservedForPreloading.put(new T2<Integer, Integer>(grpId, partId), new T2<Long, WALPointer>(cntr, ptr));
        }
        return reserved;
    }

    @Override
    public void releaseHistoryForPreloading() {
        for (Map.Entry e : this.reservedForPreloading.entrySet()) {
            try {
                this.cctx.wal().release((WALPointer)((T2)e.getValue()).get2());
            }
            catch (IgniteCheckedException ex) {
                U.error(this.log, "Could not release WAL reservation", ex);
                throw new IgniteException(ex);
            }
        }
        this.reservedForPreloading.clear();
    }

    public Map<T2<Integer, Integer>, T2<Long, WALPointer>> reservedForPreloading() {
        return this.reservedForPreloading;
    }

    @Override
    @Nullable
    public IgniteInternalFuture wakeupForCheckpoint(String reason) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            return cp.wakeupForCheckpoint(0L, reason).cpBeginFut;
        }
        return null;
    }

    @Override
    public void waitForCheckpoint(String reason) throws IgniteCheckedException {
        Checkpointer cp = this.checkpointer;
        if (cp == null) {
            return;
        }
        CheckpointProgressSnapshot progSnapshot = cp.wakeupForCheckpoint(0L, reason);
        GridFutureAdapter fut1 = progSnapshot.cpFinishFut;
        fut1.get();
        if (!progSnapshot.started) {
            return;
        }
        GridFutureAdapter fut2 = cp.wakeupForCheckpoint(0L, reason).cpFinishFut;
        assert (fut1 != fut2);
        fut2.get();
    }

    @Override
    public CheckpointFuture forceCheckpoint(String reason) {
        Checkpointer cp = this.checkpointer;
        if (cp == null) {
            return null;
        }
        return cp.wakeupForCheckpoint(0L, reason);
    }

    private Map<Integer, Map<Integer, CheckpointEntry>> searchLastCheckpointEntryPerPartition(Map<Integer, Set<Integer>> part4reserve) {
        HashMap<Integer, Map<Integer, CheckpointEntry>> res = new HashMap<Integer, Map<Integer, CheckpointEntry>>();
        if (F.isEmpty(part4reserve)) {
            return res;
        }
        for (Long cpTs : this.checkpointHist.checkpoints()) {
            CheckpointEntry chpEntry = null;
            try {
                chpEntry = this.checkpointHist.entry(cpTs);
                Map<Integer, CheckpointEntry.GroupState> grpsState = chpEntry.groupState(this.cctx);
                if (F.isEmpty(grpsState)) {
                    res.clear();
                    continue;
                }
                for (Map.Entry<Integer, Set<Integer>> grps : part4reserve.entrySet()) {
                    Integer grpId = grps.getKey();
                    HashMap<Integer, CheckpointEntry> partToCheckPntEntry = (HashMap<Integer, CheckpointEntry>)res.get(grpId);
                    CheckpointEntry.GroupState grpState = grpsState.get(grpId);
                    if (grpState == null) {
                        res.remove(grpId);
                        continue;
                    }
                    if (partToCheckPntEntry == null) {
                        partToCheckPntEntry = new HashMap<Integer, CheckpointEntry>();
                        res.put(grpId, partToCheckPntEntry);
                    }
                    for (Integer partId : grps.getValue()) {
                        int idx = grpState.indexByPartition(partId);
                        if (idx < 0) {
                            partToCheckPntEntry.remove(partId);
                            continue;
                        }
                        if (partToCheckPntEntry.containsKey(partId)) continue;
                        partToCheckPntEntry.put(partId, chpEntry);
                    }
                }
            }
            catch (IgniteCheckedException ex) {
                String msg = chpEntry != null ? ", chpId=" + chpEntry.cpId + " ptr=" + chpEntry.cpMark + " ts=" + chpEntry.cpTs : "";
                U.error(this.log, "Failed to read checkpoint entry" + msg, ex);
                res.clear();
            }
        }
        return res;
    }

    @Nullable
    public WALPointer searchPartitionCounter(int grpId, int part, @Nullable Long partCntrSince) {
        CheckpointEntry entry = this.searchCheckpointEntry(grpId, part, partCntrSince);
        if (entry == null) {
            return null;
        }
        return entry.cpMark;
    }

    @Nullable
    private CheckpointEntry searchCheckpointEntry(int grpId, int part, @Nullable Long partCntrSince) {
        boolean hasGap = false;
        CheckpointEntry first = null;
        for (Long cpTs : this.checkpointHist.checkpoints()) {
            try {
                CheckpointEntry entry = this.checkpointHist.entry(cpTs);
                Long foundCntr = entry.partitionCounter(this.cctx, grpId, part);
                if (foundCntr != null) {
                    if (partCntrSince == null) {
                        if (hasGap) {
                            first = entry;
                            hasGap = false;
                        }
                        if (first != null) continue;
                        first = entry;
                        continue;
                    }
                    if (foundCntr <= partCntrSince) {
                        first = entry;
                        hasGap = false;
                        continue;
                    }
                    return hasGap ? null : first;
                }
                hasGap = true;
            }
            catch (IgniteCheckedException ignore) {
                hasGap = true;
            }
        }
        return hasGap ? null : first;
    }

    public CheckpointHistory checkpointHistory() {
        return this.checkpointHist;
    }

    public File checkpointDirectory() {
        return this.cpDir;
    }

    public void addCheckpointListener(DbCheckpointListener lsnr) {
        this.lsnrs.add(lsnr);
    }

    public void removeCheckpointListener(DbCheckpointListener lsnr) {
        this.lsnrs.remove(lsnr);
    }

    private CheckpointStatus readCheckpointStatus() throws IgniteCheckedException {
        File[] files;
        long lastStartTs = 0L;
        long lastEndTs = 0L;
        UUID startId = CheckpointStatus.NULL_UUID;
        UUID endId = CheckpointStatus.NULL_UUID;
        File startFile = null;
        File endFile = null;
        WALPointer startPtr = CheckpointStatus.NULL_PTR;
        WALPointer endPtr = CheckpointStatus.NULL_PTR;
        File dir = this.cpDir;
        if (!dir.exists()) {
            Object[] files2 = dir.listFiles();
            if (files2 != null && files2.length > 0) {
                this.log.warning("Read checkpoint status: cpDir.exists() is false, cpDir.listFiles() is: " + Arrays.toString(files2));
            }
            if (Files.exists(dir.toPath(), new LinkOption[0])) {
                this.log.warning("Read checkpoint status: cpDir.exists() is false, Files.exists(cpDir) is true.");
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Read checkpoint status: checkpoint directory is not found.");
            }
            return new CheckpointStatus(0L, startId, startPtr, endId, endPtr);
        }
        for (File file : files = dir.listFiles()) {
            Matcher matcher = CP_FILE_NAME_PATTERN.matcher(file.getName());
            if (!matcher.matches()) continue;
            long ts = Long.parseLong(matcher.group(1));
            UUID id = UUID.fromString(matcher.group(2));
            CheckpointEntryType type = CheckpointEntryType.valueOf(matcher.group(3));
            if (type == CheckpointEntryType.START && ts > lastStartTs) {
                lastStartTs = ts;
                startId = id;
                startFile = file;
                continue;
            }
            if (type != CheckpointEntryType.END || ts <= lastEndTs) continue;
            lastEndTs = ts;
            endId = id;
            endFile = file;
        }
        ByteBuffer buf = ByteBuffer.allocate(20);
        buf.order(ByteOrder.nativeOrder());
        if (startFile != null) {
            startPtr = this.readPointer(startFile, buf);
        }
        if (endFile != null) {
            endPtr = this.readPointer(endFile, buf);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Read checkpoint status [startMarker=" + startFile + ", endMarker=" + endFile + ']');
        }
        return new CheckpointStatus(lastStartTs, startId, startPtr, endId, endPtr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WALPointer readPointer(File cpMarkerFile, ByteBuffer buf) throws IgniteCheckedException {
        buf.position(0);
        try (FileChannel ch = FileChannel.open(cpMarkerFile.toPath(), StandardOpenOption.READ);){
            ch.read(buf);
            buf.flip();
            FileWALPointer fileWALPointer = new FileWALPointer(buf.getLong(), buf.getInt(), buf.getInt());
            return fileWALPointer;
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to read checkpoint pointer from marker file: " + cpMarkerFile.getAbsolutePath(), e);
        }
    }

    @Nullable
    private WALPointer restoreMemory(CheckpointStatus status) throws IgniteCheckedException {
        return this.restoreMemory(status, false, (PageMemoryEx)this.metaStorage.pageMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private WALPointer restoreMemory(CheckpointStatus status, boolean metastoreOnly, PageMemoryEx storePageMem) throws IgniteCheckedException {
        if (!GridCacheDatabaseSharedManager.$assertionsDisabled && metastoreOnly && storePageMem == null) {
            throw new AssertionError();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Checking memory state [lastValidPos=" + CheckpointStatus.access$200(status) + ", lastMarked=" + CheckpointStatus.access$2200(status) + ", lastCheckpointId=" + CheckpointStatus.access$2300(status) + ']');
        }
        if (apply = status.needRestoreMemory()) {
            U.quietAndWarn(this.log, "Ignite node stopped in the middle of checkpoint. Will restore memory state and finish checkpoint on node start.");
            this.cctx.pageStore().beginRecover();
        } else {
            this.cctx.wal().allowCompressionUntil(CheckpointStatus.access$2200(status));
        }
        start = U.currentTimeMillis();
        applied = 0;
        lastRead = null;
        ignoreGrps = metastoreOnly != false ? Collections.emptySet() : F.concat(false, this.initiallyGlobalWalDisabledGrps, this.initiallyLocalWalDisabledGrps);
        it = this.cctx.wal().replay(CheckpointStatus.access$200(status));
        var11_10 = null;
lbl16:
        // 7 sources

        try {
            block27: while (it.hasNextX()) {
                tup = (IgniteBiTuple)it.nextX();
                rec = (WALRecord)tup.get2();
                lastRead = (WALPointer)tup.get1();
                switch (13.$SwitchMap$org$apache$ignite$internal$pagemem$wal$record$WALRecord$RecordType[rec.type().ordinal()]) {
                    case 1: {
                        cpRec = (CheckpointRecord)rec;
                        if (!F.eq(cpRec.checkpointId(), CheckpointStatus.access$2300(status))) ** GOTO lbl28
                        this.log.info("Found last checkpoint marker [cpId=" + cpRec.checkpointId() + ", pos=" + tup.get1() + ']');
                        apply = false;
                        ** GOTO lbl16
lbl28:
                        // 1 sources

                        if (F.eq(cpRec.checkpointId(), CheckpointStatus.access$2400(status))) continue block27;
                        U.warn(this.log, "Found unexpected checkpoint marker, skipping [cpId=" + cpRec.checkpointId() + ", expCpId=" + CheckpointStatus.access$2300(status) + ", pos=" + tup.get1() + ']');
                        ** GOTO lbl16
                    }
                    case 2: {
                        if (!apply) continue block27;
                        pageRec = (PageSnapshot)rec;
                        grpId = pageRec.fullPageId().groupId();
                        if (metastoreOnly && grpId != MetaStorage.METASTORAGE_CACHE_ID || ignoreGrps.contains(grpId)) continue block27;
                        pageId = pageRec.fullPageId().pageId();
                        pageMem = grpId == MetaStorage.METASTORAGE_CACHE_ID ? storePageMem : this.getPageMemoryForCacheGroup(grpId);
                        page = pageMem.acquirePage(grpId, pageId, true);
                        try {
                            pageAddr = pageMem.writeLock(grpId, pageId, page);
                            try {
                                PageUtils.putBytes(pageAddr, 0, pageRec.pageData());
                            }
                            finally {
                                pageMem.writeUnlock(grpId, pageId, page, null, true, true);
                            }
                        }
                        finally {
                            pageMem.releasePage(grpId, pageId, page);
                        }
                        ++applied;
                        ** GOTO lbl16
                    }
                    case 3: {
                        metaStateRecord = (PartitionMetaStateRecord)rec;
                        grpId = metaStateRecord.groupId();
                        if (metastoreOnly && grpId != MetaStorage.METASTORAGE_CACHE_ID || ignoreGrps.contains(grpId)) continue block27;
                        partId = metaStateRecord.partitionId();
                        state = GridDhtPartitionState.fromOrdinal(metaStateRecord.state());
                        if (state != null && state != GridDhtPartitionState.EVICTED) ** GOTO lbl61
                        this.schedulePartitionDestroy(grpId, partId);
                        ** GOTO lbl16
lbl61:
                        // 1 sources

                        this.cancelOrWaitPartitionDestroy(grpId, partId);
                        ** GOTO lbl16
                    }
                    case 4: {
                        destroyRecord = (PartitionDestroyRecord)rec;
                        grpId = destroyRecord.groupId();
                        if (metastoreOnly && grpId != MetaStorage.METASTORAGE_CACHE_ID || ignoreGrps.contains(grpId)) continue block27;
                        pageMem = grpId == MetaStorage.METASTORAGE_CACHE_ID ? storePageMem : this.getPageMemoryForCacheGroup(grpId);
                        pageMem.invalidate(grpId, destroyRecord.partitionId());
                        this.schedulePartitionDestroy(grpId, destroyRecord.partitionId());
                        ** GOTO lbl16
                    }
                }
                if (!apply || !(rec instanceof PageDeltaRecord)) continue;
                r = (PageDeltaRecord)rec;
                grpId = r.groupId();
                if (metastoreOnly && grpId != MetaStorage.METASTORAGE_CACHE_ID || ignoreGrps.contains(grpId)) continue;
                pageId = r.pageId();
                pageMem = grpId == MetaStorage.METASTORAGE_CACHE_ID ? storePageMem : this.getPageMemoryForCacheGroup(grpId);
                page = pageMem.acquirePage(grpId, pageId, true);
                try {
                    pageAddr = pageMem.writeLock(grpId, pageId, page);
                    try {
                        r.applyDelta(pageMem, pageAddr);
                    }
                    finally {
                        pageMem.writeUnlock(grpId, pageId, page, null, true, true);
                    }
                }
                finally {
                    pageMem.releasePage(grpId, pageId, page);
                }
                ++applied;
            }
        }
        catch (Throwable var12_13) {
            var11_10 = var12_13;
            throw var12_13;
        }
        finally {
            if (it != null) {
                if (var11_10 != null) {
                    try {
                        it.close();
                    }
                    catch (Throwable var12_12) {
                        var11_10.addSuppressed(var12_12);
                    }
                } else {
                    it.close();
                }
            }
        }
        if (metastoreOnly) {
            return null;
        }
        if (status.needRestoreMemory()) {
            if (apply) {
                throw new StorageException("Failed to restore memory state (checkpoint marker is present on disk, but checkpoint record is missed in WAL) [cpStatus=" + status + ", lastRead=" + lastRead + "]");
            }
            this.log.info("Finished applying memory changes [changesApplied=" + applied + ", time=" + (U.currentTimeMillis() - start) + "ms]");
            if (applied > 0) {
                this.finalizeCheckpointOnRecovery(CheckpointStatus.access$2500(status), CheckpointStatus.access$2300(status), CheckpointStatus.access$2200(status));
            }
        }
        CheckpointHistory.access$2600(this.checkpointHist, this.cpDir);
        if (lastRead == null) {
            return null;
        }
        v0 = lastRead.next();
        return v0;
    }

    private PageMemoryEx getPageMemoryForCacheGroup(int grpId) throws IgniteCheckedException {
        GridCacheSharedContext sharedCtx = this.context();
        CacheGroupDescriptor desc = sharedCtx.cache().cacheGroupDescriptors().get(grpId);
        if (desc == null) {
            throw new IgniteCheckedException("Failed to find cache group descriptor [grpId=" + grpId + ']');
        }
        String memPlcName = desc.config().getDataRegionName();
        return (PageMemoryEx)sharedCtx.database().dataRegion(memPlcName).pageMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyUpdatesOnRecovery(@Nullable WALIterator it, IgnitePredicate<IgniteBiTuple<WALPointer, WALRecord>> recPredicate, IgnitePredicate<DataEntry> entryPredicate, Map<T2<Integer, Integer>, T2<Integer, Long>> partStates) throws IgniteCheckedException {
        if (it != null) {
            block12: while (it.hasNextX()) {
                IgniteBiTuple next = (IgniteBiTuple)it.nextX();
                WALRecord rec = (WALRecord)next.get2();
                if (!recPredicate.apply(next)) break;
                switch (rec.type()) {
                    case DATA_RECORD: {
                        this.checkpointReadLock();
                        try {
                            DataRecord dataRec = (DataRecord)rec;
                            for (DataEntry dataEntry : dataRec.writeEntries()) {
                                if (!entryPredicate.apply(dataEntry)) continue;
                                this.checkpointReadLock();
                                try {
                                    int cacheId = dataEntry.cacheId();
                                    GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
                                    if (cacheCtx != null) {
                                        this.applyUpdate(cacheCtx, dataEntry);
                                        continue;
                                    }
                                    if (this.log == null) continue;
                                    this.log.warning("Cache (cacheId=" + cacheId + ") is not started, can't apply updates.");
                                }
                                finally {
                                    this.checkpointReadUnlock();
                                }
                            }
                            continue block12;
                        }
                        finally {
                            this.checkpointReadUnlock();
                            continue block12;
                        }
                    }
                }
            }
        }
        this.checkpointReadLock();
        try {
            this.restorePartitionStates(partStates, null);
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLastUpdates(CheckpointStatus status, boolean metastoreOnly) throws IgniteCheckedException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Applying lost cache updates since last checkpoint record [lastMarked=" + status.startPtr + ", lastCheckpointId=" + status.cpStartId + ']');
        }
        if (!metastoreOnly) {
            this.cctx.kernalContext().query().skipFieldLookup(true);
        }
        long start = U.currentTimeMillis();
        int applied = 0;
        Set ignoreGrps = metastoreOnly ? Collections.emptySet() : F.concat(false, this.initiallyGlobalWalDisabledGrps, this.initiallyLocalWalDisabledGrps);
        try (WALIterator it = this.cctx.wal().replay(status.startPtr);){
            HashMap<T2<Integer, Integer>, T2<Integer, Long>> partStates = new HashMap<T2<Integer, Integer>, T2<Integer, Long>>();
            while (it.hasNextX()) {
                IgniteBiTuple next = (IgniteBiTuple)it.nextX();
                WALRecord rec = (WALRecord)next.get2();
                switch (rec.type()) {
                    case DATA_RECORD: {
                        if (metastoreOnly) break;
                        DataRecord dataRec = (DataRecord)rec;
                        for (DataEntry dataEntry : dataRec.writeEntries()) {
                            int cacheId = dataEntry.cacheId();
                            int grpId = this.cctx.cache().cacheDescriptor(cacheId).groupId();
                            if (ignoreGrps.contains(grpId)) continue;
                            GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
                            this.applyUpdate(cacheCtx, dataEntry);
                            ++applied;
                        }
                        break;
                    }
                    case PART_META_UPDATE_STATE: {
                        PartitionMetaStateRecord metaStateRecord;
                        if (metastoreOnly || ignoreGrps.contains((metaStateRecord = (PartitionMetaStateRecord)rec).groupId())) break;
                        partStates.put(new T2<Integer, Integer>(metaStateRecord.groupId(), metaStateRecord.partitionId()), new T2<Integer, Long>(Integer.valueOf(metaStateRecord.state()), metaStateRecord.updateCounter()));
                        break;
                    }
                    case METASTORE_DATA_RECORD: {
                        MetastoreDataRecord metastoreDataRecord = (MetastoreDataRecord)rec;
                        this.metaStorage.applyUpdate(metastoreDataRecord.key(), metastoreDataRecord.value());
                        break;
                    }
                    case META_PAGE_UPDATE_NEXT_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID: {
                        if (metastoreOnly) break;
                        PageDeltaRecord rec0 = (PageDeltaRecord)rec;
                        PageMemoryEx pageMem = this.getPageMemoryForCacheGroup(rec0.groupId());
                        long page = pageMem.acquirePage(rec0.groupId(), rec0.pageId(), true);
                        try {
                            long addr = pageMem.writeLock(rec0.groupId(), rec0.pageId(), page, true);
                            try {
                                rec0.applyDelta(pageMem, addr);
                                break;
                            }
                            finally {
                                pageMem.writeUnlock(rec0.groupId(), rec0.pageId(), page, null, true, true);
                            }
                        }
                        finally {
                            pageMem.releasePage(rec0.groupId(), rec0.pageId(), page);
                        }
                    }
                }
            }
            if (!metastoreOnly) {
                this.restorePartitionStates(partStates, null);
            }
        }
        finally {
            if (!metastoreOnly) {
                this.cctx.kernalContext().query().skipFieldLookup(false);
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Finished applying WAL changes [updatesApplied=" + applied + ", time=" + (U.currentTimeMillis() - start) + "ms]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePartitionStates(Map<T2<Integer, Integer>, T2<Integer, Long>> partStates, @Nullable Set<Integer> onlyForGroups) throws IgniteCheckedException {
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal() || !grp.affinityNode() || !grp.dataRegion().config().isPersistenceEnabled() || onlyForGroups != null && !onlyForGroups.contains(grp.groupId())) continue;
            int grpId = grp.groupId();
            PageMemoryEx pageMem = (PageMemoryEx)grp.dataRegion().pageMemory();
            for (int i = 0; i < grp.affinity().partitions(); ++i) {
                GridDhtLocalPartition part;
                T2<Integer, Long> restore = partStates.get(new T2<Integer, Integer>(grpId, i));
                if (this.storeMgr.exists(grpId, i)) {
                    this.storeMgr.ensure(grpId, i);
                    if (this.storeMgr.pages(grpId, i) <= 1) continue;
                    part = grp.topology().forceCreatePartition(i);
                    assert (part != null);
                    grp.offheap().onPartitionInitialCounterUpdated(i, 0L);
                    this.checkpointReadLock();
                    try {
                        long partMetaId = pageMem.partitionMetaPageId(grpId, i);
                        long partMetaPage = pageMem.acquirePage(grpId, partMetaId);
                        try {
                            long pageAddr = pageMem.writeLock(grpId, partMetaId, partMetaPage);
                            boolean changed = false;
                            try {
                                PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
                                if (restore != null) {
                                    int stateId = (Integer)restore.get1();
                                    io.setPartitionState(pageAddr, (byte)stateId);
                                    changed = this.updateState(part, stateId);
                                    if (stateId == GridDhtPartitionState.OWNING.ordinal() || stateId == GridDhtPartitionState.MOVING.ordinal() && part.initialUpdateCounter() < (Long)restore.get2()) {
                                        part.initialUpdateCounter((Long)restore.get2());
                                        changed = true;
                                    }
                                    continue;
                                }
                                this.updateState(part, io.getPartitionState(pageAddr));
                                continue;
                            }
                            finally {
                                pageMem.writeUnlock(grpId, partMetaId, partMetaPage, null, changed);
                            }
                        }
                        finally {
                            pageMem.releasePage(grpId, partMetaId, partMetaPage);
                        }
                    }
                    finally {
                        this.checkpointReadUnlock();
                    }
                }
                if (restore == null) continue;
                part = grp.topology().forceCreatePartition(i);
                assert (part != null);
                grp.offheap().onPartitionInitialCounterUpdated(i, 0L);
                this.updateState(part, (Integer)restore.get1());
            }
            grp.topology().afterStateRestored(grp.topology().lastTopologyChangeVersion());
        }
    }

    public void onWalTruncated(WALPointer highBound) {
        this.checkpointHist.onWalTruncated(highBound);
    }

    private boolean updateState(GridDhtLocalPartition part, int stateId) {
        if (stateId != -1) {
            GridDhtPartitionState state = GridDhtPartitionState.fromOrdinal(stateId);
            assert (state != null);
            part.restoreState(state == GridDhtPartitionState.EVICTED ? GridDhtPartitionState.RENTING : state);
            return true;
        }
        return false;
    }

    private void applyUpdate(GridCacheContext cacheCtx, DataEntry dataEntry) throws IgniteCheckedException {
        int partId = dataEntry.partitionId();
        if (partId == -1) {
            partId = cacheCtx.affinity().partition(dataEntry.key());
        }
        GridDhtLocalPartition locPart = cacheCtx.topology().forceCreatePartition(partId);
        switch (dataEntry.op()) {
            case CREATE: 
            case UPDATE: {
                cacheCtx.offheap().update(cacheCtx, dataEntry.key(), dataEntry.value(), dataEntry.writeVersion(), 0L, locPart, null);
                if (dataEntry.partitionCounter() == 0L) break;
                cacheCtx.offheap().onPartitionInitialCounterUpdated(partId, dataEntry.partitionCounter());
                break;
            }
            case DELETE: {
                cacheCtx.offheap().remove(cacheCtx, dataEntry.key(), partId, locPart);
                if (dataEntry.partitionCounter() == 0L) break;
                cacheCtx.offheap().onPartitionInitialCounterUpdated(partId, dataEntry.partitionCounter());
                break;
            }
            case READ: {
                break;
            }
            default: {
                throw new IgniteCheckedException("Invalid operation for WAL entry update: " + (Object)((Object)dataEntry.op()));
            }
        }
    }

    private void finalizeCheckpointOnRecovery(long cpTs, UUID cpId, WALPointer walPtr) throws IgniteCheckedException {
        assert (cpTs != 0L);
        ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(this.pageSize());
        long start = System.currentTimeMillis();
        Collection<DataRegion> memPolicies = this.context().database().dataRegions();
        ArrayList<IgniteBiTuple<Object, GridMultiCollectionWrapper<FullPageId>>> cpEntities = new ArrayList<IgniteBiTuple<Object, GridMultiCollectionWrapper<FullPageId>>>(memPolicies.size());
        for (DataRegion memPlc : memPolicies) {
            if (!memPlc.config().isPersistenceEnabled()) continue;
            PageMemoryEx pageMem = (PageMemoryEx)memPlc.pageMemory();
            cpEntities.add(new IgniteBiTuple<Object, GridMultiCollectionWrapper<FullPageId>>(pageMem, pageMem.beginCheckpoint()));
        }
        tmpWriteBuf.order(ByteOrder.nativeOrder());
        HashSet<PageStore> updStores = new HashSet<PageStore>();
        int cpPagesCnt = 0;
        for (IgniteBiTuple igniteBiTuple : cpEntities) {
            PageMemoryEx pageMem = (PageMemoryEx)igniteBiTuple.get1();
            Collection cpPages = (Collection)igniteBiTuple.get2();
            cpPagesCnt += cpPages.size();
            for (FullPageId fullPageId : cpPages) {
                tmpWriteBuf.rewind();
                Integer tag = pageMem.getForCheckpoint(fullPageId, tmpWriteBuf, null);
                if (tag == null) continue;
                tmpWriteBuf.rewind();
                PageStore store = this.storeMgr.writeInternal(fullPageId.groupId(), fullPageId.pageId(), tmpWriteBuf, tag, true);
                tmpWriteBuf.rewind();
                updStores.add(store);
            }
        }
        long written = U.currentTimeMillis();
        for (PageStore updStore : updStores) {
            updStore.sync();
        }
        long fsync = U.currentTimeMillis();
        for (IgniteBiTuple igniteBiTuple : cpEntities) {
            ((PageMemoryEx)igniteBiTuple.get1()).finishCheckpoint();
        }
        this.writeCheckpointEntry(tmpWriteBuf, cpTs, cpId, walPtr, null, CheckpointEntryType.END);
        this.cctx.pageStore().finishRecover();
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("Checkpoint finished [cpId=%s, pages=%d, markPos=%s, pagesWrite=%dms, fsync=%dms, total=%dms]", cpId, cpPagesCnt, walPtr, written - start, fsync - written, fsync - start));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CheckpointEntry writeCheckpointEntry(ByteBuffer tmpWriteBuf, long cpTs, UUID cpId, WALPointer ptr, CheckpointRecord rec, CheckpointEntryType type) throws IgniteCheckedException {
        assert (ptr instanceof FileWALPointer);
        FileWALPointer filePtr = (FileWALPointer)ptr;
        String fileName = GridCacheDatabaseSharedManager.checkpointFileName(cpTs, cpId, type);
        try (FileChannel ch = FileChannel.open(Paths.get(this.cpDir.getAbsolutePath(), fileName), StandardOpenOption.CREATE_NEW, StandardOpenOption.APPEND);){
            tmpWriteBuf.rewind();
            tmpWriteBuf.putLong(filePtr.index());
            tmpWriteBuf.putInt(filePtr.fileOffset());
            tmpWriteBuf.putInt(filePtr.length());
            tmpWriteBuf.flip();
            ch.write(tmpWriteBuf);
            tmpWriteBuf.clear();
            if (!this.skipSync) {
                ch.force(true);
            }
            CheckpointEntry checkpointEntry = this.createCheckPointEntry(cpTs, ptr, cpId, rec, type);
            return checkpointEntry;
        }
        catch (IOException e) {
            throw new IgniteCheckedException(e);
        }
    }

    @Override
    public AtomicInteger writtenPagesCounter() {
        return this.writtenPagesCntr;
    }

    @Override
    public AtomicInteger syncedPagesCounter() {
        return this.syncedPagesCntr;
    }

    @Override
    public AtomicInteger evictedPagesCntr() {
        return this.evictedPagesCntr;
    }

    @Override
    public int currentCheckpointPagesCount() {
        return this.currCheckpointPagesCnt;
    }

    private static String checkpointFileName(long cpTs, UUID cpId, CheckpointEntryType type) {
        return cpTs + "-" + cpId + "-" + (Object)((Object)type) + ".bin";
    }

    public void setThreadBuf(ThreadLocal<ByteBuffer> threadBuf) {
        this.threadBuf = threadBuf;
    }

    private CheckpointEntry createCheckPointEntry(long cpTs, WALPointer ptr, UUID cpId, @Nullable CheckpointRecord rec, CheckpointEntryType type) {
        assert (cpTs > 0L);
        assert (ptr != null);
        assert (cpId != null);
        assert (type != null);
        if (type != CheckpointEntryType.START) {
            return null;
        }
        Map<Integer, CacheState> cacheGrpStates = null;
        if (this.checkpointHist.histMap.size() + 1 < this.maxCpHistMemSize && rec != null) {
            cacheGrpStates = rec.cacheGroupStates();
        }
        return new CheckpointEntry(cpTs, ptr, cpId, cacheGrpStates);
    }

    public void schedulePartitionDestroy(int grpId, int partId) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.schedulePartitionDestroy(this.cctx.cache().cacheGroup(grpId), grpId, partId);
        }
    }

    public void cancelOrWaitPartitionDestroy(int grpId, int partId) throws IgniteCheckedException {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.cancelOrWaitPartitionDestroy(grpId, partId);
        }
    }

    private GridMultiCollectionWrapper<FullPageId> splitAndSortCpPagesIfNeeded(IgniteBiTuple<Collection<GridMultiCollectionWrapper<FullPageId>>, Integer> cpPagesTuple) {
        int cpThreads;
        List<Object> cpPagesList = new ArrayList<FullPageId>(cpPagesTuple.get2());
        for (GridMultiCollectionWrapper<FullPageId> col : cpPagesTuple.get1()) {
            for (int i = 0; i < col.collectionsSize(); ++i) {
                cpPagesList.addAll(col.innerCollection(i));
            }
        }
        if (this.persistenceCfg.getCheckpointWriteOrder() == CheckpointWriteOrder.SEQUENTIAL) {
            FullPageId[] objects = cpPagesList.toArray(new FullPageId[cpPagesList.size()]);
            Arrays.parallelSort(objects, new Comparator<FullPageId>(){

                @Override
                public int compare(FullPageId o1, FullPageId o2) {
                    int cmp = Long.compare(o1.groupId(), o2.groupId());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return Long.compare(PageIdUtils.effectivePageId(o1.pageId()), PageIdUtils.effectivePageId(o2.pageId()));
                }
            });
            cpPagesList = Arrays.asList(objects);
        }
        int pagesSubLists = (cpThreads = this.persistenceCfg.getCheckpointThreads()) == 1 ? 1 : cpThreads * 4;
        Collection[] pagesSubListArr = new Collection[pagesSubLists];
        for (int i = 0; i < pagesSubLists; ++i) {
            int totalSize = cpPagesList.size();
            int from = totalSize * i / pagesSubLists;
            int to = totalSize * (i + 1) / pagesSubLists;
            pagesSubListArr[i] = cpPagesList.subList(from, to);
        }
        return new GridMultiCollectionWrapper<FullPageId>(pagesSubListArr);
    }

    @Override
    public DataStorageMetrics persistentStoreMetrics() {
        return new DataStorageMetricsSnapshot(this.persStoreMetrics);
    }

    public DataStorageMetricsImpl persistentStoreMetricsImpl() {
        return this.persStoreMetrics;
    }

    @Override
    public MetaStorage metaStorage() {
        return this.metaStorage;
    }

    @Override
    public boolean walEnabled(int grpId, boolean local) {
        if (local) {
            return !this.initiallyLocalWalDisabledGrps.contains(grpId);
        }
        return !this.initiallyGlobalWalDisabledGrps.contains(grpId);
    }

    @Override
    public void walEnabled(int grpId, boolean enabled, boolean local) {
        String key = GridCacheDatabaseSharedManager.walGroupIdToKey(grpId, local);
        this.checkpointReadLock();
        try {
            if (enabled) {
                this.metaStorage.remove(key);
            } else {
                this.metaStorage.write(key, Boolean.valueOf(true));
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to write cache group WAL state [grpId=" + grpId + ", enabled=" + enabled + ']', e);
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    private void fillWalDisabledGroups() {
        MetaStorage meta = this.cctx.database().metaStorage();
        try {
            Set<String> keys = meta.readForPredicate(WAL_KEY_PREFIX_PRED).keySet();
            if (keys.isEmpty()) {
                return;
            }
            for (String key : keys) {
                T2<Integer, Boolean> t2 = GridCacheDatabaseSharedManager.walKeyToGroupIdAndLocalFlag(key);
                if (((Boolean)t2.get2()).booleanValue()) {
                    this.initiallyLocalWalDisabledGrps.add((Integer)t2.get1());
                    continue;
                }
                this.initiallyGlobalWalDisabledGrps.add((Integer)t2.get1());
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to read cache groups WAL state.", e);
        }
    }

    private static String walGroupIdToKey(int grpId, boolean local) {
        if (local) {
            return WAL_LOCAL_KEY_PREFIX + grpId;
        }
        return WAL_GLOBAL_KEY_PREFIX + grpId;
    }

    private static T2<Integer, Boolean> walKeyToGroupIdAndLocalFlag(String key) {
        if (key.startsWith(WAL_LOCAL_KEY_PREFIX)) {
            return new T2<Integer, Boolean>(Integer.parseInt(key.substring(WAL_LOCAL_KEY_PREFIX.length())), true);
        }
        return new T2<Integer, Boolean>(Integer.parseInt(key.substring(WAL_GLOBAL_KEY_PREFIX.length())), false);
    }

    public static class FileLockHolder
    implements AutoCloseable {
        private static final String lockFileName = "lock";
        private File file;
        private RandomAccessFile lockFile;
        private FileLock lock;
        @NotNull
        private GridKernalContext ctx;
        private IgniteLogger log;

        public FileLockHolder(String path, @NotNull GridKernalContext ctx, IgniteLogger log) {
            try {
                this.file = Paths.get(path, lockFileName).toFile();
                this.lockFile = new RandomAccessFile(this.file, "rw");
                this.ctx = ctx;
                this.log = log;
            }
            catch (IOException e) {
                throw new IgniteException(e);
            }
        }

        public void tryLock(long lockWaitTimeMillis) throws IgniteCheckedException {
            String failMsg;
            ClusterNode node;
            assert (this.lockFile != null);
            FileChannel ch = this.lockFile.getChannel();
            SB sb = new SB();
            sb.a("[").a(this.ctx.localNodeId().toString()).a("]");
            GridDiscoveryManager discovery = this.ctx.discovery();
            if (discovery != null && (node = discovery.localNode()) != null) {
                sb.a(node.addresses());
            }
            sb.a("[");
            Iterator<GridPortRecord> it = this.ctx.ports().records().iterator();
            while (it.hasNext()) {
                GridPortRecord rec = it.next();
                sb.a((Object)rec.protocol()).a(":").a(rec.port());
                if (!it.hasNext()) continue;
                sb.a(", ");
            }
            sb.a("]");
            try {
                String content = null;
                int i = 0;
                while ((long)i < lockWaitTimeMillis) {
                    try {
                        this.lock = ch.tryLock(0L, 1L, false);
                        if (this.lock != null && this.lock.isValid()) {
                            this.writeContent(sb.toString());
                            return;
                        }
                    }
                    catch (OverlappingFileLockException ignore) {
                        if (content == null) {
                            content = this.readContent();
                        }
                        this.log.warning("Failed to acquire file lock (local nodeId:" + this.ctx.localNodeId() + ", already locked by " + content + "), will try again in 1s: " + this.file.getAbsolutePath());
                    }
                    U.sleep(1000L);
                    i += 1000;
                }
                if (content == null) {
                    content = this.readContent();
                }
                failMsg = "Failed to acquire file lock during " + lockWaitTimeMillis / 1000L + " sec, (locked by " + content + "): " + this.file.getAbsolutePath();
            }
            catch (Exception e) {
                throw new IgniteCheckedException(e);
            }
            if (failMsg != null) {
                throw new IgniteCheckedException(failMsg);
            }
        }

        private void writeContent(String content) throws IOException {
            FileChannel ch = this.lockFile.getChannel();
            byte[] bytes = content.getBytes();
            ByteBuffer buf = ByteBuffer.allocate(bytes.length);
            buf.put(bytes);
            buf.flip();
            ch.write(buf, 1L);
            ch.force(false);
        }

        private String readContent() throws IOException {
            FileChannel ch = this.lockFile.getChannel();
            ByteBuffer buf = ByteBuffer.allocate((int)(ch.size() - 1L));
            ch.read(buf, 1L);
            String content = new String(buf.array());
            buf.clear();
            return content;
        }

        public void release() {
            U.releaseQuiet(this.lock);
        }

        @Override
        public void close() {
            U.closeQuiet(this.lockFile);
        }

        private String lockPath() {
            return this.file.getAbsolutePath();
        }
    }

    private static class CheckpointEntry {
        private long cpTs;
        private WALPointer cpMark;
        private UUID cpId;
        private volatile SoftReference<GroupStateLazyStore> grpStateLazyStore;

        private CheckpointEntry(long cpTs, WALPointer cpMark, UUID cpId, @Nullable Map<Integer, CacheState> cacheGrpStates) {
            this.cpTs = cpTs;
            this.cpMark = cpMark;
            this.cpId = cpId;
            this.grpStateLazyStore = new SoftReference<GroupStateLazyStore>(new GroupStateLazyStore(cacheGrpStates));
        }

        private long checkpointTimestamp() {
            return this.cpTs;
        }

        private UUID checkpointId() {
            return this.cpId;
        }

        private WALPointer checkpointMark() {
            return this.cpMark;
        }

        private String startFile() {
            return GridCacheDatabaseSharedManager.checkpointFileName(this.cpTs, this.cpId, CheckpointEntryType.START);
        }

        private String endFile() {
            return GridCacheDatabaseSharedManager.checkpointFileName(this.cpTs, this.cpId, CheckpointEntryType.END);
        }

        public Map<Integer, GroupState> groupState(GridCacheSharedContext cctx) throws IgniteCheckedException {
            GroupStateLazyStore store = this.initIfNeeded(cctx);
            return store.grpStates;
        }

        private GroupStateLazyStore initIfNeeded(GridCacheSharedContext cctx) throws IgniteCheckedException {
            GroupStateLazyStore store = this.grpStateLazyStore.get();
            if (store == null) {
                store = new GroupStateLazyStore();
                this.grpStateLazyStore = new SoftReference<GroupStateLazyStore>(store);
            }
            store.initIfNeeded(cctx, this.cpMark);
            return store;
        }

        private Long partitionCounter(GridCacheSharedContext cctx, int grpId, int part) {
            GroupStateLazyStore store;
            try {
                store = this.initIfNeeded(cctx);
            }
            catch (IgniteCheckedException e) {
                return null;
            }
            return store.partitionCounter(grpId, part);
        }

        private static class GroupStateLazyStore {
            private static final AtomicIntegerFieldUpdater<GroupStateLazyStore> initGuardUpdater = AtomicIntegerFieldUpdater.newUpdater(GroupStateLazyStore.class, "initGuard");
            private volatile Map<Integer, GroupState> grpStates;
            private final CountDownLatch latch;
            private volatile int initGuard;
            private IgniteCheckedException initEx;

            private GroupStateLazyStore() {
                this((Map<Integer, CacheState>)null);
            }

            private GroupStateLazyStore(Map<Integer, CacheState> cacheGrpStates) {
                if (cacheGrpStates != null) {
                    this.initGuard = 1;
                    this.latch = new CountDownLatch(0);
                } else {
                    this.latch = new CountDownLatch(1);
                }
                this.grpStates = this.remap(cacheGrpStates);
            }

            private Map<Integer, GroupState> remap(Map<Integer, CacheState> stateRec) {
                if (stateRec == null) {
                    return null;
                }
                HashMap<Integer, GroupState> grpStates = new HashMap<Integer, GroupState>(stateRec.size());
                for (Integer grpId : stateRec.keySet()) {
                    CacheState recState = stateRec.get(grpId);
                    GroupState groupState = new GroupState(recState.size());
                    for (int i = 0; i < recState.size(); ++i) {
                        groupState.addPartitionCounter(recState.partitionByIndex(i), recState.partitionCounterByIndex(i));
                    }
                    grpStates.put(grpId, groupState);
                }
                return grpStates;
            }

            private Long partitionCounter(int grpId, int part) {
                assert (this.initGuard != 0) : this.initGuard;
                if (this.initEx != null || this.grpStates == null) {
                    return null;
                }
                GroupState state = this.grpStates.get(grpId);
                if (state != null) {
                    long cntr = state.counterByPartition(part);
                    return cntr < 0L ? null : Long.valueOf(cntr);
                }
                return null;
            }

            private void initIfNeeded(GridCacheSharedContext cctx, WALPointer ptr) throws IgniteCheckedException {
                if (initGuardUpdater.compareAndSet(this, 0, 1)) {
                    try (WALIterator it = cctx.wal().replay(ptr);){
                        if (it.hasNextX()) {
                            IgniteBiTuple tup = (IgniteBiTuple)it.nextX();
                            CheckpointRecord rec = (CheckpointRecord)tup.get2();
                            Map<Integer, CacheState> stateRec = rec.cacheGroupStates();
                            if (stateRec != null) {
                                this.grpStates = this.remap(stateRec);
                            }
                            this.grpStates = Collections.emptyMap();
                        }
                        this.initEx = new IgniteCheckedException("Failed to find checkpoint record at the given WAL pointer: " + ptr);
                    }
                    catch (IgniteCheckedException e) {
                        this.initEx = e;
                        throw e;
                    }
                    finally {
                        this.latch.countDown();
                    }
                } else {
                    U.await(this.latch);
                    if (this.initEx != null) {
                        throw this.initEx;
                    }
                }
            }
        }

        private static class GroupState {
            private int[] parts;
            private long[] cnts;
            private int idx;

            private GroupState(int partsCnt) {
                this.parts = new int[partsCnt];
                this.cnts = new long[partsCnt];
            }

            public void addPartitionCounter(int partId, long cntr) {
                if (this.idx == this.parts.length) {
                    throw new IllegalStateException("Failed to add new partition to the partitions state (no enough space reserved) [partId=" + partId + ", reserved=" + this.parts.length + ']');
                }
                if (this.idx > 0 && this.parts[this.idx - 1] >= partId) {
                    throw new IllegalStateException("Adding partition in a wrong order [prev=" + this.parts[this.idx - 1] + ", cur=" + partId + ']');
                }
                this.parts[this.idx] = partId;
                this.cnts[this.idx] = cntr;
                ++this.idx;
            }

            public long counterByPartition(int partId) {
                int idx = this.indexByPartition(partId);
                return idx >= 0 ? this.cnts[idx] : 0L;
            }

            public long size() {
                return this.idx;
            }

            private int indexByPartition(int partId) {
                return Arrays.binarySearch(this.parts, 0, this.idx, partId);
            }

            public String toString() {
                return "GroupState [cap=" + this.parts.length + ", size=" + this.idx + ']';
            }
        }
    }

    public class CheckpointHistory {
        private final NavigableMap<Long, CheckpointEntry> histMap = new ConcurrentSkipListMap<Long, CheckpointEntry>();

        private void loadHistory(File dir) throws IgniteCheckedException {
            if (!dir.exists()) {
                return;
            }
            File[] files = dir.listFiles(CP_FILE_FILTER);
            if (!F.isEmpty(files)) {
                Arrays.sort(files, CP_TS_COMPARATOR);
                ByteBuffer buf = ByteBuffer.allocate(16);
                buf.order(ByteOrder.nativeOrder());
                for (File file : files) {
                    CheckpointEntryType type;
                    Matcher matcher = CP_FILE_NAME_PATTERN.matcher(file.getName());
                    if (!matcher.matches() || (type = CheckpointEntryType.valueOf(matcher.group(3))) != CheckpointEntryType.START) continue;
                    long cpTs = Long.parseLong(matcher.group(1));
                    UUID cpId = UUID.fromString(matcher.group(2));
                    WALPointer ptr = GridCacheDatabaseSharedManager.this.readPointer(file, buf);
                    if (ptr == null) continue;
                    CheckpointEntry entry = GridCacheDatabaseSharedManager.this.createCheckPointEntry(cpTs, ptr, cpId, null, type);
                    this.histMap.put(cpTs, entry);
                }
            }
        }

        private CheckpointEntry entry(Long cpTs) throws IgniteCheckedException {
            CheckpointEntry entry = (CheckpointEntry)this.histMap.get(cpTs);
            if (entry == null) {
                throw new IgniteCheckedException("Checkpoint entry was removed: " + cpTs);
            }
            return entry;
        }

        public Collection<Long> checkpoints() {
            return this.histMap.keySet();
        }

        private void addCheckpointEntry(CheckpointEntry entry) {
            this.histMap.put(entry.checkpointTimestamp(), entry);
        }

        private void onWalTruncated(WALPointer ptr) {
            CheckpointEntry cpEntry2;
            FileWALPointer cpPnt;
            FileWALPointer highBound = (FileWALPointer)ptr;
            ArrayList<CheckpointEntry> cpToRemove = new ArrayList<CheckpointEntry>();
            Iterator<Object> iterator = this.histMap.values().iterator();
            while (iterator.hasNext() && highBound.compareTo(cpPnt = (FileWALPointer)(cpEntry2 = (CheckpointEntry)iterator.next()).checkpointMark()) > 0) {
                if (GridCacheDatabaseSharedManager.this.cctx.wal().reserved(cpEntry2.checkpointMark())) {
                    U.warn(GridCacheDatabaseSharedManager.this.log, "Could not clear historyMap due to WAL reservation on cpEntry " + cpEntry2.cpId + ", history map size is " + this.histMap.size());
                    break;
                }
                if (this.removeCheckpointFiles(cpEntry2)) continue;
                cpToRemove.add(cpEntry2);
            }
            for (CheckpointEntry cpEntry2 : cpToRemove) {
                this.histMap.remove(cpEntry2.cpTs);
            }
        }

        private void onCheckpointFinished(Checkpoint chp) {
            boolean dropWal;
            int deleted = 0;
            boolean bl = dropWal = GridCacheDatabaseSharedManager.this.persistenceCfg.getWalHistorySize() != Integer.MAX_VALUE;
            while (this.histMap.size() > GridCacheDatabaseSharedManager.this.maxCpHistMemSize) {
                Map.Entry<Long, CheckpointEntry> entry = this.histMap.firstEntry();
                CheckpointEntry cpEntry = entry.getValue();
                if (GridCacheDatabaseSharedManager.this.cctx.wal().reserved(cpEntry.checkpointMark())) {
                    U.warn(GridCacheDatabaseSharedManager.this.log, "Could not clear historyMap due to WAL reservation on cpEntry " + cpEntry.cpId + ", history map size is " + this.histMap.size());
                    break;
                }
                boolean fail = this.removeCheckpointFiles(cpEntry);
                if (fail) break;
                if (dropWal) {
                    deleted += GridCacheDatabaseSharedManager.this.cctx.wal().truncate(null, cpEntry.checkpointMark());
                }
                this.histMap.remove(entry.getKey());
            }
            chp.walFilesDeleted = deleted;
            if (!chp.cpPages.isEmpty()) {
                GridCacheDatabaseSharedManager.this.cctx.wal().allowCompressionUntil(chp.cpEntry.checkpointMark());
            }
        }

        private boolean removeCheckpointFiles(CheckpointEntry cpEntry) {
            boolean fail;
            File startFile = new File(GridCacheDatabaseSharedManager.this.cpDir.getAbsolutePath(), cpEntry.startFile());
            File endFile = new File(GridCacheDatabaseSharedManager.this.cpDir.getAbsolutePath(), cpEntry.endFile());
            boolean rmvdStart = !startFile.exists() || startFile.delete();
            boolean rmvdEnd = !endFile.exists() || endFile.delete();
            boolean bl = fail = !rmvdStart || !rmvdEnd;
            if (fail) {
                U.warn(GridCacheDatabaseSharedManager.this.log, "Failed to remove stale checkpoint files [startFile=" + startFile.getAbsolutePath() + ", endFile=" + endFile.getAbsolutePath() + ']');
                if (this.histMap.size() > 2 * GridCacheDatabaseSharedManager.this.maxCpHistMemSize) {
                    U.error(GridCacheDatabaseSharedManager.this.log, "Too many stale checkpoint entries in the map, will truncate WAL archive anyway.");
                    fail = false;
                }
            }
            return fail;
        }

        static /* synthetic */ void access$2600(CheckpointHistory x0, File x1) throws IgniteCheckedException {
            x0.loadHistory(x1);
        }
    }

    private static class CheckpointProgressSnapshot
    implements CheckpointFuture {
        private final boolean started;
        private final GridFutureAdapter<Object> cpBeginFut;
        private final GridFutureAdapter<Object> cpFinishFut;

        CheckpointProgressSnapshot(CheckpointProgress cpProgress) {
            this.started = cpProgress.started;
            this.cpBeginFut = cpProgress.cpBeginFut;
            this.cpFinishFut = cpProgress.cpFinishFut;
        }

        @Override
        public GridFutureAdapter beginFuture() {
            return this.cpBeginFut;
        }

        @Override
        public GridFutureAdapter finishFuture() {
            return this.cpFinishFut;
        }
    }

    private static class CheckpointProgress {
        private volatile long nextCpTs;
        private GridFutureAdapter cpBeginFut = new GridFutureAdapter();
        private GridFutureAdapter cpFinishFut = new GridFutureAdapter<Void>(){

            @Override
            protected boolean onDone(@Nullable Void res, @Nullable Throwable err, boolean cancel) {
                if (err != null && !cpBeginFut.isDone()) {
                    cpBeginFut.onDone(err);
                }
                return super.onDone(res, err, cancel);
            }
        };
        private volatile boolean nextSnapshot;
        private volatile boolean started;
        private volatile SnapshotOperation snapshotOperation;
        private final PartitionDestroyQueue destroyQueue = new PartitionDestroyQueue();
        private String reason;

        private CheckpointProgress(long nextCpTs) {
            this.nextCpTs = nextCpTs;
        }
    }

    private static class CheckpointStatus {
        private static final UUID NULL_UUID = new UUID(0L, 0L);
        private static final WALPointer NULL_PTR = new FileWALPointer(0L, 0, 0);
        private long cpStartTs;
        private UUID cpStartId;
        @GridToStringInclude
        private WALPointer startPtr;
        private UUID cpEndId;
        @GridToStringInclude
        private WALPointer endPtr;

        private CheckpointStatus(long cpStartTs, UUID cpStartId, WALPointer startPtr, UUID cpEndId, WALPointer endPtr) {
            this.cpStartTs = cpStartTs;
            this.cpStartId = cpStartId;
            this.startPtr = startPtr;
            this.cpEndId = cpEndId;
            this.endPtr = endPtr;
        }

        public boolean needRestoreMemory() {
            return !F.eq(this.cpStartId, this.cpEndId) && !F.eq(NULL_UUID, this.cpStartId);
        }

        public String toString() {
            return S.toString(CheckpointStatus.class, this);
        }

        static /* synthetic */ UUID access$2400(CheckpointStatus x0) {
            return x0.cpEndId;
        }

        static /* synthetic */ long access$2500(CheckpointStatus x0) {
            return x0.cpStartTs;
        }
    }

    private static class Checkpoint {
        @Nullable
        private final CheckpointEntry cpEntry;
        private final GridMultiCollectionWrapper<FullPageId> cpPages;
        private final CheckpointProgress progress;
        private int walFilesDeleted;
        private final int pagesSize;

        private Checkpoint(@Nullable CheckpointEntry cpEntry, @NotNull GridMultiCollectionWrapper<FullPageId> cpPages, CheckpointProgress progress) {
            this.cpEntry = cpEntry;
            this.cpPages = cpPages;
            this.progress = progress;
            this.pagesSize = cpPages.size();
        }

        private boolean hasDelta() {
            return this.pagesSize != 0;
        }
    }

    private static enum CheckpointEntryType {
        START,
        END;

    }

    private class WriteCheckpointPages
    implements Runnable {
        private CheckpointMetricsTracker tracker;
        private Collection<FullPageId> writePageIds;
        private ConcurrentLinkedHashMap<PageStore, LongAdder> updStores;
        private CountDownFuture doneFut;
        private final int totalPagesToWrite;

        private WriteCheckpointPages(CheckpointMetricsTracker tracker, Collection<FullPageId> writePageIds, ConcurrentLinkedHashMap<PageStore, LongAdder> updStores, CountDownFuture doneFut, int totalPagesToWrite) {
            this.tracker = tracker;
            this.writePageIds = writePageIds;
            this.updStores = updStores;
            this.doneFut = doneFut;
            this.totalPagesToWrite = totalPagesToWrite;
        }

        @Override
        public void run() {
            ByteBuffer tmpWriteBuf = (ByteBuffer)GridCacheDatabaseSharedManager.this.threadBuf.get();
            long writeAddr = GridUnsafe.bufferAddress(tmpWriteBuf);
            GridCacheDatabaseSharedManager.this.snapshotMgr.beforeCheckpointPageWritten();
            try {
                for (FullPageId fullId : this.writePageIds) {
                    int pageType;
                    Integer tag;
                    PageMemoryEx pageMem;
                    if (GridCacheDatabaseSharedManager.this.checkpointer.shutdownNow) break;
                    tmpWriteBuf.rewind();
                    GridCacheDatabaseSharedManager.this.snapshotMgr.beforePageWrite(fullId);
                    int grpId = fullId.groupId();
                    if (grpId != MetaStorage.METASTORAGE_CACHE_ID) {
                        CacheGroupContext grp = GridCacheDatabaseSharedManager.this.context().cache().cacheGroup(grpId);
                        if (grp == null || !grp.dataRegion().config().isPersistenceEnabled()) continue;
                        pageMem = (PageMemoryEx)grp.dataRegion().pageMemory();
                    } else {
                        pageMem = (PageMemoryEx)GridCacheDatabaseSharedManager.this.metaStorage.pageMemory();
                    }
                    if ((tag = pageMem.getForCheckpoint(fullId, tmpWriteBuf, GridCacheDatabaseSharedManager.this.persStoreMetrics.metricsEnabled() ? this.tracker : null)) == null) continue;
                    assert (PageIO.getType(tmpWriteBuf) != 0) : "Invalid state. Type is 0! pageId = " + U.hexLong(fullId.pageId());
                    assert (PageIO.getVersion(tmpWriteBuf) != 0) : "Invalid state. Version is 0! pageId = " + U.hexLong(fullId.pageId());
                    tmpWriteBuf.rewind();
                    if (GridCacheDatabaseSharedManager.this.persStoreMetrics.metricsEnabled() && PageIO.isDataPageType(pageType = PageIO.getType(tmpWriteBuf))) {
                        this.tracker.onDataPageWritten();
                    }
                    if (!GridCacheDatabaseSharedManager.this.skipCrc) {
                        PageIO.setCrc(writeAddr, PureJavaCrc32.calcCrc32(tmpWriteBuf, GridCacheDatabaseSharedManager.this.pageSize()));
                        tmpWriteBuf.rewind();
                    }
                    int curWrittenPages = GridCacheDatabaseSharedManager.this.writtenPagesCntr.incrementAndGet();
                    GridCacheDatabaseSharedManager.this.snapshotMgr.onPageWrite(fullId, tmpWriteBuf, curWrittenPages, this.totalPagesToWrite);
                    tmpWriteBuf.rewind();
                    PageStore store = GridCacheDatabaseSharedManager.this.storeMgr.writeInternal(grpId, fullId.pageId(), tmpWriteBuf, tag, false);
                    this.updStores.computeIfAbsent(store, k -> new LongAdder()).increment();
                }
                this.doneFut.onDone((Void)null);
            }
            catch (Throwable e) {
                this.doneFut.onDone(e);
            }
        }
    }

    public class Checkpointer
    extends GridWorker {
        private final ByteBuffer tmpWriteBuf;
        private volatile CheckpointProgress scheduledCp;
        @Nullable
        private volatile CheckpointProgress curCpProgress;
        private volatile boolean shutdownNow;
        private long lastCpTs;

        protected Checkpointer(String gridName, String name, IgniteLogger log) {
            super(gridName, name, log);
            this.scheduledCp = new CheckpointProgress(U.currentTimeMillis() + GridCacheDatabaseSharedManager.this.checkpointFreq);
            this.tmpWriteBuf = ByteBuffer.allocateDirect(GridCacheDatabaseSharedManager.this.pageSize());
            this.tmpWriteBuf.order(ByteOrder.nativeOrder());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void body() {
            Throwable err = null;
            try {
                while (!this.isCancelled()) {
                    this.waitCheckpointEvent();
                    GridFutureAdapter enableChangeApplied = GridCacheDatabaseSharedManager.this.enableChangeApplied;
                    if (enableChangeApplied != null) {
                        enableChangeApplied.onDone();
                        GridCacheDatabaseSharedManager.this.enableChangeApplied = null;
                    }
                    if (GridCacheDatabaseSharedManager.this.checkpointsEnabled) {
                        this.doCheckpoint();
                        continue;
                    }
                    Checkpointer checkpointer = this;
                    synchronized (checkpointer) {
                        this.scheduledCp.nextCpTs = U.currentTimeMillis() + GridCacheDatabaseSharedManager.this.checkpointFreq;
                    }
                }
            }
            catch (Throwable t) {
                err = t;
                this.scheduledCp.cpFinishFut.onDone(t);
                throw t;
            }
            finally {
                if (!(err != null || GridCacheDatabaseSharedManager.this.stopping && this.isCancelled)) {
                    err = new IllegalStateException("Thread " + this.name() + " is terminated unexpectedly");
                }
                if (err instanceof OutOfMemoryError) {
                    GridCacheDatabaseSharedManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    GridCacheDatabaseSharedManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
            if (!GridCacheDatabaseSharedManager.this.checkpointsEnabled) return;
            if (this.shutdownNow) return;
            try {
                this.doCheckpoint();
                this.scheduledCp.cpFinishFut.onDone(new NodeStoppingException("Node is stopping."));
                return;
            }
            catch (Throwable e) {
                this.scheduledCp.cpFinishFut.onDone(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CheckpointProgressSnapshot wakeupForCheckpoint(long delayFromNow, String reason) {
            CheckpointProgressSnapshot ret;
            CheckpointProgress sched = this.scheduledCp;
            long next = U.currentTimeMillis() + delayFromNow;
            if (sched.nextCpTs <= next) {
                return new CheckpointProgressSnapshot(sched);
            }
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                sched = this.scheduledCp;
                if (sched.nextCpTs > next) {
                    sched.reason = reason;
                    sched.nextCpTs = next;
                }
                ret = new CheckpointProgressSnapshot(sched);
                this.notifyAll();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IgniteInternalFuture wakeupForSnapshotCreation(SnapshotOperation snapshotOperation) {
            GridFutureAdapter ret;
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                this.scheduledCp.nextCpTs = U.currentTimeMillis();
                this.scheduledCp.reason = "snapshot";
                this.scheduledCp.nextSnapshot = true;
                this.scheduledCp.snapshotOperation = snapshotOperation;
                ret = this.scheduledCp.cpBeginFut;
                this.notifyAll();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doCheckpoint() {
            try {
                int destroyedPartitionsCnt;
                CheckpointMetricsTracker tracker = new CheckpointMetricsTracker();
                Checkpoint chp = this.markCheckpointBegin(tracker);
                GridCacheDatabaseSharedManager.this.currCheckpointPagesCnt = chp.pagesSize;
                GridCacheDatabaseSharedManager.this.writtenPagesCntr = new AtomicInteger();
                GridCacheDatabaseSharedManager.this.syncedPagesCntr = new AtomicInteger();
                GridCacheDatabaseSharedManager.this.evictedPagesCntr = new AtomicInteger();
                boolean success = false;
                try {
                    if (chp.hasDelta()) {
                        ConcurrentLinkedHashMap updStores = new ConcurrentLinkedHashMap();
                        CountDownFuture doneWriteFut = new CountDownFuture(GridCacheDatabaseSharedManager.this.asyncRunner == null ? 1 : chp.cpPages.collectionsSize());
                        tracker.onPagesWriteStart();
                        int totalPagesToWriteCnt = chp.cpPages.size();
                        if (GridCacheDatabaseSharedManager.this.asyncRunner != null) {
                            for (int i = 0; i < chp.cpPages.collectionsSize(); ++i) {
                                WriteCheckpointPages write = new WriteCheckpointPages(tracker, chp.cpPages.innerCollection(i), updStores, doneWriteFut, totalPagesToWriteCnt);
                                try {
                                    GridCacheDatabaseSharedManager.this.asyncRunner.execute(write);
                                    continue;
                                }
                                catch (RejectedExecutionException ignore) {
                                    write.run();
                                }
                            }
                        } else {
                            WriteCheckpointPages write = new WriteCheckpointPages(tracker, chp.cpPages, updStores, doneWriteFut, totalPagesToWriteCnt);
                            write.run();
                        }
                        try {
                            doneWriteFut.get();
                        }
                        catch (IgniteCheckedException e) {
                            chp.progress.cpFinishFut.onDone(e);
                            GridCacheDatabaseSharedManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                            if (success) {
                                this.markCheckpointEnd(chp);
                            }
                            return;
                        }
                        if (this.shutdownNow) {
                            chp.progress.cpFinishFut.onDone(new NodeStoppingException("Node is stopping."));
                            return;
                        }
                        tracker.onFsyncStart();
                        if (!GridCacheDatabaseSharedManager.this.skipSync) {
                            for (Map.Entry updStoreEntry : updStores.entrySet()) {
                                if (this.shutdownNow) {
                                    chp.progress.cpFinishFut.onDone(new NodeStoppingException("Node is stopping."));
                                    return;
                                }
                                ((PageStore)updStoreEntry.getKey()).sync();
                                GridCacheDatabaseSharedManager.this.syncedPagesCntr.addAndGet(((LongAdder)updStoreEntry.getValue()).intValue());
                            }
                        }
                    } else {
                        tracker.onPagesWriteStart();
                        tracker.onFsyncStart();
                    }
                    GridCacheDatabaseSharedManager.this.snapshotMgr.afterCheckpointPageWritten();
                    try {
                        destroyedPartitionsCnt = this.destroyEvictedPartitions();
                    }
                    catch (IgniteCheckedException e) {
                        chp.progress.cpFinishFut.onDone(e);
                        GridCacheDatabaseSharedManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                        if (success) {
                            this.markCheckpointEnd(chp);
                        }
                        return;
                    }
                    success = true;
                }
                finally {
                    if (success) {
                        this.markCheckpointEnd(chp);
                    }
                }
                tracker.onEnd();
                if (chp.hasDelta() || destroyedPartitionsCnt > 0) {
                    if (GridCacheDatabaseSharedManager.this.printCheckpointStats && this.log.isInfoEnabled()) {
                        this.log.info(String.format("Checkpoint finished [cpId=%s, pages=%d, markPos=%s, walSegmentsCleared=%d, markDuration=%dms, pagesWrite=%dms, fsync=%dms, total=%dms]", chp.cpEntry != null ? chp.cpEntry.checkpointId() : "", chp.pagesSize, chp.cpEntry != null ? chp.cpEntry.checkpointMark() : "", chp.walFilesDeleted, tracker.markDuration(), tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.totalDuration()));
                    }
                    GridCacheDatabaseSharedManager.this.persStoreMetrics.onCheckpoint(tracker.lockWaitDuration(), tracker.markDuration(), tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.totalDuration(), chp.pagesSize, tracker.dataPagesWritten(), tracker.cowPagesWritten());
                } else {
                    GridCacheDatabaseSharedManager.this.persStoreMetrics.onCheckpoint(tracker.lockWaitDuration(), tracker.markDuration(), tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.totalDuration(), chp.pagesSize, tracker.dataPagesWritten(), tracker.cowPagesWritten());
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to create checkpoint.", e);
            }
        }

        private int destroyEvictedPartitions() throws IgniteCheckedException {
            PartitionDestroyQueue destroyQueue = this.curCpProgress.destroyQueue;
            if (destroyQueue.pendingReqs.isEmpty()) {
                return 0;
            }
            ArrayList<PartitionDestroyRequest> reqs = null;
            for (PartitionDestroyRequest req : destroyQueue.pendingReqs.values()) {
                if (!req.beginDestroy()) continue;
                int grpId = req.grpId;
                int partId = req.partId;
                CacheGroupContext grp = GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroup(grpId);
                assert (grp != null) : "Cache group is not initialized [grpId=" + grpId + "]";
                assert (grp.offheap() instanceof GridCacheOffheapManager) : "Destroying partition files when persistence is off " + grp.offheap();
                GridCacheOffheapManager offheap = (GridCacheOffheapManager)grp.offheap();
                Runnable destroyPartTask = () -> {
                    try {
                        offheap.destroyPartitionStore(grpId, partId);
                        req.onDone(null);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Partition file has destroyed [grpId=" + grpId + ", partId=" + partId + "]");
                        }
                    }
                    catch (Exception e) {
                        req.onDone(new IgniteCheckedException("Partition file destroy has failed [grpId=" + grpId + ", partId=" + partId + "]", e));
                    }
                };
                if (GridCacheDatabaseSharedManager.this.asyncRunner != null) {
                    try {
                        GridCacheDatabaseSharedManager.this.asyncRunner.execute(destroyPartTask);
                    }
                    catch (RejectedExecutionException ignore) {
                        destroyPartTask.run();
                    }
                } else {
                    destroyPartTask.run();
                }
                if (reqs == null) {
                    reqs = new ArrayList<PartitionDestroyRequest>();
                }
                reqs.add(req);
            }
            if (reqs != null) {
                for (PartitionDestroyRequest req : reqs) {
                    req.waitCompleted();
                }
            }
            destroyQueue.pendingReqs.clear();
            return reqs != null ? reqs.size() : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void schedulePartitionDestroy(@Nullable CacheGroupContext grpCtx, int grpId, int partId) {
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                this.scheduledCp.destroyQueue.addDestroyRequest(grpCtx, grpId, partId);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition file has been scheduled to destroy [grpId=" + grpId + ", partId=" + partId + "]");
            }
            if (grpCtx != null) {
                this.wakeupForCheckpoint(30000L, "partition destroy");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelOrWaitPartitionDestroy(int grpId, int partId) throws IgniteCheckedException {
            PartitionDestroyRequest req;
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                req = this.scheduledCp.destroyQueue.cancelDestroy(grpId, partId);
            }
            if (req != null) {
                req.waitCompleted();
            }
            Checkpointer checkpointer2 = this;
            synchronized (checkpointer2) {
                CheckpointProgress cur = this.curCpProgress;
                if (cur != null) {
                    req = cur.destroyQueue.cancelDestroy(grpId, partId);
                }
            }
            if (req != null) {
                req.waitCompleted();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Partition file destroy has cancelled [grpId=" + grpId + ", partId=" + partId + "]");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitCheckpointEvent() {
            boolean cancel = false;
            try {
                long now = U.currentTimeMillis();
                Checkpointer checkpointer = this;
                synchronized (checkpointer) {
                    long remaining;
                    while ((remaining = this.scheduledCp.nextCpTs - now) > 0L && !this.isCancelled()) {
                        this.wait(remaining);
                        now = U.currentTimeMillis();
                    }
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                cancel = true;
            }
            if (cancel) {
                this.isCancelled = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Checkpoint markCheckpointBegin(CheckpointMetricsTracker tracker) throws IgniteCheckedException {
            boolean hasPages;
            IgniteBiTuple<Collection<GridMultiCollectionWrapper<FullPageId>>, Integer> cpPagesTuple;
            CheckpointProgress curr;
            CheckpointRecord cpRec = new CheckpointRecord(null);
            WALPointer cpPtr = null;
            tracker.onLockWaitStart();
            IgniteFuture<?> snapFut = null;
            GridCacheDatabaseSharedManager.this.checkpointLock.writeLock().lock();
            try {
                tracker.onMarkStart();
                Checkpointer checkpointer = this;
                synchronized (checkpointer) {
                    curr = this.scheduledCp;
                    curr.started = true;
                    if (curr.reason == null) {
                        curr.reason = "timeout";
                    }
                    this.scheduledCp = new CheckpointProgress(U.currentTimeMillis() + GridCacheDatabaseSharedManager.this.checkpointFreq);
                    this.curCpProgress = curr;
                }
                final PartitionAllocationMap map = new PartitionAllocationMap();
                DbCheckpointListener.Context ctx0 = new DbCheckpointListener.Context(){

                    @Override
                    public boolean nextSnapshot() {
                        return curr.nextSnapshot;
                    }

                    @Override
                    public PartitionAllocationMap partitionStatMap() {
                        return map;
                    }

                    @Override
                    public boolean needToSnapshot(String cacheOrGrpName) {
                        return curr.snapshotOperation.cacheGroupIds().contains(CU.cacheId(cacheOrGrpName));
                    }
                };
                for (DbCheckpointListener lsnr : GridCacheDatabaseSharedManager.this.lsnrs) {
                    lsnr.onCheckpointBegin(ctx0);
                }
                if (curr.nextSnapshot) {
                    snapFut = GridCacheDatabaseSharedManager.this.snapshotMgr.onMarkCheckPointBegin(curr.snapshotOperation, map);
                }
                for (CacheGroupContext grp : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (grp.isLocal() || !grp.walEnabled()) continue;
                    ArrayList<GridDhtLocalPartition> parts = new ArrayList<GridDhtLocalPartition>();
                    for (GridDhtLocalPartition part : grp.topology().currentLocalPartitions()) {
                        parts.add(part);
                    }
                    CacheState state = new CacheState(parts.size());
                    for (GridDhtLocalPartition part : parts) {
                        state.addPartitionState(part.id(), part.dataStore().fullSize(), part.updateCounter(), (byte)part.state().ordinal());
                    }
                    cpRec.addCacheGroupState(grp.groupId(), state);
                }
                cpPagesTuple = this.beginAllCheckpoints();
                hasPages = this.hasPageForWrite(cpPagesTuple.get1());
                if ((hasPages || curr.nextSnapshot || !curr.destroyQueue.pendingReqs.isEmpty()) && (cpPtr = GridCacheDatabaseSharedManager.this.cctx.wal().log(cpRec)) == null) {
                    cpPtr = CheckpointStatus.NULL_PTR;
                }
            }
            finally {
                GridCacheDatabaseSharedManager.this.checkpointLock.writeLock().unlock();
                tracker.onLockRelease();
            }
            curr.cpBeginFut.onDone();
            if (snapFut != null) {
                try {
                    snapFut.get();
                }
                catch (IgniteException e) {
                    U.error(this.log, "Failed to wait for snapshot operation initialization: " + curr.snapshotOperation + "]", e);
                }
            }
            if (hasPages || !curr.destroyQueue.pendingReqs.isEmpty()) {
                assert (cpPtr != null);
                tracker.onWalCpRecordFsyncStart();
                GridCacheDatabaseSharedManager.this.cctx.wal().flush(cpPtr, true);
                tracker.onWalCpRecordFsyncEnd();
                long cpTs = System.currentTimeMillis();
                if (cpTs == this.lastCpTs) {
                    ++cpTs;
                }
                this.lastCpTs = cpTs;
                CheckpointEntry cpEntry = GridCacheDatabaseSharedManager.this.writeCheckpointEntry(this.tmpWriteBuf, cpTs, cpRec.checkpointId(), cpPtr, cpRec, CheckpointEntryType.START);
                GridCacheDatabaseSharedManager.this.checkpointHist.addCheckpointEntry(cpEntry);
                GridMultiCollectionWrapper cpPages = GridCacheDatabaseSharedManager.this.splitAndSortCpPagesIfNeeded(cpPagesTuple);
                if (GridCacheDatabaseSharedManager.this.printCheckpointStats && this.log.isInfoEnabled()) {
                    this.log.info(String.format("Checkpoint started [checkpointId=%s, startPtr=%s, checkpointLockWait=%dms, checkpointLockHoldTime=%dms, walCpRecordFsyncDuration=%dms, pages=%d, reason='%s']", cpRec.checkpointId(), cpPtr, tracker.lockWaitDuration(), tracker.lockHoldDuration(), tracker.walCpRecordFsyncDuration(), cpPages.size(), curr.reason));
                }
                return new Checkpoint(cpEntry, cpPages, curr);
            }
            if (curr.nextSnapshot) {
                GridCacheDatabaseSharedManager.this.cctx.wal().flush(null, true);
            }
            if (GridCacheDatabaseSharedManager.this.printCheckpointStats && this.log.isInfoEnabled()) {
                LT.info(this.log, String.format("Skipping checkpoint (no pages were modified) [checkpointLockWait=%dms, checkpointLockHoldTime=%dms, reason='%s']", tracker.lockWaitDuration(), tracker.lockHoldDuration(), curr.reason));
            }
            GridMultiCollectionWrapper wrapper = new GridMultiCollectionWrapper(new Collection[0]);
            return new Checkpoint(null, wrapper, curr);
        }

        private boolean hasPageForWrite(Collection<GridMultiCollectionWrapper<FullPageId>> cpPagesCollWrapper) {
            boolean hasPages = false;
            for (Collection collection : cpPagesCollWrapper) {
                if (collection.isEmpty()) continue;
                hasPages = true;
                break;
            }
            return hasPages;
        }

        private IgniteBiTuple<Collection<GridMultiCollectionWrapper<FullPageId>>, Integer> beginAllCheckpoints() {
            ArrayList<GridMultiCollectionWrapper<FullPageId>> res = new ArrayList<GridMultiCollectionWrapper<FullPageId>>(GridCacheDatabaseSharedManager.this.dataRegions().size());
            int pagesNum = 0;
            for (DataRegion memPlc : GridCacheDatabaseSharedManager.this.dataRegions()) {
                if (!memPlc.config().isPersistenceEnabled()) continue;
                GridMultiCollectionWrapper<FullPageId> nextCpPagesCol = ((PageMemoryEx)memPlc.pageMemory()).beginCheckpoint();
                pagesNum += nextCpPagesCol.size();
                res.add(nextCpPagesCol);
            }
            GridCacheDatabaseSharedManager.this.currCheckpointPagesCnt = pagesNum;
            return new IgniteBiTuple<Collection<GridMultiCollectionWrapper<FullPageId>>, Integer>(res, pagesNum);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markCheckpointEnd(Checkpoint chp) throws IgniteCheckedException {
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                GridCacheDatabaseSharedManager.this.writtenPagesCntr = null;
                GridCacheDatabaseSharedManager.this.syncedPagesCntr = null;
                GridCacheDatabaseSharedManager.this.evictedPagesCntr = null;
                for (DataRegion memPlc : GridCacheDatabaseSharedManager.this.dataRegions()) {
                    if (!memPlc.config().isPersistenceEnabled()) continue;
                    ((PageMemoryEx)memPlc.pageMemory()).finishCheckpoint();
                }
                if (chp.hasDelta()) {
                    GridCacheDatabaseSharedManager.this.writeCheckpointEntry(this.tmpWriteBuf, chp.cpEntry.checkpointTimestamp(), chp.cpEntry.checkpointId(), chp.cpEntry.checkpointMark(), null, CheckpointEntryType.END);
                }
                GridCacheDatabaseSharedManager.this.currCheckpointPagesCnt = 0;
            }
            GridCacheDatabaseSharedManager.this.checkpointHist.onCheckpointFinished(chp);
            if (chp.progress != null) {
                chp.progress.cpFinishFut.onDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cancelling grid runnable: " + this);
            }
            this.isCancelled = true;
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                this.notifyAll();
            }
        }

        public void shutdownNow() {
            this.shutdownNow = true;
            if (!this.isCancelled) {
                this.cancel();
            }
        }
    }

    private static class PartitionDestroyRequest {
        private final int grpId;
        private final int partId;
        private boolean cancelled;
        private GridFutureAdapter<Void> destroyFut;

        private PartitionDestroyRequest(int grpId, int partId) {
            this.grpId = grpId;
            this.partId = partId;
        }

        private synchronized boolean cancel() {
            if (this.destroyFut != null) {
                assert (!this.cancelled);
                return false;
            }
            this.cancelled = true;
            return true;
        }

        private synchronized boolean beginDestroy() {
            if (this.cancelled) {
                assert (this.destroyFut == null);
                return false;
            }
            if (this.destroyFut != null) {
                return false;
            }
            this.destroyFut = new GridFutureAdapter();
            return true;
        }

        private synchronized void onDone(Throwable err) {
            assert (this.destroyFut != null);
            this.destroyFut.onDone(err);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitCompleted() throws IgniteCheckedException {
            GridFutureAdapter<Void> fut;
            PartitionDestroyRequest partitionDestroyRequest = this;
            synchronized (partitionDestroyRequest) {
                assert (this.destroyFut != null);
                fut = this.destroyFut;
            }
            fut.get();
        }

        public String toString() {
            return "PartitionDestroyRequest [grpId=" + this.grpId + ", partId=" + this.partId + ']';
        }
    }

    private static class PartitionDestroyQueue {
        private final ConcurrentMap<T2<Integer, Integer>, PartitionDestroyRequest> pendingReqs = new ConcurrentHashMap<T2<Integer, Integer>, PartitionDestroyRequest>();

        private PartitionDestroyQueue() {
        }

        private void addDestroyRequest(@Nullable CacheGroupContext grpCtx, int grpId, int partId) {
            PartitionDestroyRequest req = new PartitionDestroyRequest(grpId, partId);
            PartitionDestroyRequest old = this.pendingReqs.putIfAbsent(new T2<Integer, Integer>(grpId, partId), req);
            assert (old == null || grpCtx == null) : "Must wait for old destroy request to finish before adding a new one [grpId=" + grpId + ", grpName=" + grpCtx.cacheOrGroupName() + ", partId=" + partId + ']';
        }

        private PartitionDestroyRequest beginDestroy(T2<Integer, Integer> destroyId) {
            PartitionDestroyRequest rmvd = (PartitionDestroyRequest)this.pendingReqs.remove(destroyId);
            return rmvd == null ? null : (rmvd.beginDestroy() ? rmvd : null);
        }

        private PartitionDestroyRequest cancelDestroy(int grpId, int partId) {
            PartitionDestroyRequest rmvd = (PartitionDestroyRequest)this.pendingReqs.remove(new T2<Integer, Integer>(grpId, partId));
            return rmvd == null ? null : (!rmvd.cancel() ? rmvd : null);
        }
    }
}

