/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.Set;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class DynamicCacheChangeBatch
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id = IgniteUuid.randomUuid();
    @GridToStringInclude
    private Collection<DynamicCacheChangeRequest> reqs;
    private transient ExchangeActions exchangeActions;
    private boolean startCaches;
    private Set<String> restartingCaches;

    public DynamicCacheChangeBatch(Collection<DynamicCacheChangeRequest> reqs) {
        assert (!F.isEmpty(reqs)) : reqs;
        this.reqs = reqs;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean stopProcess() {
        return false;
    }

    @Override
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        return mgr.createDiscoCacheOnCacheChange(topVer, discoCache);
    }

    public Collection<DynamicCacheChangeRequest> requests() {
        return this.reqs;
    }

    public boolean exchangeNeeded() {
        return this.exchangeActions != null;
    }

    ExchangeActions exchangeActions() {
        return this.exchangeActions;
    }

    void exchangeActions(ExchangeActions exchangeActions) {
        assert (exchangeActions != null && !exchangeActions.empty()) : exchangeActions;
        this.exchangeActions = exchangeActions;
    }

    public boolean startCaches() {
        return this.startCaches;
    }

    public DynamicCacheChangeBatch restartingCaches(Set<String> restartingCaches) {
        this.restartingCaches = restartingCaches;
        return this;
    }

    public Set<String> restartingCaches() {
        return this.restartingCaches;
    }

    public void startCaches(boolean startCaches) {
        this.startCaches = startCaches;
    }

    public String toString() {
        return S.toString(DynamicCacheChangeBatch.class, this);
    }
}

